/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.parser;

import com.ibm.bpws.model.BPWSProcess;
import com.ibm.cs.bpws.model.BPWSProcessImpl;
import com.ibm.cs.bpws.parser.Printer;
import com.ibm.cs.bpws.runtime.BPWSRuntimeException;
import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.apache.xalan.processor.TransformerFactoryImpl;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BPWSParser {
    private static boolean verbose = true;
    private static Transformer transformer;
    private static Logger parserLogger;
    static /* synthetic */ Class class$com$ibm$cs$bpws$parser$BPWSParser;

    static {
        parserLogger = Logger.getLogger((String)"bpws.parser");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static Document getDocument(InputSource inputSource, String desc) throws BPWSRuntimeException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputSource);
            return doc;
        }
        catch (Throwable t) {
            throw new BPWSRuntimeException("BPWSParser: Problem parsing '" + desc + "':" + t.getMessage(), t);
        }
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + (class$com$ibm$cs$bpws$parser$BPWSParser != null ? class$com$ibm$cs$bpws$parser$BPWSParser : (class$com$ibm$cs$bpws$parser$BPWSParser = BPWSParser.class$("com.ibm.cs.bpws.parser.BPWSParser"))).getName() + " filename");
            System.exit(1);
        }
        BPWSProcess proc = BPWSParser.readBPWS(null, new URL("file", null, args[0]));
        try {
            Printer.LineTracker lineTracker = Printer.createLineTracker();
            Printer.printProcess(proc, new PrintWriter(System.out), lineTracker);
            Map lineNumberMap = lineTracker.getLineNumberMap();
            Iterator lineNumbers = lineNumberMap.keySet().iterator();
            while (lineNumbers.hasNext()) {
                Object object = lineNumbers.next();
                System.out.println("Object " + object + " is on line number " + lineNumberMap.get(object));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println();
    }

    public static BPWSProcess readBPWS(InputStream bpwsStream) throws BPWSRuntimeException {
        InputSource inputSource = new InputSource(new InputStreamReader(bpwsStream));
        Document doc = BPWSParser.getDocument(inputSource, "BPWSStream");
        return BPWSParser.readBPWS(null, new DOMSource(doc));
    }

    public static BPWSProcess readBPWS(URL contextURL, URL bpwsURL) throws BPWSRuntimeException {
        if (verbose) {
            parserLogger.debug((Object)("Retrieving document at '" + bpwsURL + "'" + (contextURL == null ? "." : ", relative to '" + contextURL + "'.")));
        }
        try {
            Reader reader = StringUtils.getContentAsReader((URL)bpwsURL);
            InputSource inputSource = new InputSource(reader);
            Document doc = BPWSParser.getDocument(inputSource, bpwsURL.toString());
            return BPWSParser.readBPWS(bpwsURL, new DOMSource(doc));
        }
        catch (IOException e2) {
            throw new BPWSRuntimeException("BPWS Parser: Error during I/O: " + e2.getMessage(), e2);
        }
    }

    private static BPWSProcess readBPWS(URL url, DOMSource doc) throws BPWSRuntimeException {
        if (transformer == null) {
            TransformerFactoryImpl tFactory = new TransformerFactoryImpl();
            Class cl = class$com$ibm$cs$bpws$parser$BPWSParser != null ? class$com$ibm$cs$bpws$parser$BPWSParser : (class$com$ibm$cs$bpws$parser$BPWSParser = BPWSParser.class$("com.ibm.cs.bpws.parser.BPWSParser"));
            InputStream is = cl.getResourceAsStream("/com/ibm/cs/bpws/parser/parser.xsl");
            if (is == null) {
                throw new BPWSRuntimeException("BPWSParser: Unable to load stylesheet!");
            }
            try {
                transformer = tFactory.newTransformer(new StreamSource(is));
            }
            catch (TransformerException e) {
                throw new BPWSRuntimeException("BPWSParser: error creating transformer: " + e.getMessage(), e);
            }
        }
        BPWSProcessImpl proc = new BPWSProcessImpl();
        transformer.setParameter("process", proc);
        try {
            transformer.transform(doc, new StreamResult(new StringWriter()));
        }
        catch (TransformerException e) {
            throw new BPWSRuntimeException("BPWSParser: error from XSLT: " + e.getMessage(), e);
        }
        return proc;
    }

    public static BPWSProcess readBPWSFromSource(InputSource source, String desc) throws BPWSRuntimeException {
        Document doc = BPWSParser.getDocument(source, desc);
        return BPWSParser.readBPWS(null, new DOMSource(doc));
    }

    public static void setVerbose(boolean verbose) {
        BPWSParser.verbose = verbose;
    }
}

