/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cs.bpws.parser;

import com.ibm.bpws.model.Activity;
import com.ibm.bpws.model.Assign;
import com.ibm.bpws.model.BPWSProcess;
import com.ibm.bpws.model.CaseClause;
import com.ibm.bpws.model.CatchAll;
import com.ibm.bpws.model.CatchFault;
import com.ibm.bpws.model.Compensate;
import com.ibm.bpws.model.CompensationHandler;
import com.ibm.bpws.model.Container;
import com.ibm.bpws.model.Containers;
import com.ibm.bpws.model.Copy;
import com.ibm.bpws.model.Correlation;
import com.ibm.bpws.model.CorrelationSet;
import com.ibm.bpws.model.CorrelationSets;
import com.ibm.bpws.model.Correlations;
import com.ibm.bpws.model.Empty;
import com.ibm.bpws.model.FaultHandlers;
import com.ibm.bpws.model.Flow;
import com.ibm.bpws.model.From;
import com.ibm.bpws.model.Invoke;
import com.ibm.bpws.model.Link;
import com.ibm.bpws.model.OnAlarm;
import com.ibm.bpws.model.OnMessage;
import com.ibm.bpws.model.Otherwise;
import com.ibm.bpws.model.Partner;
import com.ibm.bpws.model.Partners;
import com.ibm.bpws.model.Pick;
import com.ibm.bpws.model.Receive;
import com.ibm.bpws.model.Reply;
import com.ibm.bpws.model.Scope;
import com.ibm.bpws.model.Sequence;
import com.ibm.bpws.model.Source;
import com.ibm.bpws.model.SwitchBlock;
import com.ibm.bpws.model.Target;
import com.ibm.bpws.model.Terminate;
import com.ibm.bpws.model.Throw;
import com.ibm.bpws.model.To;
import com.ibm.bpws.model.Wait;
import com.ibm.bpws.model.While;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.NSStack;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Printer {
    private static final String INDENT = "  ";
    private static Logger printerLogger = Logger.getLogger((String)"bpws.parser.printer");

    private static String bool2YN(Boolean b) {
        return b != false ? "yes" : "no";
    }

    public static LineTracker createLineTracker() {
        return new LineTracker();
    }

    public static String escape(String s) {
        if (s == null) {
            return s;
        }
        int ltIndex = s.indexOf(60);
        StringBuffer sb = new StringBuffer(s);
        while (ltIndex != -1) {
            sb.replace(ltIndex, ltIndex + 1, "&lt;");
            ltIndex = sb.toString().indexOf(60);
        }
        s = sb.toString();
        int gtIndex = s.indexOf(62);
        while (gtIndex != -1) {
            sb.replace(gtIndex, gtIndex + 1, "&gt;");
            gtIndex = sb.toString().indexOf(62);
        }
        return sb.toString();
    }

    private static void printActivity(Activity activity, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (activity == null) {
            return;
        }
        if (activity instanceof Sequence) {
            Printer.printSequence((Sequence)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Receive) {
            Printer.printReceive((Receive)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Reply) {
            Printer.printReply((Reply)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof SwitchBlock) {
            Printer.printSwitchBlock((SwitchBlock)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Throw) {
            Printer.printThrow((Throw)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Empty) {
            Printer.printEmpty((Empty)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Terminate) {
            Printer.printTerminate((Terminate)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Compensate) {
            Printer.printCompensate((Compensate)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Wait) {
            Printer.printWait((Wait)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Invoke) {
            Printer.printInvoke((Invoke)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof While) {
            Printer.printWhile((While)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Pick) {
            Printer.printPick((Pick)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Flow) {
            Printer.printFlow((Flow)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Scope) {
            Printer.printScope((Scope)activity, out, nss, indent, lineTracker);
        } else if (activity instanceof Assign) {
            Printer.printAssign((Assign)activity, out, nss, indent, lineTracker);
        } else {
            printerLogger.error((Object)("Unknown activity: " + activity));
            lineTracker.incrementLine();
        }
    }

    private static void printAssign(Assign assign, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(assign);
        out.println(String.valueOf(indent) + "<assign>");
        lineTracker.incrementLine();
        Iterator i = assign.getCopies().iterator();
        while (i.hasNext()) {
            Copy c = (Copy)i.next();
            out.println(String.valueOf(indent) + INDENT + "<copy>");
            lineTracker.incrementLine();
            Printer.printFrom(c.getFrom(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
            Printer.printTo(c.getTo(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
            out.println(String.valueOf(indent) + INDENT + "</copy>");
            lineTracker.incrementLine();
        }
        out.println(String.valueOf(indent) + "</assign>");
        lineTracker.incrementLine();
    }

    private static void printCatchFaults(List l, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (l == null) {
            return;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            CatchFault cf = (CatchFault)i.next();
            lineTracker.setLine(cf);
            out.print(String.valueOf(indent) + "<catch");
            QName qn = cf.getFaultName();
            if (qn != null) {
                nss.pushScope();
                String prefix = nss.getPrefixFromURI(qn.getNamespaceURI(), (Writer)out);
                out.print(Printer.escape(" faultName=\"" + prefix + ":" + qn.getLocalPart() + "\""));
                nss.popScope();
            }
            if (cf.getFaultContainer() != null) {
                out.print(" faultContainer=\"" + Printer.escape(cf.getFaultContainer().getName()) + "\"");
            }
            out.println(">");
            lineTracker.incrementLine();
            Printer.printActivity(cf.getActivity(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
            out.println(String.valueOf(indent) + "</catch>");
            lineTracker.incrementLine();
        }
    }

    private static void printCompensate(Compensate compensate, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(compensate);
        out.print(String.valueOf(indent) + "<compensate");
        Printer.printStandardAttributes(compensate, out);
        if (compensate.getScope() != null && compensate.getScope().getName() != null) {
            String n = compensate.getScope().getName();
            out.print(" scope=\"" + Printer.escape(n) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(compensate, out, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</compensate>");
        lineTracker.incrementLine();
    }

    private static void printCompensationHandler(CompensationHandler ch, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (ch == null) {
            return;
        }
        lineTracker.setLine(ch);
        out.println(String.valueOf(indent) + "<compensationHandler>");
        lineTracker.incrementLine();
        Printer.printActivity(ch.getActivity(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</compensationHandler>");
        lineTracker.incrementLine();
    }

    private static void printContainers(Containers con, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (con == null) {
            return;
        }
        lineTracker.setLine(con);
        out.println(String.valueOf(indent) + "<containers>");
        lineTracker.incrementLine();
        if (con.getContainers() != null) {
            Iterator i = con.getContainers().iterator();
            while (i.hasNext()) {
                QName mt;
                Container c = (Container)i.next();
                lineTracker.setLine(c);
                out.print(String.valueOf(indent) + INDENT + "<container");
                if (c.getName() != null) {
                    out.print(" name=\"" + Printer.escape(c.getName()) + "\"");
                }
                if ((mt = c.getMessageType()) != null) {
                    nss.pushScope();
                    String prefix = nss.getPrefixFromURI(mt.getNamespaceURI(), (Writer)out);
                    out.print(Printer.escape(" messageType=\"" + prefix + ":" + mt.getLocalPart() + "\""));
                    nss.popScope();
                }
                out.println("/>");
                lineTracker.incrementLine();
            }
        }
        out.println(String.valueOf(indent) + "</containers>");
        lineTracker.incrementLine();
    }

    private static void printCorrelationSets(CorrelationSets con, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (con == null) {
            return;
        }
        lineTracker.setLine(con);
        out.println(String.valueOf(indent) + "<correlationSets>");
        lineTracker.incrementLine();
        if (con.getCorrelationSets() != null) {
            Iterator i = con.getCorrelationSets().iterator();
            while (i.hasNext()) {
                QName qn;
                CorrelationSet c = (CorrelationSet)i.next();
                lineTracker.setLine(c);
                out.print(String.valueOf(indent) + INDENT + "<correlationSet");
                nss.pushScope();
                List l = c.getProperties();
                if (l != null) {
                    Iterator i2 = l.iterator();
                    while (i2.hasNext()) {
                        qn = (QName)i2.next();
                        nss.getPrefixFromURI(qn.getNamespaceURI(), (Writer)out);
                    }
                }
                if (c.getName() != null) {
                    out.print(" name=\"" + Printer.escape(c.getName()) + "\"");
                }
                if (l != null) {
                    out.print(" properties=\"");
                    Iterator i3 = l.iterator();
                    while (i3.hasNext()) {
                        qn = (QName)i3.next();
                        String prefix = nss.getPrefixFromURI(qn.getNamespaceURI());
                        out.print(Printer.escape(String.valueOf(prefix) + ":" + qn.getLocalPart()));
                        if (!i3.hasNext()) continue;
                        out.print(" ");
                    }
                    out.print("\"");
                }
                out.println("/>");
                lineTracker.incrementLine();
                nss.popScope();
            }
        }
        out.println(String.valueOf(indent) + "</correlationSets>");
        lineTracker.incrementLine();
    }

    private static void printCorrelations(Correlations con, PrintWriter out, String indent, LineTracker lineTracker) {
        if (con == null) {
            return;
        }
        lineTracker.setLine(con);
        out.println(String.valueOf(indent) + "<correlations>");
        lineTracker.incrementLine();
        Iterator i = con.getCorrelations().iterator();
        while (i.hasNext()) {
            Correlation c = (Correlation)i.next();
            lineTracker.setLine(c);
            out.print(String.valueOf(indent) + INDENT + "<correlation");
            if (c.getSet() != null) {
                out.print(" set=\"" + Printer.escape(c.getSet()) + "\"");
            }
            if (c.getInitiation() != null) {
                boolean b = c.getInitiation();
                out.print(" initiation=\"" + (b ? "yes" : "no") + "\"");
            }
            if (c.getPattern() != null) {
                out.print(" pattern=\"" + Printer.escape(c.getPattern()) + "\"");
            }
            out.println("/>");
            lineTracker.incrementLine();
        }
        out.println(String.valueOf(indent) + "</correlations>");
        lineTracker.incrementLine();
    }

    private static void printEmpty(Empty empty, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(empty);
        out.print(String.valueOf(indent) + "<empty");
        Printer.printStandardAttributes(empty, out);
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(empty, out, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</empty>");
        lineTracker.incrementLine();
    }

    private static void printFaultHandlers(FaultHandlers fh, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (fh == null) {
            return;
        }
        lineTracker.setLine(fh);
        out.println(String.valueOf(indent) + "<faultHandlers>");
        lineTracker.incrementLine();
        Printer.printCatchFaults(fh.getCatchFaults(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        if (fh.getCatchAll() != null) {
            CatchAll ca = fh.getCatchAll();
            lineTracker.setLine(ca);
            out.println(String.valueOf(indent) + INDENT + "<catchAll>");
            lineTracker.incrementLine();
            Printer.printActivity(ca.getActivity(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
        }
        out.println(String.valueOf(indent) + "</faultHandlers>");
        lineTracker.incrementLine();
    }

    private static void printFlow(Flow flow, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        Iterator i;
        lineTracker.setLine(flow);
        out.print(String.valueOf(indent) + "<flow");
        Printer.printStandardAttributes(flow, out);
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(flow, out, String.valueOf(indent) + INDENT, lineTracker);
        if (flow.getLinks() != null && flow.getLinks().getLinks() != null) {
            out.println(String.valueOf(indent) + INDENT + "<links>");
            lineTracker.incrementLine();
            i = flow.getLinks().getLinks().iterator();
            while (i.hasNext()) {
                Link l = (Link)i.next();
                out.print(String.valueOf(indent) + INDENT + INDENT + "<link");
                if (l.getName() != null) {
                    out.print(" name=\"" + Printer.escape(l.getName()) + "\"");
                }
                out.println("/>");
                lineTracker.incrementLine();
            }
            out.println(String.valueOf(indent) + INDENT + "</links>");
            lineTracker.incrementLine();
        }
        if (flow.getActivities() != null) {
            i = flow.getActivities().iterator();
            while (i.hasNext()) {
                Activity a = (Activity)i.next();
                Printer.printActivity(a, out, nss, String.valueOf(indent) + INDENT, lineTracker);
            }
        }
        out.println(String.valueOf(indent) + "</flow>");
        lineTracker.incrementLine();
    }

    private static void printFrom(From from, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(from);
        out.print(String.valueOf(indent) + "<from");
        if (from.getContainer() != null) {
            out.print(" container=\"" + Printer.escape(from.getContainer().getName()) + "\"");
            if (from.getPart() != null) {
                out.print(" part=\"" + Printer.escape(from.getPart()) + "\"");
                if (from.getQuery() != null) {
                    out.print(" query=\"" + Printer.escape(from.getQuery()) + "\"");
                }
            } else {
                QName prop = from.getProperty();
                if (prop != null) {
                    nss.pushScope();
                    String prefix = nss.getPrefixFromURI(prop.getNamespaceURI(), (Writer)out);
                    out.print(" property=\"" + Printer.escape(prefix) + ":" + Printer.escape(prop.getLocalPart()) + "\"");
                    nss.popScope();
                }
            }
            out.println("/>");
            lineTracker.incrementLine();
        } else if (from.getPartner() != null) {
            out.print(" partner=\"" + Printer.escape(from.getPartner().getName()) + "\"");
            if (from.getServiceReference() != null) {
                out.print(" serviceReference=\"" + Printer.escape(from.getServiceReference()) + "\"");
            }
            out.println("/>");
            lineTracker.incrementLine();
        } else if (from.getExpression() != null) {
            out.println(" expression=\"" + Printer.escape(from.getExpression()) + "\"/>");
            lineTracker.incrementLine();
        } else {
            out.println(">");
            Element e = from.getLiteralValue();
            out.print(String.valueOf(indent) + INDENT);
            if (e != null) {
                DOM2Writer.serializeAsXML((Node)e, (Writer)out);
            }
            out.println();
            lineTracker.incrementLine();
            out.println(String.valueOf(indent) + "</from>");
            lineTracker.incrementLine();
        }
    }

    private static void printInvoke(Invoke invoke, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        QName pt;
        lineTracker.setLine(invoke);
        out.print(String.valueOf(indent) + "<invoke");
        if (Printer.printStandardAttributes(invoke, out)) {
            out.println();
            lineTracker.incrementLine();
            out.print(String.valueOf(indent) + "       ");
        }
        boolean wroteStuff = false;
        if (invoke.getPartner() != null) {
            out.print(" partner=\"" + Printer.escape(invoke.getPartner().getName()) + "\"");
            wroteStuff = true;
        }
        if ((pt = invoke.getPortType()) != null) {
            nss.pushScope();
            String prefix = nss.getPrefixFromURI(pt.getNamespaceURI(), (Writer)out);
            out.print(" portType=\"" + Printer.escape(prefix) + ":" + Printer.escape(pt.getLocalPart()) + "\"");
            nss.popScope();
            wroteStuff = true;
        }
        if (invoke.getOperation() != null) {
            out.print(" operation=\"" + Printer.escape(invoke.getOperation()) + "\"");
            wroteStuff = true;
        }
        if (wroteStuff) {
            out.println();
            lineTracker.incrementLine();
            out.print(String.valueOf(indent) + "       ");
        }
        if (invoke.getInputContainer() != null) {
            out.print(" inputContainer=\"" + Printer.escape(invoke.getInputContainer().getName()) + "\"");
        }
        if (invoke.getOutputContainer() != null) {
            out.print(" outputContainer=\"" + Printer.escape(invoke.getOutputContainer().getName()) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(invoke, out, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printCorrelations(invoke.getCorrelations(), out, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printCatchFaults(invoke.getCatchFaults(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printCompensationHandler(invoke.getCompensationHandler(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</invoke>");
        lineTracker.incrementLine();
    }

    private static void printPartners(Partners partners, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        if (partners == null) {
            return;
        }
        lineTracker.setLine(partners);
        out.println(String.valueOf(indent) + "<partners>");
        lineTracker.incrementLine();
        if (partners.getPartners() != null) {
            Iterator i = partners.getPartners().iterator();
            while (i.hasNext()) {
                QName st;
                Partner p = (Partner)i.next();
                lineTracker.setLine(p);
                out.print(String.valueOf(indent) + INDENT + "<partner");
                if (p.getName() != null) {
                    out.print(" name=\"" + Printer.escape(p.getName()) + "\"");
                }
                if ((st = p.getServiceLinkType()) != null) {
                    nss.pushScope();
                    String prefix = nss.getPrefixFromURI(st.getNamespaceURI(), (Writer)out);
                    out.print(Printer.escape(" serviceLinkType=\"" + prefix + ":" + st.getLocalPart() + "\""));
                    nss.popScope();
                }
                if (p.getMyRole() != null) {
                    out.print(" myRole=\"" + Printer.escape(p.getMyRole()) + "\"");
                }
                if (p.getPartnerRole() != null) {
                    out.print(" partnerRole=\"" + Printer.escape(p.getPartnerRole()) + "\"");
                }
                out.println("/>");
                lineTracker.incrementLine();
            }
        }
        out.println(String.valueOf(indent) + "</partners>");
        lineTracker.incrementLine();
    }

    private static void printPick(Pick pick, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(pick);
        out.print(String.valueOf(indent) + "<pick");
        Printer.printStandardAttributes(pick, out);
        if (pick.getCreateInstance() != null) {
            boolean b = pick.getCreateInstance();
            out.print(" createInstance=\"" + (b ? "yes" : "no") + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(pick, out, String.valueOf(indent) + INDENT, lineTracker);
        if (pick.getOnMessages() != null) {
            Iterator i = pick.getOnMessages().iterator();
            while (i.hasNext()) {
                QName pt;
                OnMessage om = (OnMessage)i.next();
                out.print(String.valueOf(indent) + INDENT + "<onMessage");
                if (om.getPartner() != null) {
                    out.print(" partner=\"" + Printer.escape(om.getPartner().getName()) + "\"");
                }
                if ((pt = om.getPortType()) != null) {
                    nss.pushScope();
                    String prefix = nss.getPrefixFromURI(pt.getNamespaceURI(), (Writer)out);
                    out.print(" portType=\"" + Printer.escape(prefix) + ":" + Printer.escape(pt.getLocalPart()) + "\"");
                    nss.popScope();
                }
                if (om.getOperation() != null) {
                    out.print(" operation=\"" + Printer.escape(om.getOperation()) + "\"");
                }
                if (om.getContainer() != null) {
                    out.print(" container=\"" + Printer.escape(om.getContainer().getName()) + "\"");
                }
                out.println(">");
                lineTracker.incrementLine();
                Printer.printCorrelations(om.getCorrelations(), out, String.valueOf(indent) + INDENT + INDENT, lineTracker);
                Printer.printActivity(om.getActivity(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
            }
        }
        if (pick.getOnAlarms() != null) {
            Iterator i = pick.getOnAlarms().iterator();
            while (i.hasNext()) {
                OnAlarm oa = (OnAlarm)i.next();
                out.print(String.valueOf(indent) + INDENT + "<onAlarm");
                if (oa.getForExpr() != null) {
                    out.print(" for=\"" + Printer.escape(oa.getForExpr()) + "\"");
                }
                if (oa.getUntil() != null) {
                    out.print(" until=\"" + Printer.escape(oa.getUntil()) + "\"");
                }
                out.println(">");
                lineTracker.incrementLine();
                Printer.printActivity(oa.getActivity(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
                out.println(String.valueOf(indent) + INDENT + "</onAlarm>");
                lineTracker.incrementLine();
            }
        }
        out.println(String.valueOf(indent) + "</pick>");
        lineTracker.incrementLine();
    }

    public static void printProcess(BPWSProcess process, PrintWriter out, LineTracker lineTracker) throws IOException {
        NSStack nss = new NSStack();
        nss.pushScope();
        lineTracker.setLine(process);
        out.print("<process xmlns=\"http://schemas.xmlsoap.org/ws/2002/07/business-process/\"");
        if (process.getName() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         name=\"" + Printer.escape(process.getName()) + "\"");
        }
        if (process.getTargetNamespace() != null) {
            out.println();
            lineTracker.incrementLine();
            out.println("         targetNamespace=\"" + Printer.escape(process.getTargetNamespace()) + "\"");
            lineTracker.incrementLine();
            out.print("         xmlns:tns=\"" + Printer.escape(process.getTargetNamespace()) + "\"");
            nss.addNSDeclaration("tns", process.getTargetNamespace());
        }
        if (process.getQueryLanguage() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         queryLanguage=\"" + Printer.escape(process.getQueryLanguage()) + "\"");
        }
        if (process.getExpressionLanguage() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         expressionLanguage=\"" + Printer.escape(process.getExpressionLanguage()) + "\"");
        }
        if (process.getSuppressJoinFailure() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         suppressJoinFailure=\"" + Printer.bool2YN(process.getSuppressJoinFailure()) + "\"");
        }
        if (process.getContainerAccessSerializable() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         containerAccessSerializable=\"" + Printer.bool2YN(process.getContainerAccessSerializable()) + "\"");
        }
        if (process.getEnableInstanceCompensation() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         enableInstanceCompensation=\"" + Printer.bool2YN(process.getEnableInstanceCompensation()) + "\"");
        }
        if (process.getAbstractProcess() != null) {
            out.println();
            lineTracker.incrementLine();
            out.print("         abstractProcess=\"" + Printer.bool2YN(process.getAbstractProcess()) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printPartners(process.getPartners(), out, nss, INDENT, lineTracker);
        Printer.printContainers(process.getContainers(), out, nss, INDENT, lineTracker);
        Printer.printCorrelationSets(process.getCorrelationSets(), out, nss, INDENT, lineTracker);
        Printer.printFaultHandlers(process.getFaultHandlers(), out, nss, INDENT, lineTracker);
        Printer.printCompensationHandler(process.getCompensationHandler(), out, nss, INDENT, lineTracker);
        out.println();
        lineTracker.incrementLine();
        Printer.printActivity(process.getActivity(), out, nss, INDENT, lineTracker);
        out.println("</process>");
        lineTracker.incrementLine();
        out.flush();
    }

    private static void printReceive(Receive receive, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        QName pt;
        lineTracker.setLine(receive);
        out.print(String.valueOf(indent) + "<receive");
        if (Printer.printStandardAttributes(receive, out)) {
            out.println();
            lineTracker.incrementLine();
            out.print(String.valueOf(indent) + "         ");
        }
        boolean wroteStuff = false;
        if (receive.getPartner() != null) {
            out.print(" partner=\"" + Printer.escape(receive.getPartner().getName()) + "\"");
            wroteStuff = true;
        }
        if ((pt = receive.getPortType()) != null) {
            nss.pushScope();
            String prefix = nss.getPrefixFromURI(pt.getNamespaceURI(), (Writer)out);
            out.print(Printer.escape(" portType=\"" + prefix + ":" + pt.getLocalPart() + "\""));
            nss.popScope();
            wroteStuff = true;
        }
        if (receive.getOperation() != null) {
            out.print(" operation=\"" + Printer.escape(receive.getOperation()) + "\"");
            wroteStuff = true;
        }
        if (wroteStuff) {
            out.println();
            lineTracker.incrementLine();
            out.print(String.valueOf(indent) + "        ");
        }
        if (receive.getContainer() != null) {
            out.print(" container=\"" + Printer.escape(receive.getContainer().getName()) + "\"");
        }
        if (receive.getCreateInstance() != null) {
            boolean b = receive.getCreateInstance();
            out.print(" createInstance=\"" + (b ? "yes" : "no") + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(receive, out, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printCorrelations(receive.getCorrelations(), out, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</receive>");
        lineTracker.incrementLine();
    }

    private static void printReply(Reply reply, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        QName pt;
        lineTracker.setLine(reply);
        nss.pushScope();
        out.print(String.valueOf(indent) + "<reply");
        if (Printer.printStandardAttributes(reply, out)) {
            out.println();
            lineTracker.incrementLine();
            out.print(String.valueOf(indent) + "      ");
        }
        boolean wroteStuff = false;
        if (reply.getPartner() != null) {
            out.print(" partner=\"" + Printer.escape(reply.getPartner().getName()) + "\"");
            wroteStuff = true;
        }
        if ((pt = reply.getPortType()) != null) {
            String prefix = nss.getPrefixFromURI(pt.getNamespaceURI(), (Writer)out);
            out.print(" portType=\"" + Printer.escape(prefix) + ":" + Printer.escape(pt.getLocalPart()) + "\"");
            wroteStuff = true;
        }
        if (reply.getOperation() != null) {
            out.print(" operation=\"" + Printer.escape(reply.getOperation()) + "\"");
            wroteStuff = true;
        }
        if (wroteStuff) {
            out.println();
            lineTracker.incrementLine();
            out.print(String.valueOf(indent) + "      ");
        }
        if (reply.getContainer() != null) {
            out.print(" container=\"" + Printer.escape(reply.getContainer().getName()) + "\"");
        }
        if (reply.getFaultName() != null) {
            QName fn = reply.getFaultName();
            String prefix = nss.getPrefixFromURI(fn.getNamespaceURI(), (Writer)out);
            out.print(" faultName=\"" + Printer.escape(prefix) + ":" + Printer.escape(fn.getLocalPart()) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(reply, out, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printCorrelations(reply.getCorrelations(), out, String.valueOf(indent) + INDENT, lineTracker);
        nss.popScope();
        out.println(String.valueOf(indent) + "</reply>");
        lineTracker.incrementLine();
    }

    private static void printScope(Scope scope, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(scope);
        out.print(String.valueOf(indent) + "<scope");
        Printer.printStandardAttributes(scope, out);
        if (scope.getContainerAccessSerializable() != null) {
            boolean b = scope.getContainerAccessSerializable();
            out.print(" containerAccessSerializable=\"" + (b ? "yes" : "no") + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(scope, out, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printFaultHandlers(scope.getFaultHandlers(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printCompensationHandler(scope.getCompensationHandler(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        out.println();
        lineTracker.incrementLine();
        Printer.printActivity(scope.getActivity(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</scope>");
        lineTracker.incrementLine();
    }

    private static void printSequence(Sequence sequence, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(sequence);
        out.print(String.valueOf(indent) + "<sequence");
        Printer.printStandardAttributes(sequence, out);
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(sequence, out, String.valueOf(indent) + INDENT, lineTracker);
        Iterator i = sequence.getActivities().iterator();
        while (i.hasNext()) {
            Activity a = (Activity)i.next();
            Printer.printActivity(a, out, nss, String.valueOf(indent) + INDENT, lineTracker);
        }
        out.println(String.valueOf(indent) + "</sequence>");
        lineTracker.incrementLine();
    }

    private static boolean printStandardAttributes(Activity a, PrintWriter out) {
        String jc;
        Boolean spe;
        boolean didit = false;
        String name = Printer.escape(a.getName());
        if (name != null) {
            didit = true;
            out.print(" name=\"" + name + "\"");
        }
        if ((spe = a.getSuppressJoinFailure()) != null) {
            didit = true;
            boolean b = spe;
            out.print(" suppressJoinFailure=\"" + (b ? "yes" : "no") + "\"");
        }
        if ((jc = Printer.escape(a.getJoinCondition())) != null) {
            didit = true;
            out.print(" joinCondition=\"" + jc + "\"");
        }
        return didit;
    }

    private static void printStandardElements(Activity a, PrintWriter out, String indent, LineTracker lineTracker) {
        Serializable so;
        Iterator i;
        List list = a.getSources();
        if (list != null) {
            i = list.iterator();
            while (i.hasNext()) {
                so = (Source)i.next();
                out.print(String.valueOf(indent) + "<source ");
                if (so.getLink() != null && so.getLink().getName() != null) {
                    out.print("linkName=\"" + Printer.escape(so.getLink().getName()) + "\"");
                }
                if (so.getTransitionCondition() != null) {
                    out.print(" transitionCondition=\"" + Printer.escape(so.getTransitionCondition()) + "\"");
                }
                out.println("/>");
                lineTracker.incrementLine();
            }
        }
        if ((list = a.getTargets()) != null) {
            i = list.iterator();
            while (i.hasNext()) {
                so = (Target)i.next();
                out.print(String.valueOf(indent) + "<target ");
                if (so.getLink() != null && so.getLink().getName() != null) {
                    out.print("linkName=\"" + Printer.escape(so.getLink().getName()) + "\"");
                }
                out.println("/>");
                lineTracker.incrementLine();
            }
        }
    }

    private static void printSwitchBlock(SwitchBlock switchBlock, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(switchBlock);
        out.print(String.valueOf(indent) + "<switch");
        Printer.printStandardAttributes(switchBlock, out);
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(switchBlock, out, String.valueOf(indent) + INDENT, lineTracker);
        Iterator i = switchBlock.getCaseClauses().iterator();
        while (i.hasNext()) {
            CaseClause c = (CaseClause)i.next();
            out.print(String.valueOf(indent) + INDENT + "<case");
            if (c.getCondition() != null) {
                out.print(" condition=\"" + Printer.escape(c.getCondition()) + "\"");
            }
            out.println(">");
            lineTracker.incrementLine();
            Printer.printActivity(c.getActivity(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
            out.println(String.valueOf(indent) + INDENT + "</case>");
            lineTracker.incrementLine();
        }
        Otherwise ow = switchBlock.getOtherwise();
        if (ow != null) {
            out.println(String.valueOf(indent) + INDENT + "<otherwise>");
            lineTracker.incrementLine();
            Printer.printActivity(ow.getActivity(), out, nss, String.valueOf(indent) + INDENT + INDENT, lineTracker);
            out.println(String.valueOf(indent) + INDENT + "</otherwise>");
            lineTracker.incrementLine();
        }
        out.println(String.valueOf(indent) + "</switch>");
        lineTracker.incrementLine();
    }

    private static void printTerminate(Terminate terminate, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(terminate);
        out.print(String.valueOf(indent) + "<terminate");
        Printer.printStandardAttributes(terminate, out);
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(terminate, out, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</terminate>");
        lineTracker.incrementLine();
    }

    private static void printThrow(Throw thro, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(thro);
        out.print(String.valueOf(indent) + "<throw");
        Printer.printStandardAttributes(thro, out);
        QName fn = thro.getFaultName();
        if (fn != null) {
            nss.pushScope();
            String prefix = nss.getPrefixFromURI(fn.getNamespaceURI(), (Writer)out);
            out.print(" faultName=\"" + Printer.escape(prefix) + ":" + Printer.escape(fn.getLocalPart()) + "\"");
            nss.popScope();
        }
        if (thro.getFaultContainer() != null) {
            out.print(" faultContainer=\"" + Printer.escape(thro.getFaultContainer().getName()) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(thro, out, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</throw>");
        lineTracker.incrementLine();
    }

    private static void printTo(To to, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(to);
        out.print(String.valueOf(indent) + "<to");
        if (to.getContainer() != null) {
            out.print(" container=\"" + Printer.escape(to.getContainer().getName()) + "\"");
            if (to.getPart() != null) {
                out.print(" part=\"" + Printer.escape(to.getPart()) + "\"");
                if (to.getQuery() != null) {
                    out.print(" query=\"" + Printer.escape(to.getQuery()) + "\"");
                }
            } else {
                QName prop = to.getProperty();
                if (prop != null) {
                    nss.pushScope();
                    String prefix = nss.getPrefixFromURI(prop.getNamespaceURI(), (Writer)out);
                    out.print(" property=\"" + Printer.escape(prefix) + ":" + Printer.escape(prop.getLocalPart()) + "\"");
                    nss.popScope();
                }
            }
            out.println("/>");
            lineTracker.incrementLine();
        } else if (to.getPartner() != null) {
            out.println(" partner=\"" + Printer.escape(to.getPartner().getName()) + "\"/>");
            lineTracker.incrementLine();
        } else {
            out.println("/>");
            lineTracker.incrementLine();
        }
    }

    private static void printWait(Wait wait, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(wait);
        out.print(String.valueOf(indent) + "<wait");
        Printer.printStandardAttributes(wait, out);
        if (wait.getForExpr() != null) {
            out.print(" for=\"" + Printer.escape(wait.getForExpr()) + "\"");
        } else if (wait.getUntil() != null) {
            out.print(" until=\"" + Printer.escape(wait.getUntil()) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(wait, out, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</wait>");
        lineTracker.incrementLine();
    }

    private static void printWhile(While wh, PrintWriter out, NSStack nss, String indent, LineTracker lineTracker) throws IOException {
        lineTracker.setLine(wh);
        out.print(String.valueOf(indent) + "<while");
        Printer.printStandardAttributes(wh, out);
        if (wh.getCondition() != null) {
            out.print(" condition=\"" + Printer.escape(wh.getCondition()) + "\"");
        }
        out.println(">");
        lineTracker.incrementLine();
        Printer.printStandardElements(wh, out, String.valueOf(indent) + INDENT, lineTracker);
        Printer.printActivity(wh.getActivity(), out, nss, String.valueOf(indent) + INDENT, lineTracker);
        out.println(String.valueOf(indent) + "</while>");
        lineTracker.incrementLine();
    }

    public static class LineTracker {
        private Map lineNumberMap = new HashMap();
        private int currentLine;

        public LineTracker() {
            this.resetLineNumber();
        }

        public int getLineNumber(Object object) {
            Integer lineNumber = (Integer)this.lineNumberMap.get(object);
            if (lineNumber == null) {
                return -1;
            }
            return lineNumber;
        }

        public Map getLineNumberMap() {
            return this.lineNumberMap;
        }

        public void incrementLine() {
            ++this.currentLine;
        }

        public void resetLineNumber() {
            this.currentLine = 1;
        }

        public void setLine(Object object) {
            this.lineNumberMap.put(object, new Integer(this.currentLine));
        }
    }
}

