/*
 * Decompiled with CFR 0.152.
 */
package bpel2fsp;

import java.io.File;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class convert {
    private Document bpelDoc = null;
    private NodeList processlist = null;
    private Node currentprocessnode = null;
    private LinkedList CompositionList = new LinkedList();
    private LinkedList WarningList = null;
    private LinkedList CaseList = new LinkedList();
    private LinkedList AlphabetList = new LinkedList();
    private HashMap AssignValueList = new HashMap();
    private LinkedList ActionList = new LinkedList();
    private LinkedList LinksList = new LinkedList();
    private OutputStream outFSPStream = null;
    private OutputStream outStream = null;
    private int flowIDCounter = 1;
    private int whileIDCounter = 1;
    private int sequenceIDCounter = 1;
    private int assignIDCounter = 1;

    public LinkedList getActionList() {
        return this.ActionList;
    }

    private int getLinkValue(String linkvalue) {
        return this.LinksList.indexOf(linkvalue);
    }

    private int getAssignValue(String container, String assignvalue) {
        LinkedList ContainerLinkedList;
        if (!this.AssignValueList.containsKey(container)) {
            this.AssignValueList.put(container, new LinkedList());
        }
        if (!(ContainerLinkedList = (LinkedList)this.AssignValueList.get(container)).contains(assignvalue)) {
            ContainerLinkedList.add(assignvalue);
        }
        return ContainerLinkedList.indexOf(assignvalue);
    }

    private boolean isTextNode(Node currentNode) {
        return currentNode.getNodeName().equals("#text");
    }

    private void reportNodeWarning(Node currentNode, String Warning) {
        this.writeOutput(String.valueOf(String.valueOf(new StringBuffer("WARNING: Construct ").append(currentNode).append(" ").append(Warning))));
    }

    public String translateBPELNode(Node currentNode, boolean addAlphabet) {
        boolean result = false;
        String currentNodeString = "";
        Document bpelDoc = null;
        NodeList currentnodelist = null;
        if (currentNode.getNodeName().compareTo("scope") == 0) {
            currentNodeString = this.buildLinkFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("link") == 0) {
            currentNodeString = this.buildLinkFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("sequence") == 0) {
            currentNodeString = this.buildSequenceFSP(currentNode, true, addAlphabet);
        }
        if (currentNode.getNodeName().compareTo("assign") == 0) {
            currentNodeString = this.buildAssignFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("receive") == 0) {
            currentNodeString = this.buildReceiveReplyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("reply") == 0) {
            currentNodeString = this.buildReceiveReplyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("flow") == 0) {
            currentNodeString = this.buildFlowFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("while") == 0) {
            currentNodeString = this.buildWhileFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("case") == 0) {
            currentNodeString = this.buildCaseFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("otherwise") == 0) {
            currentNodeString = this.buildCaseFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("switch") == 0) {
            currentNodeString = this.buildSwitchFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("invoke") == 0) {
            this.writeOutput("// WARNING: INVOKE encountered, currently not included.");
            currentNodeString = this.buildReceiveReplyFSP(currentNode);
        }
        if (currentNode.getNodeName().compareTo("links") == 0) {
            currentNodeString = "";
            bpelDoc = currentNode.getOwnerDocument();
            currentnodelist = bpelDoc.getElementsByTagName("link");
            this.writeFSPOutput("// Links start");
            for (int loop = 0; loop < currentnodelist.getLength(); ++loop) {
                if (currentnodelist.item(loop).getNodeName().compareTo("link") != 0) continue;
                this.translateBPELNode(currentnodelist.item(loop), false);
            }
            this.writeFSPOutput("// Links end");
        }
        return currentNodeString;
    }

    private void initCounters() {
        this.flowIDCounter = 1;
        this.whileIDCounter = 1;
        this.sequenceIDCounter = 1;
        this.assignIDCounter = 1;
    }

    public boolean translateToFSP() {
        boolean result = false;
        NodeList currentnodelist = null;
        String SetModelComposition = null;
        boolean sequenceRoot = false;
        boolean flowRoot = false;
        this.CompositionList.clear();
        this.CompositionList.clear();
        this.CaseList.clear();
        this.AlphabetList.clear();
        this.AssignValueList.clear();
        this.ActionList.clear();
        this.LinksList.clear();
        this.initCounters();
        this.writeFSPOutput("// CASE List size = ".concat(String.valueOf(String.valueOf(this.CaseList.size()))));
        currentnodelist = this.bpelDoc.getElementsByTagName("containers");
        if (currentnodelist.getLength() > 0) {
            this.buildContainersFSP(currentnodelist.item(0));
        }
        if ((currentnodelist = this.bpelDoc.getElementsByTagName("sequence")).getLength() < 1) {
            currentnodelist = this.bpelDoc.getElementsByTagName("flow");
            if (currentnodelist.getLength() > 0) {
                flowRoot = true;
            }
        } else {
            sequenceRoot = true;
        }
        if (currentnodelist.getLength() > 0) {
            if (sequenceRoot) {
                this.writeFSPOutput("// Entry: SEQUENCE start ---------------------------");
                this.buildSequenceFSP(currentnodelist.item(0), true, true);
                this.writeFSPOutput("// Entry: SEQUENCE end   ---------------------------");
            }
            if (flowRoot) {
                this.writeFSPOutput("// Entry: FLOW start -------------------------------");
                this.buildFlowFSP(currentnodelist.item(0));
                this.writeFSPOutput("// Entry: FLOW end   -------------------------------");
            }
            SetModelComposition = "||BPEL = (";
            Iterator I = this.CompositionList.iterator();
            while (I.hasNext()) {
                SetModelComposition = String.valueOf(String.valueOf(SetModelComposition)).concat(String.valueOf(String.valueOf(I.next())));
                if (!I.hasNext()) continue;
                SetModelComposition = String.valueOf(String.valueOf(SetModelComposition)).concat(" || ");
            }
            SetModelComposition = String.valueOf(String.valueOf(SetModelComposition)).concat(").");
            this.writeFSPOutput(SetModelComposition);
        } else {
            this.writeOutput("WARNING: NO SEQUENCE SPECIFIED!");
        }
        this.writeOutput("******************************************************");
        this.writeOutput("************ FSP SPECIFICATION END    ****************");
        this.writeOutput("******************************************************");
        try {
            this.outFSPStream.close();
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return result;
    }

    public String buildSequenceFSP(Node SequenceNode, boolean hasname, boolean addAlphabet) {
        boolean result = false;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String constructString = "";
        String compositionName = "";
        try {
            constructNodeList = SequenceNode.getChildNodes();
            compositionName = !hasname ? SequenceNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : "SEQUENCE".concat(String.valueOf(String.valueOf(this.sequenceIDCounter++)));
            if (SequenceNode.getNodeName().equals("otherwise")) {
                compositionName = String.valueOf(String.valueOf(compositionName)).concat("EVAL");
            }
            compositionString = String.valueOf(String.valueOf(compositionName)).concat(" = ");
            constructcounter = 0;
            for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
                constructNode = constructNodeList.item(loop);
                if (this.isTextNode(constructNode) || constructNode.getNodeName().equals("#comment")) continue;
                if (constructcounter > 0) {
                    compositionString = String.valueOf(String.valueOf(compositionString)).concat(" ; ");
                }
                constructString = this.translateBPELNode(constructNode, false);
                if (constructNode.hasAttributes() && constructString.length() == 0) {
                    constructName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
                    compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(constructName)));
                } else {
                    compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(constructString)));
                }
                if (constructString.length() <= 0) continue;
                ++constructcounter;
            }
            compositionString = String.valueOf(String.valueOf(compositionString)).concat("; END");
            if (addAlphabet && this.AlphabetList.size() > 0) {
                compositionString = String.valueOf(String.valueOf(compositionString)).concat(" + {");
                Iterator I = this.AlphabetList.iterator();
                while (I.hasNext()) {
                    compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(I.next())));
                    if (!I.hasNext()) continue;
                    compositionString = String.valueOf(String.valueOf(compositionString)).concat(",");
                }
                compositionString = String.valueOf(String.valueOf(compositionString)).concat("}");
            }
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(".");
            this.writeFSPOutput(compositionString);
            if (addAlphabet) {
                this.CompositionList.add(compositionName);
            }
        }
        catch (Exception E) {
            System.err.println("\nERRROR...");
            E.printStackTrace(System.err);
        }
        return compositionName;
    }

    public String buildCaseFSP(Node FlowNode) {
        boolean result = false;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String conditionString = "";
        String conditioncontainerName = "";
        String conditioncontainerPart = "";
        String conditioncontainerValue = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.getAttributes().getNamedItem("name") != null ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(String.valueOf(FlowNode.getNodeName().toUpperCase())).concat(String.valueOf(String.valueOf(this.whileIDCounter++)));
        compositionString = "||".concat(String.valueOf(String.valueOf(FlowNode.getNodeName().toUpperCase())));
        if (FlowNode.getAttributes().getNamedItem("condition") != null) {
            conditionString = FlowNode.getAttributes().getNamedItem("condition").getNodeValue();
            int beginname = conditionString.indexOf("'") + 1;
            int endname = conditionString.indexOf("'", beginname);
            conditioncontainerName = conditionString.substring(beginname, endname);
            beginname = conditionString.indexOf("'", endname + 1) + 1;
            endname = conditionString.indexOf("'", beginname);
            conditioncontainerPart = conditionString.substring(beginname, endname);
            beginname = conditionString.indexOf("=");
            endname = conditionString.indexOf("'", beginname);
            conditioncontainerValue = conditionString.substring(beginname + 1).trim();
            compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(conditioncontainerName).append(conditioncontainerPart)));
            compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(" = ").append(conditioncontainerName).append(".").append(conditioncontainerPart)));
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(":CONTAINER(0).");
            compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(conditioncontainerName.toUpperCase()))).append(conditioncontainerPart.toUpperCase()).append("OUTCOME")));
            this.CompositionList.add(String.valueOf(String.valueOf(compositionName)).concat(String.valueOf(String.valueOf(compositionString))));
            compositionString = String.valueOf(String.valueOf(new StringBuffer("||").append(compositionName).append(compositionString).append(" = ").append(conditioncontainerName).append(".").append(conditioncontainerPart).append(":CONTAINER.")));
            this.writeFSPOutput(compositionString);
            compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionName))).append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("OUTCOME_ALPHABET")));
            this.AlphabetList.add(compositionString);
            compositionString = String.valueOf(String.valueOf(new StringBuffer("set ").append(compositionString).append(" = {").append(conditioncontainerName).append(".").append(conditioncontainerPart).append(".{read,write}.[IntRange]}")));
            this.writeFSPOutput(compositionString);
            this.writeFSPOutput("");
            this.writeFSPOutput("");
            this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionName))).append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("EVAL = (").append(conditioncontainerName).append(".").append(conditioncontainerPart).append(".read[i:IntRange]->").append(compositionName).append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("EVAL[i]),"))));
            this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionName))).append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("EVAL[i:IntRange] = if (i==").append(this.getAssignValue(conditioncontainerName, conditioncontainerValue)).append(")"))));
            this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("then ").append(compositionName).append("; END else "))));
            int caseIndex = this.CaseList.indexOf(compositionName);
            if (caseIndex > -1 && caseIndex + 1 < this.CaseList.size()) {
                this.writeFSPOutput(String.valueOf(String.valueOf(this.CaseList.get(caseIndex + 1))).concat(";"));
            }
            this.writeFSPOutput(" END.");
            this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("||").append(compositionName).append("EVAL = (").append(compositionName).append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("EVAL)."))));
        }
        whilecompositionName = compositionName;
        compositionString = String.valueOf(String.valueOf(new StringBuffer("||").append(compositionName).append(" = (")));
        constructcounter = 0;
        String constructString = "";
        compositionName = String.valueOf(String.valueOf(conditioncontainerName.toUpperCase())).concat(String.valueOf(String.valueOf(conditioncontainerPart.toUpperCase())));
        if (!FlowNode.getNodeName().equals("otherwise")) {
            compositionName = String.valueOf(String.valueOf(compositionName)).concat("EVAL");
        }
        for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode)) continue;
            constructString = this.translateBPELNode(constructNode, false);
            if (constructcounter > 0) {
                compositionString = String.valueOf(String.valueOf(compositionString)).concat(" || ");
            } else {
                whileLoopActionName = constructString;
            }
            if (!constructNode.hasAttributes()) {
                constructName = "*unknown*";
                this.reportNodeWarning(constructNode, "has no name.");
            } else {
                constructName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            }
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(constructName)));
            ++constructcounter;
        }
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("||").append(whilecompositionName).append(" = (").append(whileLoopActionName).append(")."))));
        compositionString = String.valueOf(String.valueOf(compositionString)).concat(").");
        return compositionName;
    }

    public String buildSwitchFSP(Node FlowNode) {
        int loop;
        boolean result = false;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String constructString = "";
        int noofcases = 0;
        String casename = "";
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        compositionString = String.valueOf(String.valueOf(compositionName)).concat(" = ");
        constructcounter = 0;
        for (loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode)) continue;
            constructName = constructNode.getAttributes().getNamedItem("name") != null ? constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : String.valueOf(String.valueOf(constructNode.getNodeName().toUpperCase())).concat(String.valueOf(String.valueOf(++noofcases)));
            this.CaseList.add(constructName);
        }
        for (loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode)) continue;
            constructString = this.translateBPELNode(constructNode, false);
            if (constructNode.hasAttributes() && constructString.length() == 0 && constructcounter == 0) {
                compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(this.CaseList.getFirst().toString()).append(constructString)));
            }
            if (constructcounter == 0) {
                compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(this.CaseList.getFirst().toString()).append(constructString)));
            }
            ++constructcounter;
        }
        compositionString = String.valueOf(String.valueOf(compositionString)).concat("; END.");
        this.writeFSPOutput(compositionString);
        return "";
    }

    private String actionChildren(Node constructNode) {
        boolean result = false;
        NodeList constructNodeList = null;
        String compositionString = "";
        String compositionName = "";
        String constructString = "";
        String action = "";
        int constructcounter = 0;
        String constructName = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        constructNodeList = constructNode.getChildNodes();
        for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode)) continue;
            constructString = this.translateBPELNode(constructNode, false);
            if (constructcounter > 0) {
                compositionString = String.valueOf(String.valueOf(compositionString)).concat(" || ");
            }
            if (!constructNode.hasAttributes()) {
                constructName = "*unknown*";
                this.reportNodeWarning(constructNode, "has no name.");
            }
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(constructName)));
            ++constructcounter;
        }
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("||").append(whilecompositionName).append(" = (").append(whileLoopActionName).append(")."))));
        return "";
    }

    public String buildReceiveReplyFSP(Node constructNode) {
        boolean result = false;
        Object constructNodeList = null;
        String compositionString = "";
        String compositionName = "";
        String constructString = "";
        String action = "";
        boolean constructcounter = false;
        String constructName = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        String linkName = "";
        compositionName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        compositionString = String.valueOf(String.valueOf(compositionName)).concat(" = (");
        action = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(constructNode.getNodeName().toLowerCase()))).append(".").append(constructNode.getAttributes().getNamedItem("partner").getNodeValue().toLowerCase()).append(".").append(constructNode.getAttributes().getNamedItem("name").getNodeValue().toLowerCase())));
        this.ActionList.add(action);
        compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(action).append(" -> END).")));
        linkName = this.actionSourceandTargets(constructNode, compositionName);
        if (linkName.length() > 0) {
            compositionName = linkName;
        }
        this.writeFSPOutput(compositionString);
        return compositionName;
    }

    public String buildAssignFSP(Node FlowNode) {
        String linkName;
        boolean result = false;
        NodeList constructNodeList = null;
        NamedNodeMap assignNodeAttributes = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String conditioncontainerName = "";
        Node toNode = null;
        Node fromNode = null;
        String assignValue = "";
        boolean assignItem = false;
        String action = "";
        String originalName = "";
        String seqString = "";
        boolean isCopyNode = false;
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.hasAttributes() ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : "ASSIGN".concat(String.valueOf(String.valueOf(this.assignIDCounter++)));
        originalName = compositionName;
        seqString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(originalName))).append("SEQ = ").append(originalName)));
        constructcounter = 0;
        for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (constructNode.getNodeName().compareTo("copy") == 0) {
                isCopyNode = true;
                if (constructcounter > 0) {
                    compositionName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(originalName))).append("_").append(constructcounter)));
                    seqString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(seqString))).append("; ").append(compositionName)));
                }
                ++constructcounter;
                compositionString = String.valueOf(String.valueOf(compositionName)).concat(" = (");
                NodeList CopyNodeList = constructNode.getChildNodes();
                for (int loopcopy = 0; loopcopy < CopyNodeList.getLength(); ++loopcopy) {
                    Node copyNode = CopyNodeList.item(loopcopy);
                    if (copyNode.getNodeName().compareTo("from") == 0) {
                        fromNode = CopyNodeList.item(loopcopy);
                    }
                    if (copyNode.getNodeName().compareTo("to") != 0) continue;
                    toNode = CopyNodeList.item(loopcopy);
                }
                assignNodeAttributes = toNode.getAttributes();
                Node toattributenode = null;
                Node partnode = null;
                toattributenode = assignNodeAttributes.getNamedItem("expression");
                if (toattributenode == null) {
                    toattributenode = assignNodeAttributes.getNamedItem("container");
                    if (!toattributenode.equals(null)) {
                        partnode = toNode.getAttributes().getNamedItem("part");
                    }
                } else {
                    partnode = toattributenode.getAttributes().getNamedItem("part");
                }
                conditioncontainerName = constructName = toattributenode.getNodeValue();
                constructName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(constructName))).append(".").append(partnode.getNodeValue().toLowerCase())));
                assignValue = fromNode.getAttributes().getNamedItem("expression") != null ? fromNode.getAttributes().getNamedItem("expression").getNodeValue() : fromNode.getAttributes().getNamedItem("container").getNodeValue();
                action = constructName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(constructName))).append(".write[").append(this.getAssignValue(conditioncontainerName, assignValue)).append("]")));
                this.ActionList.add(action);
                compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(constructName).append(" -> END")));
            }
            if (this.isTextNode(constructNode) || !isCopyNode) continue;
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(").");
            this.writeFSPOutput(compositionString);
        }
        if (constructcounter > 1) {
            seqString = String.valueOf(String.valueOf(seqString)).concat("; END.");
            this.writeFSPOutput(seqString);
            compositionName = String.valueOf(String.valueOf(originalName)).concat("SEQ");
        }
        if ((linkName = this.actionSourceandTargets(FlowNode, compositionName)).length() > 0) {
            compositionName = linkName;
        }
        return compositionName;
    }

    public String buildWhileFSP(Node FlowNode) {
        boolean result = false;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String conditionString = "";
        String conditioncontainerName = "";
        String conditioncontainerPart = "";
        String conditioncontainerValue = "";
        String whileLoopActionName = "";
        String whilecompositionName = "";
        constructNodeList = FlowNode.getChildNodes();
        if (FlowNode.hasAttributes()) {
            compositionName = FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        } else {
            this.writeOutput("\nWARNING: <while> has no name attribute, using default ID.");
            compositionName = "WHILE".concat(String.valueOf(String.valueOf(this.whileIDCounter++)));
        }
        compositionString = "||WHILE";
        conditionString = FlowNode.getAttributes().getNamedItem("condition").getNodeValue();
        int beginname = conditionString.indexOf("'") + 1;
        int endname = conditionString.indexOf("'", beginname);
        conditioncontainerName = conditionString.substring(beginname, endname);
        beginname = conditionString.indexOf("'", endname + 1) + 1;
        endname = conditionString.indexOf("'", beginname);
        conditioncontainerPart = conditionString.substring(beginname, endname);
        beginname = conditionString.indexOf("=");
        endname = conditionString.indexOf("'", beginname);
        conditioncontainerValue = conditionString.substring(beginname + 1).trim();
        compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(conditioncontainerName).append(conditioncontainerPart)));
        compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionString))).append(" = ").append(conditioncontainerName).append(".").append(conditioncontainerPart)));
        compositionString = String.valueOf(String.valueOf(compositionString)).concat(":CONTAINER(0).");
        compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(conditioncontainerName.toUpperCase()))).append(conditioncontainerPart.toUpperCase()).append("OUTCOME")));
        this.CompositionList.add(compositionString);
        compositionString = String.valueOf(String.valueOf(new StringBuffer("||").append(compositionString).append(" = ").append(conditioncontainerName).append(".").append(conditioncontainerPart).append(":CONTAINER.")));
        this.writeFSPOutput(compositionString);
        compositionString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(conditioncontainerName.toUpperCase()))).append(conditioncontainerPart.toUpperCase()).append("OUTCOME_ALPHABET")));
        this.AlphabetList.add(compositionString);
        compositionString = String.valueOf(String.valueOf(new StringBuffer("set ").append(compositionString).append(" = {").append(conditioncontainerName).append(".").append(conditioncontainerPart).append(".{read,write}.[IntRange]}")));
        this.writeFSPOutput(compositionString);
        this.writeFSPOutput("");
        this.writeFSPOutput("");
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(conditioncontainerName.toUpperCase()))).append(conditioncontainerPart.toUpperCase()).append("EVAL = (").append(conditioncontainerName).append(".").append(conditioncontainerPart).append(".read[i:IntRange]->").append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("EVAL[i]),"))));
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(conditioncontainerName.toUpperCase()))).append(conditioncontainerPart.toUpperCase()).append("EVAL[i:IntRange] = if (i==").append(this.getAssignValue(conditioncontainerName, conditioncontainerValue)).append(")"))));
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("then ").append(compositionName).append(";").append(conditioncontainerName.toUpperCase()).append(conditioncontainerPart.toUpperCase()).append("EVAL").append(" else END."))));
        whilecompositionName = compositionName;
        compositionString = String.valueOf(String.valueOf(new StringBuffer("||").append(compositionName).append(" = (")));
        constructcounter = 0;
        String constructString = "";
        compositionName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(conditioncontainerName.toUpperCase()))).append(conditioncontainerPart.toUpperCase()).append("EVAL")));
        for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode)) continue;
            constructString = this.translateBPELNode(constructNode, false);
            if (constructcounter > 0) {
                compositionString = String.valueOf(String.valueOf(compositionString)).concat(" || ");
            } else {
                whileLoopActionName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            }
            if (!constructNode.hasAttributes()) {
                constructName = "*unknown*";
                this.reportNodeWarning(constructNode, "has no name.");
            } else {
                constructName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            }
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(constructName)));
            ++constructcounter;
        }
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("||").append(whilecompositionName).append(" = (").append(whileLoopActionName).append(")."))));
        compositionString = String.valueOf(String.valueOf(compositionString)).concat(").");
        return compositionName;
    }

    public String buildLinkFSP(Node FlowNode) {
        boolean result = false;
        Object constructNodeList = null;
        Object constructNode = null;
        String compositionString = "";
        boolean constructcounter = false;
        String constructName = "";
        String compositionName = "";
        String constructString = "";
        if (FlowNode.hasAttributes()) {
            compositionName = FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        }
        compositionName = compositionName.replace('-', '_');
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("LINK").append(this.LinksList.size() + 1).append(" = (").append(compositionName.toLowerCase()).append(" -> END)."))));
        this.LinksList.add(compositionName.toLowerCase());
        return compositionString;
    }

    public String actionSourceandTargets(Node aNode, String parentName) {
        boolean result = false;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        String constructString = "";
        int constructcounter = 0;
        String actionName = "";
        String transitionCondition = "";
        String transitionContainer = "";
        String conditionString = "";
        String conditioncontainerName = "";
        String conditioncontainerPart = "";
        String conditioncontainerValue = "";
        String linkno = "";
        LinkedList<String> linksAlphabetList = null;
        String constructname = "";
        boolean hassrctargetlinks = false;
        LinkedList<String> srclist = new LinkedList<String>();
        LinkedList<String> targetlist = new LinkedList<String>();
        linksAlphabetList = new LinkedList<String>();
        String linkLabel = "";
        linksAlphabetList.clear();
        constructNodeList = aNode.getChildNodes();
        for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode) || !constructNode.getNodeName().equals("source") && !constructNode.getNodeName().equals("target")) continue;
            constructname = String.valueOf(String.valueOf(parentName)).concat("LINKSEQ");
            ++constructcounter;
            actionName = constructNode.getAttributes().getNamedItem("linkName").getNodeValue().toLowerCase();
            actionName = actionName.replace('-', '_');
            linkno = String.valueOf(String.valueOf(new StringBuffer("").append(this.getLinkValue(actionName) + 1)));
            if (constructNode.getAttributes().getLength() > 1) {
                transitionCondition = constructNode.getAttributes().getNamedItem("transitionCondition").getNodeValue().toLowerCase();
                conditionString = constructNode.getAttributes().getNamedItem("transitionCondition").getNodeValue();
                int beginname = conditionString.indexOf("'") + 1;
                int endname = conditionString.indexOf("'", beginname);
                conditioncontainerName = conditionString.substring(beginname, endname);
                beginname = conditionString.indexOf("'", endname + 1) + 1;
                endname = conditionString.indexOf("'", beginname);
                conditioncontainerPart = conditionString.substring(beginname, endname);
                beginname = conditionString.indexOf("=");
                endname = conditionString.indexOf("'", beginname);
                conditioncontainerValue = conditionString.substring(beginname + 1).trim();
                this.writeFSPOutput(this.buildGuardFSP(constructNode, conditioncontainerName, String.valueOf(String.valueOf(new StringBuffer("LINK").append(linkno).append("; END"))), "LINK".concat(String.valueOf(String.valueOf(linkno)))));
                this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("||").append(parentName).append("LINK").append(linkno).append("CONT = request.guardlink").append(linkno).append(":CONTAINER."))));
                this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer("set ").append(parentName).append("LINK").append(linkno).append("CONT_ALPHABET = {request.guardlink").append(linkno).append(".{read,write}.[IntRange]}"))));
                linksAlphabetList.add(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(parentName))).append("LINK").append(linkno).append("CONT_ALPHABET"))));
                linkLabel = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(parentName))).append("GUARD").append("LINK").append(linkno)));
            } else {
                if (constructNode.getNodeName().equals("source")) {
                    constructString = String.valueOf(String.valueOf(new StringBuffer("||").append(parentName).append("SRCLINK").append(linkno).append(" = (LINK").append(this.getLinkValue(actionName) + 1).append(").")));
                    linkLabel = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(parentName))).append("SRCLINK").append(linkno)));
                } else {
                    constructString = String.valueOf(String.valueOf(new StringBuffer("||").append(parentName).append("TARGETLINK").append(linkno).append(" = (LINK").append(this.getLinkValue(actionName) + 1).append(").")));
                    linkLabel = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(parentName))).append("TARGETLINK").append(linkno)));
                }
                this.writeFSPOutput(constructString);
            }
            if (constructNode.getNodeName().equals("source")) {
                srclist.add(linkLabel);
                continue;
            }
            targetlist.add(linkLabel);
        }
        constructString = String.valueOf(String.valueOf(parentName)).concat("LINKSEQ = ");
        if (targetlist.size() > 0) {
            String linkComp = "";
            linkComp = String.valueOf(String.valueOf(new StringBuffer("||").append(parentName).append("TARGETLINKS = (")));
            hassrctargetlinks = true;
            Iterator I = targetlist.iterator();
            while (I.hasNext()) {
                linkComp = String.valueOf(String.valueOf(linkComp)).concat(String.valueOf(String.valueOf(I.next())));
                if (!I.hasNext()) continue;
                linkComp = String.valueOf(String.valueOf(linkComp)).concat(" || ");
            }
            linkComp = String.valueOf(String.valueOf(linkComp)).concat(").");
            this.writeFSPOutput(linkComp);
            constructString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(constructString))).append(parentName).append("TARGETLINKS; ")));
        }
        constructString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(constructString))).append(parentName).append(";")));
        if (srclist.size() > 0) {
            String srclinkComp = "";
            srclinkComp = String.valueOf(String.valueOf(new StringBuffer("||").append(parentName).append("SRCLINKS = (")));
            hassrctargetlinks = true;
            Iterator I = srclist.iterator();
            while (I.hasNext()) {
                srclinkComp = String.valueOf(String.valueOf(srclinkComp)).concat(String.valueOf(String.valueOf(I.next())));
                if (!I.hasNext()) continue;
                srclinkComp = String.valueOf(String.valueOf(srclinkComp)).concat(" || ");
            }
            srclinkComp = String.valueOf(String.valueOf(srclinkComp)).concat(").");
            this.writeFSPOutput(srclinkComp);
            constructString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(constructString))).append(parentName).append("SRCLINKS; ")));
        }
        constructString = String.valueOf(String.valueOf(constructString)).concat("END");
        if (linksAlphabetList.size() > 0) {
            constructString = String.valueOf(String.valueOf(constructString)).concat(" + {");
            Iterator I = linksAlphabetList.iterator();
            while (I.hasNext()) {
                constructString = String.valueOf(String.valueOf(constructString)).concat(String.valueOf(String.valueOf(I.next())));
                if (!I.hasNext()) continue;
                constructString = String.valueOf(String.valueOf(constructString)).concat(",");
            }
            constructString = String.valueOf(String.valueOf(constructString)).concat("}");
        }
        constructString = String.valueOf(String.valueOf(constructString)).concat(".");
        if (!hassrctargetlinks) {
            constructname = parentName;
        } else {
            this.writeFSPOutput(constructString);
        }
        return constructname;
    }

    public String buildGuardFSP(Node FlowNode, String conditioncontainerName, String guardactionlist, String guardlabel) {
        boolean result = false;
        Object constructNodeList = null;
        Object constructNode = null;
        String compositionString = "";
        boolean constructcounter = false;
        String linkName = "";
        String constructName = "";
        String compositionName = "";
        String constructString = "";
        String conditioncontainerPart = "";
        String conditioncontainerValue = "";
        if (FlowNode.hasAttributes()) {
            linkName = FlowNode.getAttributes().getNamedItem("linkName").getNodeValue().toUpperCase();
        }
        compositionName = FlowNode.getParentNode().getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
        conditioncontainerPart = "guard".concat(String.valueOf(String.valueOf(guardlabel)));
        this.writeFSPOutput("");
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionName))).append(conditioncontainerPart.toUpperCase()).append(" = (").append(conditioncontainerName).append(".").append(conditioncontainerPart.toLowerCase()).append(".read[i:IntRange]->").append(compositionName).append(conditioncontainerPart.toUpperCase()).append("[i]),"))));
        this.writeFSPOutput(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(compositionName))).append(conditioncontainerPart.toUpperCase()).append("[i:IntRange] = if (i==").append(this.getAssignValue(conditioncontainerName, conditioncontainerValue)).append(") then ").append(guardactionlist).append("."))));
        return compositionString;
    }

    public String buildContainersFSP(Node FlowNode) {
        boolean result = false;
        Object constructNodeList = null;
        Object constructNode = null;
        String compositionString = "";
        boolean constructcounter = false;
        String constructName = "";
        String compositionName = "";
        String constructString = "";
        this.writeFSPOutput("// Container start");
        this.writeFSPOutput("range IntRange = 0..1");
        this.writeFSPOutput("CONTAINER(A=0) = CONTAINER[A],");
        this.writeFSPOutput("CONTAINER[i:IntRange] = ( write[j:IntRange]->CONTAINER[j] | read[i]->CONTAINER[i]),");
        this.writeFSPOutput("CONTAINER['null] = \t( write[j:IntRange]->CONTAINER[j] | read['null]->CONTAINER['null]).");
        this.writeFSPOutput("");
        this.writeFSPOutput("set ENUM = {a, b, c}");
        this.writeFSPOutput("ENUMCONTAINER(A='null) = CONTAINER[A],");
        this.writeFSPOutput("CONTAINER[i:ENUM] = ( write[j:ENUM]->CONTAINER[j] | read[i]->CONTAINER[i]),");
        this.writeFSPOutput("CONTAINER['null] = \t( write[j:ENUM]->CONTAINER[j] | read['null]->CONTAINER['null]).");
        this.writeFSPOutput("");
        this.writeFSPOutput("// Container end");
        this.writeFSPOutput("");
        return compositionString;
    }

    public String buildFlowFSP(Node FlowNode) {
        boolean result = false;
        NodeList constructNodeList = null;
        Node constructNode = null;
        String compositionString = "";
        int constructcounter = 0;
        String constructName = "";
        String compositionName = "";
        String constructString = "";
        constructNodeList = FlowNode.getChildNodes();
        compositionName = FlowNode.hasAttributes() ? FlowNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase() : "FLOW".concat(String.valueOf(String.valueOf(this.flowIDCounter++)));
        compositionString = String.valueOf(String.valueOf(new StringBuffer("||").append(compositionName).append(" = (")));
        constructcounter = 0;
        for (int loop = 0; loop < constructNodeList.getLength(); ++loop) {
            constructNode = constructNodeList.item(loop);
            if (this.isTextNode(constructNode) || (constructString = this.translateBPELNode(constructNode, false)).length() <= 0) continue;
            if (constructcounter > 0) {
                compositionString = String.valueOf(String.valueOf(compositionString)).concat(" || ");
            }
            if (constructNode.hasAttributes() && constructString.length() > 0) {
                constructName = constructNode.getAttributes().getNamedItem("name").getNodeValue().toUpperCase();
            }
            compositionString = String.valueOf(String.valueOf(compositionString)).concat(String.valueOf(String.valueOf(constructString)));
            ++constructcounter;
        }
        compositionString = String.valueOf(String.valueOf(compositionString)).concat(").");
        this.writeFSPOutput(compositionString);
        this.CompositionList.add(compositionName);
        return compositionName;
    }

    public boolean runAnalysis() {
        int loop;
        boolean result = false;
        NodeList tempNodeList = null;
        NodeList currentnodelist = null;
        int noofPartners = 0;
        int noofContainers = 0;
        int noofSequences = 0;
        int noofWhile = 0;
        int noofFlow = 0;
        boolean noofCorrelationSets = false;
        currentnodelist = this.bpelDoc.getElementsByTagName("partners");
        tempNodeList = currentnodelist.item(0).getChildNodes();
        for (loop = 0; loop < tempNodeList.getLength(); ++loop) {
            if (tempNodeList.item(loop).getNodeName().compareTo("partner") != 0) continue;
            ++noofPartners;
        }
        currentnodelist = this.bpelDoc.getElementsByTagName("containers");
        tempNodeList = currentnodelist.item(0).getChildNodes();
        for (loop = 0; loop < tempNodeList.getLength(); ++loop) {
            if (tempNodeList.item(loop).getNodeName().compareTo("container") != 0) continue;
            ++noofContainers;
        }
        currentnodelist = this.bpelDoc.getElementsByTagName("sequence");
        noofSequences = currentnodelist.getLength();
        currentnodelist = this.bpelDoc.getElementsByTagName("while");
        noofWhile = currentnodelist.getLength();
        currentnodelist = this.bpelDoc.getElementsByTagName("flow");
        noofFlow = currentnodelist.getLength();
        this.writeOutput("//******************************************************");
        this.writeOutput("//************     BPEL ANALYSIS        ****************");
        this.writeOutput("//******************************************************");
        this.writeOutput("//PARTNERS   : ".concat(String.valueOf(String.valueOf(noofPartners))));
        this.writeOutput("//CONTAINERS : ".concat(String.valueOf(String.valueOf(noofContainers))));
        this.writeOutput("//SEQUENCES  : ".concat(String.valueOf(String.valueOf(noofSequences))));
        this.writeOutput("//WHILE      : ".concat(String.valueOf(String.valueOf(noofWhile))));
        this.writeOutput("//FLOW       : ".concat(String.valueOf(String.valueOf(noofFlow))));
        this.writeOutput("//******************************************************");
        this.writeOutput("//******************************************************");
        return result;
    }

    public boolean convertProcess(String processName) {
        boolean result = false;
        return result;
    }

    public boolean loadBPEL(String BPELInput, boolean isFilename) {
        boolean result = false;
        if (BPELInput.length() > 0) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (isFilename) {
                    this.writeOutput("Loading BPEL Input: ".concat(String.valueOf(String.valueOf(BPELInput))));
                    this.bpelDoc = db.parse(BPELInput);
                } else {
                    StringBufferInputStream is = new StringBufferInputStream(BPELInput);
                    this.bpelDoc = db.parse(is);
                }
                this.processlist = this.bpelDoc.getElementsByTagName("process");
                if (this.processlist.getLength() > 0) {
                    this.currentprocessnode = this.processlist.item(0);
                    this.writeOutput("BPEL Process: ".concat(String.valueOf(String.valueOf(this.currentprocessnode.getAttributes().getNamedItem("name")))));
                } else {
                    this.writeOutput("ERROR: No process found.");
                }
                result = true;
            }
            catch (Exception E) {
                E.printStackTrace(System.err);
            }
            if (result) {
                this.writeOutput("Successfully Loaded : ".concat(String.valueOf(String.valueOf(BPELInput))));
            } else {
                this.writeOutput("Failed input : ".concat(String.valueOf(String.valueOf(BPELInput))));
            }
        } else {
            this.writeOutput("ERROR: No BPEL input specified to load.".concat(String.valueOf(String.valueOf(BPELInput))));
        }
        return result;
    }

    public void setFSPOutput(OutputStream os) {
        this.outFSPStream = os;
    }

    public void setOutput(OutputStream os) {
        this.outStream = os;
    }

    private boolean writeFSPOutput(String strOut) {
        boolean result = false;
        try {
            if (this.outFSPStream != null) {
                strOut = String.valueOf(String.valueOf(strOut)).concat("\n");
                this.outFSPStream.write(strOut.getBytes());
                this.outFSPStream.flush();
            } else {
                System.out.println(strOut);
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.err);
        }
        return result;
    }

    private boolean writeOutput(String strOut) {
        boolean result = false;
        try {
            if (this.outStream != null) {
                strOut = String.valueOf(String.valueOf(strOut)).concat("\n");
                this.outStream.write(strOut.getBytes());
                this.outStream.flush();
            } else {
                System.out.println(strOut);
            }
        }
        catch (Exception E) {
            E.printStackTrace(System.err);
        }
        return result;
    }

    public static void main(String[] args) {
        String Filename = "samples\\marketplace\\marketplace.bpel";
        File BPELFileObj = new File(Filename);
        String BPELFile = BPELFileObj.getAbsolutePath();
        int ext = BPELFileObj.getAbsolutePath().lastIndexOf(".");
        String filemname = BPELFileObj.getAbsolutePath().substring(0, ext);
        convert convert1 = new convert();
        try {
            convert1.setFSPOutput(System.out);
            convert1.loadBPEL(BPELFile, true);
            convert1.runAnalysis();
            convert1.translateToFSP();
        }
        catch (Exception E) {
            E.printStackTrace();
        }
    }
}

