/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import ic.doc.ltsa.lts.LTSOutput;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import mscedit.BMSC;
import mscedit.Link;
import mscedit.Specification;
import mscedit.XMLGui;
import synthesis.ImpliedScenarioSynthesiser;

public class MSCPlugin
extends LTSAPlugin {
    private XMLGui o_gui;
    private List o_toolbar_buttons;
    private Map o_menu_items;
    private JMenuBar o_menubar;
    private ImpliedScenarioSynthesiser o_msccompiler;

    public MSCPlugin() {
    }

    public MSCPlugin(LTSA lTSA) {
        super(lTSA);
    }

    public void initialise() {
        this.o_gui = new XMLGui();
        this.o_msccompiler = new ImpliedScenarioSynthesiser((LTSOutput)this.getLTSA());
        this.o_toolbar_buttons = new ArrayList();
        this.createButtons();
        this.o_menubar = new JMenuBar();
        this.o_menu_items = this.buildMenuItems();
        this.o_gui.populateMSCMenus(this.o_menubar, this.getLTSA());
    }

    public String getName() {
        return "MSC Editor";
    }

    public boolean addAsTab() {
        return true;
    }

    public Component getComponent() {
        return this.o_gui;
    }

    public boolean addToolbarButtons() {
        return true;
    }

    public List getToolbarButtons() {
        return this.o_toolbar_buttons;
    }

    public boolean addMenusToMenuBar() {
        return false;
    }

    public boolean useOwnMenuBar() {
        return false;
    }

    public JMenuBar getMenuBar() {
        return this.o_menubar;
    }

    public boolean providesNewFile() {
        return true;
    }

    public void newFile() {
        this.o_gui.newSpec();
    }

    public boolean providesOpenFile() {
        return true;
    }

    public void openFile(File file) {
        this.o_gui.openFile(file);
    }

    public boolean providesSaveFile() {
        return true;
    }

    public void saveFile(FileOutputStream fileOutputStream) {
        this.o_gui.saveFile(fileOutputStream);
    }

    public String getFileExtension() {
        return "xml";
    }

    public boolean addMenuItems() {
        return true;
    }

    public Map getMenuItems() {
        return this.o_menu_items;
    }

    private void createButtons() {
        ImageIcon imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/mscedit/icon/msc.gif"));
        LTSAButton lTSAButton = new LTSAButton(imageIcon, "Compile MSC", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSCPlugin.this.compilemsc();
            }
        });
        this.o_toolbar_buttons.add(lTSAButton);
        imageIcon = new ImageIcon(((Object)((Object)this)).getClass().getResource("/mscedit/icon/mscsafe.gif"));
        lTSAButton = new LTSAButton(imageIcon, "Safety check MSC", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSCPlugin.this.safetyCheckMSC();
            }
        });
        this.o_toolbar_buttons.add(lTSAButton);
    }

    private void compilemsc() {
        this.compilemsc(true);
    }

    private void compilemsc(boolean bl) {
        LTSA lTSA = this.getLTSA();
        lTSA.getUndoManager().discardAllEdits();
        lTSA.invalidateState();
        lTSA.clearOutput();
        Specification specification = this.o_gui.getSpecification();
        if (specification == null) {
            System.err.println("Specification return by gui is null");
        } else {
            String string = this.o_msccompiler.run(specification);
            if (string == null || string.trim().equals("")) {
                System.out.println("empty string returned from msc compiler");
            }
            if (string != null) {
                lTSA.getInputPane().setText(string);
                if (bl) {
                    lTSA.showOutput();
                }
                lTSA.parse();
                lTSA.setTargetChoice("ImpliedScenarioCheck");
                lTSA.updateDoState();
            }
        }
    }

    private void safetyCheckMSC() {
        this.compilemsc(false);
        LTSA lTSA = this.getLTSA();
        lTSA.setTargetChoice("ImpliedScenarioCheck");
        lTSA.compileNoClear();
        if (!lTSA.isCurrentStateNull()) {
            if (!lTSA.isCurrentStateComposed()) {
                lTSA.composeCurrentState();
                lTSA.analyseCurrentState();
                Vector vector = lTSA.getCurrentStateErrorTrace();
                if (vector != null) {
                    BMSC bMSC = this.createImpliedScenarioBMSC(vector);
                    this.o_gui.addBMSC(bMSC);
                    lTSA.swapto("MSC Editor");
                    int n = this.classifyScenario();
                    if (n < 0) {
                        this.o_gui.setNegCount(this.o_gui.getNegCount() + 1);
                        bMSC.setName("NegScen" + this.o_gui.getNegCount());
                        bMSC.negateLastMessage();
                        this.o_gui.renameTab("ImpScen", "NegScen" + this.o_gui.getNegCount());
                        this.o_gui.redrawCurrentCanvas();
                    } else if (n > 0) {
                        String string = JOptionPane.showInputDialog(null, "Give the scenario a name:", "Name scenario", 3);
                        bMSC.setName(string);
                        this.o_gui.renameTab("ImpScen", string);
                        this.o_gui.addBMSCtoHMSC(bMSC);
                    } else {
                        this.o_gui.deleteBMSC(bMSC.getName());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "No Implied Scenarios");
                    lTSA.outln("NO IMPLIED SCENARIOS");
                }
            }
            lTSA.postCurrentState();
        }
    }

    private BMSC createImpliedScenarioBMSC(List list) {
        List list2 = this.o_gui.getSpecification().getAllLinks();
        BMSC bMSC = new BMSC("ImpScen");
        Iterator iterator = this.o_gui.getInstanceAlphabet().iterator();
        while (iterator.hasNext()) {
            bMSC.addInstance((String)iterator.next());
        }
        int n = 1;
        Iterator iterator2 = list.iterator();
        block1: while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            Iterator iterator3 = list2.iterator();
            while (iterator3.hasNext()) {
                Link link = (Link)iterator3.next();
                if (!string.equals(link.getName())) continue;
                bMSC.addLink(link.getFrom(), link.getTo(), string, n);
                ++n;
                continue block1;
            }
        }
        return bMSC;
    }

    private int classifyScenario() {
        Object[] objectArray = new Object[]{"Positive", "Negative", "Ignore"};
        int n = JOptionPane.showOptionDialog(null, "Classify this scenario as positive or negative - or ignore it?", "Implied Scenario", 1, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return -1;
        }
        return 0;
    }

    private Map buildMenuItems() {
        HashMap<JCheckBoxMenuItem, String> hashMap = new HashMap<JCheckBoxMenuItem, String>();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("MSC Editor: Large display");
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSCPlugin.this.o_gui.setBigFont(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        hashMap.put(jCheckBoxMenuItem, "Options");
        jCheckBoxMenuItem = new JCheckBoxMenuItem("MSC Editor: Show toolbar");
        jCheckBoxMenuItem.setSelected(true);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MSCPlugin.this.o_gui.showToolBar(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
            }
        });
        hashMap.put(jCheckBoxMenuItem, "Options");
        return hashMap;
    }
}

