/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import ic.doc.ltsa.lts.LTSOutput;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import synthesis.BasicMSC;
import synthesis.Instance;
import synthesis.MyOutput;
import synthesis.Node;
import synthesis.Specification;

public class ControllerSynthesiser {
    private static final String SYSNAME = "ImpliedScenarioProperty";
    private static final String SYSVERSION = "v3.0";
    private boolean Error = false;

    public int synthesise(Specification specification, MyOutput myOutput, String string, LTSOutput lTSOutput) throws Exception {
        return this.BuildFSP(specification, myOutput, string, lTSOutput);
    }

    private int BuildFSP(Specification specification, MyOutput myOutput, String string, LTSOutput lTSOutput) throws Exception {
        Node node;
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
        Iterator iterator = specification.components().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            hashMap2.put(new Integer(n), object);
            if (bl2) {
                lTSOutput.outln(n + "-" + (String)object);
            }
            ++n;
        }
        object = this.BuildLTS(hashSet, hashMap, specification, hashMap2, lTSOutput);
        if (bl) {
            lTSOutput.outln("Number of Nodes:" + hashSet.size());
        }
        int n2 = hashSet.size();
        HashMap<Node, Integer> hashMap3 = new HashMap<Node, Integer>();
        Iterator<Object> iterator2 = hashSet.iterator();
        int n3 = 1;
        while (iterator2.hasNext()) {
            node = (Node)iterator2.next();
            hashMap3.put(node, new Integer(n3));
            ++n3;
        }
        myOutput.println("Coordinator = N" + hashMap3.get(object) + ",");
        iterator2 = hashMap.keySet().iterator();
        while (iterator2.hasNext()) {
            node = (Node)iterator2.next();
            Iterator iterator3 = ((Set)hashMap.get(node)).iterator();
            if (!iterator3.hasNext()) {
                myOutput.print("N" + hashMap3.get(node) + " = STOP");
            } else {
                myOutput.print("N" + hashMap3.get(node) + " = (");
                while (iterator3.hasNext()) {
                    Vector vector = (Vector)iterator3.next();
                    myOutput.print("s_" + hashMap2.get(vector.get(0)) + "_" + ((BasicMSC)vector.get((int)1)).name + " -> N" + hashMap3.get((Node)vector.get(2)));
                    if (!iterator3.hasNext()) continue;
                    myOutput.print("|");
                }
                myOutput.print(")");
            }
            if (iterator2.hasNext()) {
                myOutput.println(",");
                continue;
            }
            myOutput.println(".");
        }
        return n2;
    }

    private Node BuildLTS(Set set, Map map, Specification specification, Map map2, LTSOutput lTSOutput) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        FileOutputStream fileOutputStream = null;
        PrintStream printStream = null;
        if (bl3) {
            fileOutputStream = new FileOutputStream("benchmark.csv");
            printStream = new PrintStream(fileOutputStream);
        }
        HashMap hashMap = new HashMap();
        int n = 0;
        BasicMSC basicMSC = null;
        BasicMSC basicMSC2 = null;
        basicMSC = new BasicMSC();
        basicMSC.name = "BInit";
        Iterator iterator = specification.components().iterator();
        while (iterator.hasNext()) {
            basicMSC.addInstance((String)iterator.next(), new Instance());
        }
        basicMSC2 = basicMSC;
        if (bl) {
            lTSOutput.outln("Configure Init");
        }
        Node node = new Node(specification.components().size(), basicMSC2);
        node.Id = n++;
        set.add(node);
        int n2 = 0;
        n2 = this.addToRemaining(hashMap, node, n2);
        Node node2 = this.getNextFromRemaining(hashMap, n2);
        while (node2 != null) {
            int n3 = 0;
            if (bl) {
                lTSOutput.outln("Nodes = " + set.size() + " Remaining = " + hashMap.size() + " Nodes in Transitions = " + map.keySet().size());
            }
            if (bl2) {
                lTSOutput.outln("Processing node:" + node2.Id);
            }
            int n4 = 0;
            while (n4 < specification.components().size()) {
                Object object;
                Object object2;
                Object object3;
                if (bl) {
                    lTSOutput.outln("Looking at component " + map2.get(new Integer(n4)));
                }
                HashSet<Object> hashSet = new HashSet<Object>();
                if (!node2.isFirst(n4)) {
                    if (bl) {
                        lTSOutput.outln("No pica en punta");
                    }
                    object3 = node2.Clone();
                    ((Node)object3).Id = n++;
                    if (((Node)object3).Move(n4, map2, printStream, lTSOutput)) {
                        object2 = ((Node)object3).eliminateLoop(lTSOutput);
                        if (object2 != null) {
                            object3 = object2;
                        }
                        if ((object = this.AlreadyExists(set, (Node)object3, map2, lTSOutput)) == null) {
                            hashSet.add(object3);
                        } else {
                            hashSet.add(object);
                        }
                    }
                } else {
                    if (bl) {
                        lTSOutput.outln("Looking at continuations");
                    }
                    object2 = (object3 = node2.getLocation(n4)) == basicMSC ? specification.getContinuationsInit() : specification.getContinuations((BasicMSC)object3);
                    object = object2.iterator();
                    while (object.hasNext()) {
                        BasicMSC basicMSC3 = (BasicMSC)object.next();
                        if (bl) {
                            lTSOutput.outln("Cloning");
                        }
                        Node node3 = node2.Clone();
                        node3.Id = n++;
                        if (bl) {
                            lTSOutput.outln("Moving");
                        }
                        if (node3.Move(n4, basicMSC3, map2, printStream, lTSOutput)) {
                            Node node4;
                            Node node5 = node3.eliminateLoop(lTSOutput);
                            if (node5 != null) {
                                node3 = node5;
                            }
                            if ((node4 = this.AlreadyExists(set, node3, map2, lTSOutput)) == null) {
                                hashSet.add(node3);
                            } else {
                                hashSet.add(node4);
                            }
                        }
                        if (!bl) continue;
                        lTSOutput.outln("Moved");
                    }
                }
                if (bl) {
                    lTSOutput.outln("Size of NewNodes = " + hashSet.size());
                }
                object3 = hashSet.iterator();
                while (object3.hasNext()) {
                    object2 = (Node)object3.next();
                    if (!set.contains(object2)) {
                        set.add(object2);
                        if (bl) {
                            ((Node)object2).print(lTSOutput);
                        }
                        n2 = this.addToRemaining(hashMap, (Node)object2, n2);
                    }
                    ++n3;
                    this.AddTransition(map, node2, (Node)object2, n4, ((Node)object2).getLocation(n4), lTSOutput);
                }
                ++n4;
            }
            this.RemoveFromRemaining(node2, hashMap, n2);
            node2 = this.getNextFromRemaining(hashMap, n2);
        }
        if (bl3) {
            printStream.close();
            fileOutputStream.close();
        }
        return node;
    }

    private Node AlreadyExists(Set set, Node node, Map map, LTSOutput lTSOutput) {
        boolean bl = false;
        if (bl) {
            lTSOutput.outln("");
        }
        if (bl) {
            lTSOutput.outln("!!!Looking for replacement of :" + node.Id);
        }
        if (bl) {
            node.print(lTSOutput);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (!node.Equals(node2)) continue;
            return node2;
        }
        return null;
    }

    private void RemoveFromRemaining(Node node, Map map, int n) {
        int n2 = 0;
        while (n2 <= n) {
            Set set;
            Integer n3 = new Integer(n2);
            if (map.keySet().contains(n3) && (set = (Set)map.get(n3)).contains(node)) {
                set.remove(node);
                return;
            }
            ++n2;
        }
    }

    private int addToRemaining(Map map, Node node, int n) {
        int n2 = node.SizeOfDestiny();
        Integer n3 = new Integer(n2);
        Set<Node> set = null;
        if (map.keySet().contains(n3)) {
            set = (Set)map.get(n3);
        } else {
            set = new HashSet();
            if (n < n2) {
                n = n2;
            }
            map.put(n3, set);
        }
        set.add(node);
        return n;
    }

    private Node getNextFromRemaining(Map map, int n) {
        int n2 = 0;
        while (n2 <= n) {
            Set set;
            Iterator iterator;
            Integer n3 = new Integer(n2);
            if (map.keySet().contains(n3) && (iterator = (set = (Set)map.get(n3)).iterator()).hasNext()) {
                return (Node)iterator.next();
            }
            ++n2;
        }
        return null;
    }

    private void AddTransition(Map map, Node node, Node node2, int n, BasicMSC basicMSC, LTSOutput lTSOutput) {
        if (!map.keySet().contains(node)) {
            map.put(node, new HashSet());
        }
        if (!map.keySet().contains(node2)) {
            map.put(node2, new HashSet());
        }
        Set set = (Set)map.get(node);
        Vector<Object> vector = new Vector<Object>(4);
        vector.add(0, new Integer(n));
        vector.add(1, basicMSC);
        vector.add(2, node2);
        set.add(vector);
    }
}

