/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import java.util.Hashtable;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMStateSet;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private XSParticleDecl[] fElemMap = null;
    private int[] fElemMapType = null;
    private int fElemMapSize = 0;
    private boolean fMixed;
    private static final XSParticleDecl fEOCParticle = new XSParticleDecl();
    private int fEOCPos = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private int fTransTableSize = 0;
    private boolean fEmptyContentIsValid = false;
    private static long time;

    public XSDFACM(CMNode cMNode, int n) {
        this(cMNode, n, false);
    }

    public XSDFACM(CMNode cMNode, int n, boolean bl) {
        this.fLeafCount = n;
        this.fMixed = bl;
        this.buildDFA(cMNode);
    }

    public boolean isFinalState(int n) {
        return n < 0 ? false : this.fFinalStateFlags[n];
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        int n = nArray[0];
        if (n == -1 || n == -2) {
            if (n == -1) {
                nArray[0] = -2;
            }
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        int n2 = 0;
        int n3 = 0;
        Object object = null;
        while (n3 < this.fElemMapSize) {
            int n4 = this.fElemMapType[n3];
            if (n4 == 1) {
                object = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n3].fValue);
                if (object != null && (n2 = this.fTransTable[n][n3]) != -1) {
                    break;
                }
            } else if (n4 == 2 && ((XSWildcardDecl)this.fElemMap[n3].fValue).allowNamespace(qName.uri)) {
                object = this.fElemMap[n3].fValue;
                n2 = this.fTransTable[n][n3];
                if (n2 != -1) break;
            }
            ++n3;
        }
        if (n3 == this.fElemMapSize) {
            nArray[0] = -1;
            return this.findMatchingDecl(qName, substitutionGroupHandler);
        }
        nArray[0] = n2;
        return object;
    }

    Object findMatchingDecl(QName qName, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        int n = 0;
        while (n < this.fElemMapSize) {
            int n2 = this.fElemMapType[n];
            if (n2 == 1) {
                xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, (XSElementDecl)this.fElemMap[n].fValue);
                if (xSElementDecl != null) {
                    return xSElementDecl;
                }
            } else if (n2 == 2 && ((XSWildcardDecl)this.fElemMap[n].fValue).allowNamespace(qName.uri)) {
                return this.fElemMap[n].fValue;
            }
            ++n;
        }
        return null;
    }

    public int[] startContentModel() {
        int[] nArray = new int[]{0};
        return nArray;
    }

    public boolean endContentModel(int[] nArray) {
        return this.fFinalStateFlags[nArray[0]];
    }

    private void buildDFA(CMNode cMNode) {
        XSCMLeaf xSCMLeaf = new XSCMLeaf(fEOCParticle);
        this.fHeadNode = new XSCMBinOp(4, cMNode, xSCMLeaf);
        this.fEOCPos = this.fLeafCount;
        xSCMLeaf.setPosition(this.fLeafCount++);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode, 0);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int n = 0;
        while (n < this.fLeafCount) {
            this.fFollowList[n] = new CMStateSet(this.fLeafCount);
            ++n;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new XSParticleDecl[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        int n2 = 0;
        while (n2 < this.fLeafCount) {
            this.fElemMap[n2] = null;
            int n3 = 0;
            XSParticleDecl xSParticleDecl = this.fLeafList[n2].getLeaf();
            while (n3 < this.fElemMapSize) {
                if (xSParticleDecl == this.fElemMap[n3]) break;
                ++n3;
            }
            if (n3 == this.fElemMapSize) {
                this.fElemMap[this.fElemMapSize] = xSParticleDecl;
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[n2];
                ++this.fElemMapSize;
            }
            ++n2;
        }
        --this.fElemMapSize;
        int[] nArray = new int[this.fLeafCount + this.fElemMapSize];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.fElemMapSize) {
            XSParticleDecl xSParticleDecl = this.fElemMap[n5];
            int n6 = 0;
            while (n6 < this.fLeafCount) {
                if (xSParticleDecl == this.fLeafList[n6].getLeaf()) {
                    nArray[n4++] = n6;
                }
                ++n6;
            }
            nArray[n4++] = -1;
            ++n5;
        }
        int n7 = this.fLeafCount * 4;
        CMStateSet[] cMStateSetArray = new CMStateSet[n7];
        this.fFinalStateFlags = new boolean[n7];
        this.fTransTable = new int[n7][];
        CMStateSet cMStateSet = this.fHeadNode.firstPos();
        int n8 = 0;
        int n9 = 0;
        this.fTransTable[n9] = this.makeDefStateList();
        cMStateSetArray[n9] = cMStateSet;
        ++n9;
        Hashtable<CMStateSet, Integer> hashtable = new Hashtable<CMStateSet, Integer>();
        while (n8 < n9) {
            cMStateSet = cMStateSetArray[n8];
            int[] nArray2 = this.fTransTable[n8];
            this.fFinalStateFlags[n8] = cMStateSet.getBit(this.fEOCPos);
            ++n8;
            CMStateSet cMStateSet2 = null;
            int n10 = 0;
            int n11 = 0;
            while (n11 < this.fElemMapSize) {
                if (cMStateSet2 == null) {
                    cMStateSet2 = new CMStateSet(this.fLeafCount);
                } else {
                    cMStateSet2.zeroBits();
                }
                int n12 = nArray[n10++];
                while (n12 != -1) {
                    if (cMStateSet.getBit(n12)) {
                        cMStateSet2.union(this.fFollowList[n12]);
                    }
                    n12 = nArray[n10++];
                }
                if (!cMStateSet2.isEmpty()) {
                    int n13;
                    Integer n14 = (Integer)hashtable.get(cMStateSet2);
                    int n15 = n13 = n14 == null ? n9 : n14;
                    if (n13 == n9) {
                        cMStateSetArray[n9] = cMStateSet2;
                        this.fTransTable[n9] = this.makeDefStateList();
                        hashtable.put(cMStateSet2, new Integer(n9));
                        ++n9;
                        cMStateSet2 = null;
                    }
                    nArray2[n11] = n13;
                    if (n9 == n7) {
                        int n16 = (int)((double)n7 * 1.5);
                        CMStateSet[] cMStateSetArray2 = new CMStateSet[n16];
                        boolean[] blArray = new boolean[n16];
                        int[][] nArrayArray = new int[n16][];
                        int n17 = 0;
                        while (n17 < n7) {
                            cMStateSetArray2[n17] = cMStateSetArray[n17];
                            blArray[n17] = this.fFinalStateFlags[n17];
                            nArrayArray[n17] = this.fTransTable[n17];
                            ++n17;
                        }
                        n7 = n16;
                        cMStateSetArray = cMStateSetArray2;
                        this.fFinalStateFlags = blArray;
                        this.fTransTable = nArrayArray;
                    }
                }
                ++n11;
            }
        }
        this.fEmptyContentIsValid = ((XSCMBinOp)this.fHeadNode).getLeft().isNullable();
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
    }

    private void calcFollowList(CMNode cMNode) {
        if (cMNode.type() == 3) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
        } else if (cMNode.type() == 4) {
            this.calcFollowList(((XSCMBinOp)cMNode).getLeft());
            this.calcFollowList(((XSCMBinOp)cMNode).getRight());
            CMStateSet cMStateSet = ((XSCMBinOp)cMNode).getLeft().lastPos();
            CMStateSet cMStateSet2 = ((XSCMBinOp)cMNode).getRight().firstPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet2);
                }
                ++n;
            }
        } else if (cMNode.type() == 7 || cMNode.type() == 8) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
            CMStateSet cMStateSet = cMNode.firstPos();
            CMStateSet cMStateSet3 = cMNode.lastPos();
            int n = 0;
            while (n < this.fLeafCount) {
                if (cMStateSet3.getBit(n)) {
                    this.fFollowList[n].union(cMStateSet);
                }
                ++n;
            }
        } else if (cMNode.type() == 6) {
            this.calcFollowList(((XSCMUniOp)cMNode).getChild());
        }
    }

    private void dumpTree(CMNode cMNode, int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print("   ");
            ++n2;
        }
        int n3 = cMNode.type();
        switch (n3) {
            case 3: 
            case 4: {
                if (n3 == 3) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMBinOp)cMNode).getLeft(), n + 1);
                this.dumpTree(((XSCMBinOp)cMNode).getRight(), n + 1);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                System.out.print("Rep Node ");
                if (cMNode.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                this.dumpTree(((XSCMUniOp)cMNode).getChild(), n + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)cMNode).getPosition() + "), " + ((XSCMLeaf)cMNode).getLeaf().fValue + "(elemIndex=" + ((XSCMLeaf)cMNode).getLeaf().fValue + ") ");
                if (cMNode.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(cMNode.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(cMNode.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] nArray = new int[this.fElemMapSize];
        int n = 0;
        while (n < this.fElemMapSize) {
            nArray[n] = -1;
            ++n;
        }
        return nArray;
    }

    private int postTreeBuildInit(CMNode cMNode, int n) throws RuntimeException {
        cMNode.setMaxStates(this.fLeafCount);
        if (cMNode.type() == 2) {
            this.fLeafList[n] = (XSCMLeaf)cMNode;
            this.fLeafListType[n] = 2;
            ++n;
        } else if (cMNode.type() == 3 || cMNode.type() == 4) {
            n = this.postTreeBuildInit(((XSCMBinOp)cMNode).getLeft(), n);
            n = this.postTreeBuildInit(((XSCMBinOp)cMNode).getRight(), n);
        } else if (cMNode.type() == 7 || cMNode.type() == 8 || cMNode.type() == 6) {
            n = this.postTreeBuildInit(((XSCMUniOp)cMNode).getChild(), n);
        } else if (cMNode.type() == 1) {
            this.fLeafList[n] = (XSCMLeaf)cMNode;
            this.fLeafListType[n] = 1;
            ++n;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
        return n;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n;
        int n2;
        byte[][] byArray = new byte[this.fElemMapSize][this.fElemMapSize];
        int n3 = 0;
        while (n3 < this.fTransTable.length && this.fTransTable[n3] != null) {
            n2 = 0;
            while (n2 < this.fElemMapSize) {
                n = n2 + 1;
                while (n < this.fElemMapSize) {
                    if (this.fTransTable[n3][n2] != -1 && this.fTransTable[n3][n] != -1 && byArray[n2][n] == 0) {
                        byArray[n2][n] = XSConstraints.overlapUPA(this.fElemMap[n2].fValue, this.fElemMap[n].fValue, substitutionGroupHandler) ? 1 : -1;
                    }
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.fElemMapSize) {
            n = 0;
            while (n < this.fElemMapSize) {
                if (byArray[n2][n] == 1) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[n2].toString(), this.fElemMap[n].toString()});
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < this.fElemMapSize) {
            if (this.fElemMapType[n] == 2) {
                XSWildcardDecl xSWildcardDecl = (XSWildcardDecl)this.fElemMap[n].fValue;
                if (xSWildcardDecl.fType == 2 || xSWildcardDecl.fType == 1) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    static {
        XSDFACM.fEOCParticle.fType = 1;
        time = 0L;
    }
}

