/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.DoubleBehaviourListener;
import uk.ac.ic.doc.scenebeans.PointBehaviourListener;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraphBase;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;

public class Line
extends SceneGraphBase
implements Primitive {
    private double _x0;
    private double _y0;
    private double _x1;
    private double _y1;
    private Shape _last_drawn = null;

    public Line() {
        this._x0 = 0.0;
        this._y0 = 0.0;
        this._x1 = 1.0;
        this._y1 = 1.0;
    }

    public Line(Point2D point2D, Point2D point2D2) {
        this._x0 = point2D.getX();
        this._y0 = point2D.getY();
        this._x1 = point2D2.getX();
        this._y1 = point2D2.getY();
    }

    public Line(double d, double d2, double d3, double d4) {
        this._x0 = d;
        this._y0 = d2;
        this._x1 = d3;
        this._y1 = d4;
    }

    public Shape getShape(Graphics2D graphics2D) {
        return new Line2D.Double(this._x0, this._y0, this._x1, this._y1);
    }

    public Shape getLastDrawnShape() {
        return this._last_drawn;
    }

    public Point2D getStart() {
        return new Point2D.Double(this._x0, this._y0);
    }

    public void setStart(Point2D point2D) {
        this._x0 = point2D.getX();
        this._y0 = point2D.getY();
        this.setDirty(true);
    }

    public Point2D getEnd() {
        return new Point2D.Double(this._x1, this._y1);
    }

    public void setEnd(Point2D point2D) {
        this._x1 = point2D.getX();
        this._y1 = point2D.getY();
        this.setDirty(true);
    }

    public double getStartX() {
        return this._x0;
    }

    public void setStartX(double d) {
        this._x0 = d;
        this.setDirty(true);
    }

    public double getStartY() {
        return this._y0;
    }

    public void setStartY(double d) {
        this._y0 = d;
        this.setDirty(true);
    }

    public double getEndX() {
        return this._x1;
    }

    public void setEndX(double d) {
        this._x1 = d;
        this.setDirty(true);
    }

    public double getEndY() {
        return this._y1;
    }

    public void setEndY(double d) {
        this._y1 = d;
        this.setDirty(true);
    }

    public void accept(SceneGraphProcessor sceneGraphProcessor) {
        sceneGraphProcessor.process(this);
    }

    public void draw(Graphics2D graphics2D) {
        Shape shape = this.getShape(graphics2D);
        graphics2D.draw(shape);
        this._last_drawn = shape;
        this.setDirty(false);
    }

    public final Start newStartAdapter() {
        return new Start();
    }

    public final End newEndAdapter() {
        return new End();
    }

    public final StartX newStartXAdapter() {
        return new StartX();
    }

    public final StartY newStartYAdapter() {
        return new StartY();
    }

    public final EndX newEndXAdapter() {
        return new EndX();
    }

    public final EndY newEndYAdapter() {
        return new EndY();
    }

    public class EndY
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            Line.this.setEndY(d);
        }
    }

    public class EndX
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            Line.this.setEndX(d);
        }
    }

    public class StartY
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            Line.this.setStartY(d);
        }
    }

    public class StartX
    implements DoubleBehaviourListener,
    Serializable {
        public void behaviourUpdated(double d) {
            Line.this.setStartX(d);
        }
    }

    public class End
    implements PointBehaviourListener,
    Serializable {
        public void behaviourUpdated(Point2D point2D) {
            Line.this.setEnd(point2D);
        }
    }

    public class Start
    implements PointBehaviourListener,
    Serializable {
        public void behaviourUpdated(Point2D point2D) {
            Line.this.setStart(point2D);
        }
    }
}

