/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.behaviour;

import java.awt.geom.Point2D;
import java.io.Serializable;
import uk.ac.ic.doc.scenebeans.behaviour.PointActivityBase;

public class Track
extends PointActivityBase
implements Serializable {
    private double[] _nodes;
    private String[] _events;
    private double _timeout = 0.0;
    private int _current = 0;

    public Track() {
        this._nodes = new double[0];
        this._events = new String[0];
    }

    public Track(int n) {
        this._nodes = new double[3 * n - 1];
        this._events = new String[n - 1];
    }

    public synchronized int getPointCount() {
        return (this._nodes.length + 1) / 3;
    }

    public synchronized void setPointCount(int n) {
        double[] dArray = new double[3 * n - 1];
        System.arraycopy(this._nodes, 0, dArray, 0, Math.min(this._nodes.length, dArray.length));
        this._nodes = dArray;
        String[] stringArray = new String[n - 1];
        System.arraycopy(this._events, 0, stringArray, 0, Math.min(this._events.length, stringArray.length));
        this._events = stringArray;
    }

    public synchronized Point2D getPoint(int n) {
        return new Point2D.Double(this._nodes[n *= 3], this._nodes[n + 1]);
    }

    public synchronized void setPoint(int n, Point2D point2D) {
        this._nodes[n *= 3] = point2D.getX();
        this._nodes[n + 1] = point2D.getY();
    }

    public synchronized double getX(int n) {
        return this._nodes[n * 3];
    }

    public synchronized void setX(int n, double d) {
        this._nodes[n * 3] = d;
    }

    public synchronized double getY(int n) {
        return this._nodes[n * 3 + 1];
    }

    public synchronized void setY(int n, double d) {
        this._nodes[n * 3 + 1] = d;
    }

    public synchronized double getDuration(int n) {
        return this._nodes[n * 3 + 2];
    }

    public synchronized void setDuration(int n, double d) {
        this._nodes[n * 3 + 2] = d;
    }

    public synchronized String getEvent(int n) {
        return this._events[n];
    }

    public synchronized void setEvent(int n, String string) {
        this._events[n] = string;
    }

    public synchronized Point2D getValue() {
        if (this.hasFinished()) {
            return this.getPoint(this.getPointCount() - 1);
        }
        double d = this.getX(this._current);
        double d2 = this.getY(this._current);
        double d3 = this.getX(this._current + 1);
        double d4 = this.getY(this._current + 1);
        return new Point2D.Double(d + this.ratio() * (d3 - d), d2 + this.ratio() * (d4 - d2));
    }

    public boolean isFinite() {
        return true;
    }

    public synchronized void reset() {
        this._current = 0;
        this._timeout = 0.0;
        this.postUpdate(this.getValue());
    }

    public synchronized void performActivity(double d) {
        this._timeout += d;
        while (!this.hasFinished() && this._timeout >= this.getDuration(this._current)) {
            this._timeout -= this.getDuration(this._current);
            if (this._events[this._current] != null) {
                this.postActivityComplete(this._events[this._current]);
            }
            ++this._current;
        }
        if (this.hasFinished()) {
            this.postActivityComplete();
        }
        this.postUpdate(this.getValue());
    }

    private double ratio() {
        double d = this.getDuration(this._current);
        return this._timeout / d;
    }

    private boolean hasFinished() {
        return this._current >= this.getPointCount() - 1;
    }
}

