/*
 * Decompiled with CFR 0.152.
 */
package LTSABPELPlugIn;

import java.io.ByteArrayInputStream;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XTree
extends JTree {
    private DefaultMutableTreeNode treeNode;
    private DocumentBuilderFactory dbf;
    private DocumentBuilder db;
    private Document doc;

    public XTree(String text) throws ParserConfigurationException {
        this();
        this.refresh(text);
    }

    public XTree() throws ParserConfigurationException {
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setValidating(false);
        this.db = this.dbf.newDocumentBuilder();
        this.setModel(this.buildWelcomeTree());
    }

    private DefaultTreeModel buildTree(String text) {
        Node newNode = this.parseXml(text);
        if (newNode != null) {
            DefaultMutableTreeNode treeNode = this.createTreeNode(newNode);
            return new DefaultTreeModel(treeNode);
        }
        return null;
    }

    private DefaultTreeModel buildWelcomeTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Welcome to BPEL4WS XML View 1.0");
        DefaultMutableTreeNode instructions = new DefaultMutableTreeNode("Instructions");
        DefaultMutableTreeNode openingDoc = new DefaultMutableTreeNode("Opening XML Documents");
        DefaultMutableTreeNode openingDocText = new DefaultMutableTreeNode("When invoking the XmlEditor from the command-line, you must specify the filename.");
        DefaultMutableTreeNode editingDoc = new DefaultMutableTreeNode("Editing an XML Document");
        DefaultMutableTreeNode editingDocText = new DefaultMutableTreeNode("XML text in the right hand frame can be edited directly.  The \"refresh\" button will rebuild the JTree in the left frame.");
        DefaultMutableTreeNode savingDoc = new DefaultMutableTreeNode("Saving an XML Document");
        DefaultMutableTreeNode savingDocText = new DefaultMutableTreeNode("This iteration of the XmlEditor does not provide the ability to save your document.  That will come with the next article.");
        root.add(instructions);
        instructions.add(openingDoc);
        instructions.add(editingDoc);
        openingDoc.add(openingDocText);
        editingDoc.add(editingDocText);
        return new DefaultTreeModel(root);
    }

    public void refresh(String text) {
        DefaultTreeModel treeMod = this.buildTree(text);
        if (treeMod != null) {
            this.setModel(treeMod);
        }
    }

    private DefaultMutableTreeNode createTreeNode(Node root) {
        NodeList children;
        DefaultMutableTreeNode treeNode = null;
        String type = this.getNodeType(root);
        String name = root.getNodeName();
        String value = root.getNodeValue();
        treeNode = new DefaultMutableTreeNode(root.getNodeType() == 3 ? value : name);
        NamedNodeMap attribs = root.getAttributes();
        if (attribs != null) {
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attribNode = attribs.item(i);
                name = attribNode.getNodeName().trim();
                value = attribNode.getNodeValue().trim();
                if (value == null || value.length() <= 0) continue;
                treeNode.add(new DefaultMutableTreeNode(String.valueOf(String.valueOf(new StringBuffer("[Attribute] --> ").append(name).append("=\"").append(value).append("\"")))));
            }
        }
        if (root.hasChildNodes() && (children = root.getChildNodes()) != null) {
            int numChildren = children.getLength();
            for (int i = 0; i < numChildren; ++i) {
                String data;
                Node node = children.item(i);
                if (node == null) continue;
                if (node.getNodeType() == 1) {
                    treeNode.add(this.createTreeNode(node));
                }
                if ((data = node.getNodeValue()) == null || (data = data.trim()).equals("\n") || data.equals("\r\n") || data.length() <= 0) continue;
                treeNode.add(this.createTreeNode(node));
            }
        }
        return treeNode;
    }

    private String getNodeType(Node node) {
        String type;
        switch (node.getNodeType()) {
            case 1: {
                type = "Element";
                break;
            }
            case 2: {
                type = "Attribute";
                break;
            }
            case 3: {
                type = "Text";
                break;
            }
            case 4: {
                type = "CData section";
                break;
            }
            case 5: {
                type = "Entity reference";
                break;
            }
            case 6: {
                type = "Entity";
                break;
            }
            case 7: {
                type = "Processing instruction";
                break;
            }
            case 8: {
                type = "Comment";
                break;
            }
            case 9: {
                type = "Document";
                break;
            }
            case 10: {
                type = "Document type";
                break;
            }
            case 11: {
                type = "Document fragment";
                break;
            }
            case 12: {
                type = "Notation";
                break;
            }
            default: {
                type = "???";
            }
        }
        return type;
    }

    private Node parseXml(String xml) {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(xml.getBytes());
        try {
            this.doc = this.db.parse(byteStream);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Node node = null;
            return node;
        }
        return this.doc.getDocumentElement();
    }
}

