#!/bin/sh

function environerror
{
  echo ""
  echo "BPWS4J Loan Approval Sample"
  echo "  An error occurred when invoking the sample.  Please set your BPWS4J_HOME and JAVA_HOME environment variables before continuing." | fmt
  echo ""
  exit 1
}

function help
{
  echo ""
  echo "BPWS4J Loan Approval Sample"
  echo "  Usage: LoanApprovalSample <runtime-URL> <first-name> <last-name> <amount>" | fmt
  echo "  e.g. LoanApprovalSample http://localhost:8080/bpws4j/soaprpcrouter John Doe 100" | fmt
  echo ""
  exit 1
}

if [ "$BPWS4J_HOME" = "" ] ; then
  environerror
elif [ "$JAVA_HOME" = "" ] ; then
  environerror
else
  ENDPOINT=$1
  FIRSTNAME=$2
  LASTNAME=$3
  AMOUNT=$4
  if [ "$ENDPOINT" = "" ] ; then
    help
  elif [ "$FIRSTNAME" = "" ] ; then
    help
  elif [ "$LASTNAME" = "" ] ; then
    help
  elif [ "$AMOUNT" = "" ] ; then
    help
  else
    CP=$BPWS4J_HOME/lib/bpws4j-samples.jar
    CP=$CP:$BPWS4J_HOME/lib/soap.jar
    CP=$CP:$BPWS4J_HOME/lib/xml-apis.jar
    CP=$CP:$BPWS4J_HOME/lib/xercesImpl.jar
    CP=$CP:$CLASSPATH
    export CP
    $JAVA_HOME/jre/bin/java -classpath $CP samples.loanapproval.Customer $ENDPOINT $FIRSTNAME $LASTNAME $AMOUNT
    exit 0
  fi 
fi
