package samples.news;

import java.io.*;
import java.net.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.soap.*;
import org.apache.soap.rpc.*;

/**
 * Servlet that processes data from HTML form,
 * gets language preference and invokes translation news
 * web service.
 *
 * @author Nirmal Mukhi (nmukhi@us.ibm.com)
 */
public class TranslateNews extends HttpServlet {
    public String SOAP_ROUTER_URL="http://localhost:8080/bpws4j/soaprpcrouter";

  public void init() throws ServletException
  {
    ServletConfig servletConfig = getServletConfig();
    if (servletConfig.getInitParameter("soap-router-url") != null)
    {
      SOAP_ROUTER_URL = servletConfig.getInitParameter("soap-router-url");
    }
  }

    public void doGet(HttpServletRequest request,
		      HttpServletResponse response)
	throws ServletException, IOException {
	// set up printing of output
	response.setContentType("text/html");
	PrintWriter out = response.getWriter();
	// get the language of choice
	String language = request.getParameter("language");
	// invoke the Web service
	String translatedNews = "";
	try {
	    translatedNews = invokeService(language);
	} catch (Exception e) {
	    out.println("<HTML><HEAD><TITLE>Error</TITLE></HEAD>\n"+
			"<BODY>\n"+
			"Received exception "+e+
			"</BODY></HTML>");
	}
	// print translated news
	String title = "Translated News";
	out.println("<HTML>\n<HEAD><TITLE>"+title+"</TITLE></HEAD>\n" +
		    "<BODY>\n" +
		    "<p>Ignore the <em>Translate Again</em> text box at the bottom of the translated news; this is part of the output of the BabelFish service. We could write another piece of logic within our process to strip of that part of the output and return just what is relevant to the user</p>"+
		    "<H2 ALIGN=CENTER>" + title + "</H2>\n" +
		    "<pre>"+translatedNews+"</pre>"+
		    "</BODY></HTML>");
    }

    public void doPost(HttpServletRequest request,
		       HttpServletResponse response)
	throws ServletException, IOException {
	doGet(request, response);
    }

    private String invokeService(String language) throws MalformedURLException, SOAPException {
	String returnValue = new String();
	// Build the call.
	Call call = new Call ();
	call.setTargetObjectURI ("urn:news:NewsService#NewsTranslationProcess#User#urn:news:NewsService#NewsPT");
	call.setMethodName ("getNews");
	call.setEncodingStyleURI(Constants.NS_URI_SOAP_ENC);
	Vector params = new Vector ();
	params.addElement (new Parameter("language", String.class, language, null));
	call.setParams (params);
	
	Response resp = call.invoke (/* router URL */ new URL(SOAP_ROUTER_URL), /* actionURI */ "" );
	
	// Check the response.
	if (resp.generatedFault ()) {
	    Fault fault = resp.getFault ();
	    returnValue = "Received fault\n"+
		"\n  Fault Code   = " + fault.getFaultCode()+
		"\n  Fault String = " + fault.getFaultString()+
		"\n  Fault        = " + fault;
	} else {
	    Parameter result = resp.getReturnValue ();
	    if (result != null)
		returnValue = (String) result.getValue();
	    else
		returnValue = "No response was returned.  Perhaps there was an error with the flow";
	}
	return returnValue;
    }
}
