#!/bin/sh

function environerror
{
  echo ""
  echo "BPWS4J Simple Sample"
  echo "  An error occurred when invoking the sample.  Please set your BPWS4J_HOME and JAVA_HOME environment variables before continuing." | fmt
  echo ""
  exit 1
}

function help
{
  echo ""
  echo "BPWS4J Simple Sample"
  echo "  Usage: SimpleSample <runtime-URL> <stock-symbol>" | fmt
  echo "  e.g. SimpleSample http://localhost:8080/bpws4j/soaprpcrouter IBM" | fmt
  echo ""
  exit 1
}

if [ "$BPWS4J_HOME" = "" ] ; then
  environerror
elif [ "$JAVA_HOME" = "" ] ; then
  environerror
else
  ENDPOINT=$1
  SYMBOL=$2
  if [ "$ENDPOINT" = "" ] ; then
    help
  elif [ "$SYMBOL" = "" ] ; then
    help
  else
    CP=$BPWS4J_HOME/lib/bpws4j-samples.jar
    CP=$CP:$BPWS4J_HOME/lib/soap.jar
    CP=$CP:$BPWS4J_HOME/lib/xml-apis.jar
    CP=$CP:$BPWS4J_HOME/lib/xercesImpl.jar
    CP=$CP:$CLASSPATH
    export CP
    $JAVA_HOME/jre/bin/java -classpath $CP samples.simple.GetQuote $ENDPOINT $SYMBOL
    exit 0
  fi 
fi
