/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.editor;

import ic.doc.ltsa.editor.ColoredDocument;
import ic.doc.ltsa.editor.ColoredScanner;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ColoredContext
extends StyleContext
implements ViewFactory {
    public View create(Element elem) {
        return new ColoredView(elem);
    }

    class ColoredView
    extends PlainView {
        private ColoredScanner lexer;
        private boolean lexerValid;

        ColoredView(Element elem) {
            super(elem);
            ColoredDocument doc = (ColoredDocument)this.getDocument();
            this.lexer = doc.getScanner();
            this.lexerValid = false;
        }

        public void paint(Graphics g, Shape a) {
            super.paint(g, a);
            this.lexerValid = false;
        }

        protected int drawUnselectedText(Graphics g, int x, int y, int beginPos, int endPos) throws BadLocationException {
            Segment text;
            Document document = this.getDocument();
            Color lastForeground = null;
            int markPos = beginPos;
            while (beginPos < endPos) {
                this.updateScanner(beginPos);
                int pos = Math.min(this.lexer.getEndOffset(), endPos);
                pos = pos <= beginPos ? endPos : pos;
                Color foreground = this.lexer.getColor();
                if (foreground != lastForeground && lastForeground != null) {
                    g.setColor(lastForeground);
                    text = this.getLineBuffer();
                    document.getText(markPos, beginPos - markPos, text);
                    x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, markPos);
                    markPos = beginPos;
                }
                lastForeground = foreground;
                beginPos = pos;
            }
            g.setColor(lastForeground);
            text = this.getLineBuffer();
            document.getText(markPos, endPos - markPos, text);
            x = Utilities.drawTabbedText(text, x, y, g, (TabExpander)this, markPos);
            return x;
        }

        void updateScanner(int pos) {
            try {
                if (!this.lexerValid) {
                    ColoredDocument doc = (ColoredDocument)this.getDocument();
                    this.lexer.setRange(doc.getScannerStart(pos), doc.getLength());
                    this.lexerValid = true;
                }
                while (this.lexer.getEndOffset() <= pos) {
                    this.lexer.next();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

