/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.EventState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.BitSet;
import javax.swing.JPanel;

public class DrawMachine {
    public static int MAXDRAWSTATES = 64;
    static final int STATESIZE = 30;
    Font labelFont;
    Font nameFont;
    Font stateFont = new Font("SansSerif", 1, 18);
    protected boolean displayName = false;
    protected boolean newLabelFormat = true;
    protected boolean selectedMachine = false;
    int SEPARATION;
    int ARCINC;
    int topX = 0;
    int topY = 0;
    int zeroX;
    int zeroY;
    int heightAboveCenter;
    int nameWidth = 0;
    Dimension size;
    private int errorState = 0;
    private int lastselected = -3;
    private int selected = 0;
    private String lastaction;
    CompactState mach = null;
    BitSet accepting;
    JPanel parent;
    private int[] arrowX = new int[3];
    private int[] arrowY = new int[3];
    private static int arrowForward = 1;
    private static int arrowBackward = 2;
    private static int arrowDown = 3;
    String[][] labels;

    public DrawMachine(CompactState m, JPanel p, Font fn, Font fl, boolean dn, boolean nl, int separation, int arcIncrement) {
        this.mach = m;
        this.parent = p;
        this.nameFont = fn;
        this.labelFont = fl;
        this.displayName = dn;
        this.newLabelFormat = nl;
        this.SEPARATION = separation;
        this.ARCINC = arcIncrement;
        this.accepting = this.mach.accepting();
        if (this.newLabelFormat) {
            this.initCompactLabels();
        }
        this.size = this.computeDimension(this.mach);
    }

    public void setDrawName(boolean flag) {
        this.displayName = flag;
        this.size = this.computeDimension(this.mach);
    }

    public void setNewLabelFormat(boolean flag) {
        this.newLabelFormat = flag;
        if (this.newLabelFormat) {
            this.initCompactLabels();
        }
        this.size = this.computeDimension(this.mach);
    }

    public void setFonts(Font fn, Font fl) {
        this.nameFont = fn;
        this.labelFont = fl;
        this.size = this.computeDimension(this.mach);
    }

    public void setStretch(boolean absolute, int separation, int arcIncrement) {
        if (absolute) {
            this.SEPARATION = separation;
            this.ARCINC = arcIncrement;
        } else {
            if (this.SEPARATION + separation > 10) {
                this.SEPARATION += separation;
            }
            if (this.ARCINC + arcIncrement > 5) {
                this.ARCINC += arcIncrement;
            }
        }
        this.size = this.computeDimension(this.mach);
    }

    public void select(int last, int current, String name) {
        this.lastselected = last;
        this.selected = current;
        this.lastaction = name;
    }

    public void setPos(int x, int y) {
        this.topX = x;
        this.topY = y;
    }

    public boolean isSelected() {
        return this.selectedMachine;
    }

    public void setSelected(boolean b) {
        this.selectedMachine = b;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void getRect(Rectangle r) {
        r.x = this.topX;
        r.y = this.topY;
        r.width = this.size.width;
        r.height = this.size.height;
    }

    public CompactState getMachine() {
        return this.mach;
    }

    protected Dimension computeDimension(CompactState m) {
        int nameHeight = 0;
        if (this.displayName) {
            Graphics g = this.parent.getGraphics();
            if (g != null) {
                g.setFont(this.nameFont);
                FontMetrics fm = g.getFontMetrics();
                this.nameWidth = fm.stringWidth(this.mach.name);
                nameHeight = fm.getHeight();
            } else {
                this.nameWidth = this.SEPARATION;
            }
        } else {
            this.nameWidth = 0;
        }
        if (m.maxStates > MAXDRAWSTATES) {
            return new Dimension(220 + this.nameWidth, 50);
        }
        String largestEndLabel = null;
        if (!this.newLabelFormat) {
            EventState p = m.states[m.maxStates - 1];
            while (p != null) {
                EventState tr = p;
                while (tr != null) {
                    if (tr.next == m.maxStates - 1) {
                        if (largestEndLabel == null) {
                            largestEndLabel = m.alphabet[tr.event];
                        } else {
                            String s = m.alphabet[tr.event];
                            if (s.length() > largestEndLabel.length()) {
                                largestEndLabel = s;
                            }
                        }
                    }
                    tr = tr.nondet;
                }
                p = p.list;
            }
        } else {
            largestEndLabel = this.labels[m.maxStates][m.maxStates];
        }
        int endWidth = 10;
        if (largestEndLabel != null) {
            Graphics g = this.parent.getGraphics();
            if (g != null) {
                g.setFont(this.labelFont);
                FontMetrics fm = g.getFontMetrics();
                endWidth = fm.stringWidth(largestEndLabel);
                endWidth += this.SEPARATION / 3;
            } else {
                endWidth = this.SEPARATION;
            }
        }
        this.errorState = 0;
        int i = 0;
        while (i < m.maxStates) {
            if (EventState.hasState(m.states[i], -1)) {
                this.errorState = 1;
            }
            ++i;
        }
        int maxFwd = 0;
        int maxFwdLabels = 0;
        int maxBwd = 0;
        int maxBwdLabels = 0;
        int i2 = 0;
        while (i2 < m.maxStates) {
            int[] ntrans = new int[m.maxStates + 1];
            int fwdToState = 0;
            int bwdToState = 0;
            boolean fwd = false;
            boolean bwd = false;
            EventState p = m.states[i2];
            while (p != null) {
                EventState tr = p;
                while (tr != null) {
                    int n = tr.next + 1;
                    ntrans[n] = ntrans[n] + 1;
                    int diff = tr.next - i2;
                    if (diff > maxFwd || diff == maxFwd && ntrans[tr.next + 1] > maxFwdLabels) {
                        maxFwd = diff;
                        fwdToState = tr.next + 1;
                        fwd = true;
                    }
                    if (diff < maxBwd || diff == maxBwd && ntrans[tr.next + 1] > maxBwdLabels) {
                        maxBwd = diff;
                        bwdToState = tr.next + 1;
                        bwd = true;
                    }
                    tr = tr.nondet;
                }
                p = p.list;
            }
            if (fwd) {
                int n = maxFwdLabels = this.newLabelFormat ? 1 : ntrans[fwdToState];
            }
            if (bwd) {
                maxBwdLabels = this.newLabelFormat ? 1 : ntrans[bwdToState];
            }
            ++i2;
        }
        if (m.maxStates == 1) {
            maxFwdLabels = 0;
        }
        int fheight = 10;
        Graphics g = this.parent.getGraphics();
        if (g != null) {
            g.setFont(this.labelFont);
            FontMetrics fm = g.getFontMetrics();
            fheight = fm.getHeight();
        }
        this.heightAboveCenter = maxFwd != 0 ? this.ARCINC * maxFwd / 2 : 15 + nameHeight;
        this.heightAboveCenter = this.heightAboveCenter + maxFwdLabels * fheight + 10;
        int heightBelowCenter = maxBwd != 0 ? this.ARCINC * Math.abs(maxBwd) / 2 : 15;
        heightBelowCenter = heightBelowCenter + maxBwdLabels * fheight + 10;
        int pwidth = this.errorState == 0 ? 10 + this.nameWidth + 30 + endWidth + (m.maxStates - 1) * this.SEPARATION : 40 + endWidth + m.maxStates * this.SEPARATION;
        int pheight = this.heightAboveCenter + heightBelowCenter;
        return new Dimension(pwidth, pheight);
    }

    public void fileDraw(Graphics g) {
        int saveX = this.topX;
        int saveY = this.topY;
        boolean sm = this.selectedMachine;
        this.topX = 0;
        this.topY = 0;
        this.selectedMachine = false;
        this.draw(g);
        this.topX = saveX;
        this.topY = saveY;
        this.selectedMachine = sm;
    }

    public void draw(Graphics g) {
        CompactState m = this.mach;
        if (m == null) {
            return;
        }
        if (this.selectedMachine) {
            g.setColor(Color.white);
            g.fillRect(this.topX, this.topY, this.size.width, this.size.height);
        }
        int aw = 0;
        if (this.displayName && this.errorState == 0) {
            aw = this.nameWidth;
        }
        this.zeroX = this.topX + 10 + this.errorState * this.SEPARATION + aw;
        this.zeroY = this.topY + this.heightAboveCenter - 15;
        if (m.maxStates > MAXDRAWSTATES) {
            g.setColor(Color.black);
            g.setFont(this.nameFont);
            g.drawString(String.valueOf(m.name) + " -- too many states: " + m.maxStates, this.topX, this.topY + 20);
        } else {
            String event;
            EventState tr;
            EventState p;
            int[] ntrans;
            g.setFont(this.nameFont);
            FontMetrics fm = g.getFontMetrics();
            int nw = fm.stringWidth(m.name);
            g.setColor(Color.black);
            if (this.displayName) {
                g.drawString(m.name, this.zeroX - nw, this.zeroY - 5);
            }
            int i = 0;
            while (i < m.maxStates) {
                ntrans = new int[m.maxStates + 1];
                p = m.states[i];
                while (p != null) {
                    tr = p;
                    event = m.alphabet[tr.event];
                    if (event.charAt(0) != '@') {
                        while (tr != null) {
                            int n = tr.next + 1;
                            ntrans[n] = ntrans[n] + 1;
                            this.drawTransition(g, i, tr.next, event, ntrans[tr.next + 1], i == this.lastselected && tr.next == this.selected, false);
                            tr = tr.nondet;
                        }
                    }
                    p = p.list;
                }
                ++i;
            }
            i = 0;
            while (i < m.maxStates) {
                ntrans = new int[m.maxStates + 1];
                p = m.states[i];
                while (p != null) {
                    tr = p;
                    event = m.alphabet[tr.event];
                    if (event.charAt(0) != '@') {
                        while (tr != null) {
                            int n = tr.next + 1;
                            ntrans[n] = ntrans[n] + 1;
                            if (!this.newLabelFormat) {
                                this.drawTransition(g, i, tr.next, event, ntrans[tr.next + 1], i == this.lastselected && tr.next == this.selected, true);
                            } else if (ntrans[tr.next + 1] == 1) {
                                this.drawTransition(g, i, tr.next, this.labels[i + 1][tr.next + 1], ntrans[tr.next + 1], i == this.lastselected && tr.next == this.selected, true);
                            }
                            tr = tr.nondet;
                        }
                    }
                    p = p.list;
                }
                ++i;
            }
            i = -this.errorState;
            while (i < m.maxStates) {
                this.drawState(g, i, i == this.selected);
                ++i;
            }
        }
        if (this.selectedMachine) {
            g.setColor(Color.gray);
            g.drawRect(this.topX, this.topY, this.size.width, this.size.height);
        }
    }

    private void drawState(Graphics g, int id, boolean highlight) {
        int x = this.zeroX + id * this.SEPARATION;
        int y = this.zeroY;
        if (highlight) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.cyan);
        }
        if (id >= 0 && this.accepting.get(id)) {
            g.fillArc(x - 3, y - 3, 36, 36, 0, 360);
        } else {
            g.fillArc(x, y, 30, 30, 0, 360);
        }
        g.setColor(Color.black);
        g.setFont(this.stateFont);
        if (id >= 0 && this.accepting.get(id)) {
            g.drawArc(x - 3, y - 3, 36, 36, 0, 360);
        }
        g.drawArc(x, y, 30, 30, 0, 360);
        FontMetrics fm = g.getFontMetrics();
        String sid = id == this.mach.endseq ? "E" : "" + id;
        int px = x + 15 - fm.stringWidth(sid) / 2;
        int py = y + 15 + fm.getHeight() / 3;
        g.drawString(sid, px, py);
    }

    private void drawTransition(Graphics g, int from, int to, String s, int n, boolean highlight, boolean dotext) {
        int py;
        if (highlight) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        int sign = to <= from ? -1 : 1;
        int start = to < from ? to : from;
        int x = this.zeroX + start * this.SEPARATION + 15;
        int w = to != from ? this.SEPARATION * Math.abs(from - to) : this.SEPARATION / 3;
        int h = to != from ? this.ARCINC * Math.abs(from - to) : 25;
        int y = this.zeroY - (h - 30) / 2;
        if (n == 1 && !dotext) {
            if (from != to) {
                g.drawArc(x, y, w, h, 0, 180 * sign);
                if (sign > 0) {
                    this.drawArrow(g, x + w / 2, y, arrowForward);
                } else {
                    this.drawArrow(g, x + w / 2, y + h - 1, arrowBackward);
                }
            } else {
                g.drawArc(x, y, w, h, 0, 360);
                this.drawArrow(g, x + w, y + h / 2, arrowDown);
            }
        }
        if (!dotext) {
            return;
        }
        ++n;
        g.setFont(this.labelFont);
        FontMetrics fm = g.getFontMetrics();
        int drop = fm.getMaxAscent() / 3;
        int px = x + w / 2 - fm.stringWidth(s) / 2;
        if (to == from) {
            px = x + w + 2;
        }
        int n2 = py = sign > 0 ? y + drop : y + h + drop;
        if (to == from) {
            py = y + h / 2 + drop;
        }
        if (n > 1) {
            py -= (n - 1) * fm.getHeight() * sign;
        }
        g.setColor(Color.white);
        g.fillRect(px, py - fm.getMaxAscent(), fm.stringWidth(s), fm.getHeight());
        if (highlight && (this.lastaction != null && this.lastaction.equals(s) || this.newLabelFormat)) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        g.drawString(s, px, py);
    }

    private void drawArrow(Graphics g, int x, int y, int direction) {
        if (direction == arrowForward) {
            this.arrowX[0] = x - 5;
            this.arrowY[0] = y - 5;
            this.arrowX[1] = x + 5;
            this.arrowY[1] = y;
            this.arrowX[2] = x - 5;
            this.arrowY[2] = y + 5;
        } else if (direction == arrowBackward) {
            this.arrowX[0] = x + 5;
            this.arrowY[0] = y - 5;
            this.arrowX[1] = x - 5;
            this.arrowY[1] = y;
            this.arrowX[2] = x + 5;
            this.arrowY[2] = y + 5;
        } else if (direction == arrowDown) {
            this.arrowX[0] = x - 5;
            this.arrowY[0] = y - 5;
            this.arrowX[1] = x + 5;
            this.arrowY[1] = y - 5;
            this.arrowX[2] = x;
            this.arrowY[2] = y + 5;
        }
        g.fillPolygon(this.arrowX, this.arrowY, 3);
    }

    private void initCompactLabels() {
        if (this.mach == null) {
            return;
        }
        if (this.mach.maxStates > MAXDRAWSTATES) {
            return;
        }
        this.labels = new String[this.mach.maxStates + 1][this.mach.maxStates + 1];
        int i = 0;
        while (i < this.mach.maxStates) {
            EventState current = EventState.transpose(this.mach.states[i]);
            while (current != null) {
                String[] events = EventState.eventsToNextNoAccept(current, this.mach.alphabet);
                Alphabet a = new Alphabet(events);
                this.labels[i + 1][current.next + 1] = a.toString();
                current = current.list;
            }
            ++i;
        }
    }
}

