/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.CompositionExpression;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.LTSCompiler;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ProcessSpec;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Value;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class SeqProcessRef {
    Symbol name;
    Vector actualParams;
    static LTSOutput output;

    SeqProcessRef(Symbol n, Vector params) {
        this.name = n;
        this.actualParams = params;
    }

    CompactState instantiate(Hashtable locals, Hashtable constants) {
        CompositionExpression ce;
        ProcessSpec p;
        Vector actuals = this.paramValues(locals, constants);
        String refname = actuals == null ? this.name.toString() : String.valueOf(this.name.toString()) + StateMachine.paramString(actuals);
        CompactState mach = (CompactState)LTSCompiler.compiled.get(refname);
        if (mach == null && (p = (ProcessSpec)LTSCompiler.processes.get(this.name.toString())) != null) {
            p = p.myclone();
            if (this.actualParams != null && this.actualParams.size() != p.parameters.size()) {
                Diagnostics.fatal("actuals do not match formal parameters", this.name);
            }
            StateMachine one = new StateMachine(p, actuals);
            mach = one.makeCompactState();
            output.outln("-- compiled:" + mach.name);
        }
        if (mach == null && (ce = (CompositionExpression)LTSCompiler.composites.get(this.name.toString())) != null) {
            CompositeState cs = ce.compose(actuals);
            mach = cs.create(output);
        }
        if (mach != null) {
            LTSCompiler.compiled.put(mach.name, mach);
            if (!mach.isSequential()) {
                Diagnostics.fatal("process is not sequential - " + this.name, this.name);
            }
            return mach.myclone();
        }
        Diagnostics.fatal("process definition not found- " + this.name, this.name);
        return null;
    }

    private Vector paramValues(Hashtable locals, Hashtable constants) {
        if (this.actualParams == null) {
            return null;
        }
        Enumeration e = this.actualParams.elements();
        Vector<Value> v = new Vector<Value>();
        while (e.hasMoreElements()) {
            Stack stk = (Stack)e.nextElement();
            v.addElement(Expression.getValue(stk, locals, constants));
        }
        return v;
    }
}

