/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Declaration;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.StateExpr;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Transition;
import java.util.Hashtable;

class StateDefn
extends Declaration {
    Symbol name;
    boolean accept = false;
    ActionLabels range;
    StateExpr stateExpr;

    StateDefn() {
    }

    private void check_put(String s, StateMachine m) {
        if (m.explicit_states.containsKey(s)) {
            Diagnostics.fatal("duplicate definition -" + this.name, this.name);
        } else {
            m.explicit_states.put(s, m.stateLabel.label());
        }
    }

    public void explicitStates(StateMachine m) {
        if (this.range == null) {
            String s = this.name.toString();
            if (s.equals("STOP") || s.equals("ERROR") || s.equals("END")) {
                Diagnostics.fatal("reserved local process name -" + this.name, this.name);
            }
            this.check_put(s, m);
        } else {
            Hashtable locals = new Hashtable();
            this.range.initContext(locals, m.constants);
            while (this.range.hasMoreNames()) {
                this.check_put(String.valueOf(this.name.toString()) + "." + this.range.nextName(), m);
            }
            this.range.clearContext();
        }
    }

    private void crunchAlias(StateExpr st, String n, Hashtable locals, StateMachine m) {
        String s = st.evalName(locals, m);
        Integer i = (Integer)m.explicit_states.get(s);
        if (i == null) {
            if (s.equals("STOP")) {
                i = m.stateLabel.label();
                m.explicit_states.put("STOP", i);
            } else if (s.equals("ERROR")) {
                i = new Integer(-1);
                m.explicit_states.put("ERROR", i);
            } else if (s.equals("END")) {
                i = m.stateLabel.label();
                m.explicit_states.put("END", i);
            } else {
                i = new Integer(-1);
                m.explicit_states.put("ERROR", i);
                Diagnostics.warning(String.valueOf(s) + " defined to be ERROR", "definition not found- " + s, st.name);
            }
        }
        CompactState mach = null;
        if (st.processes != null) {
            mach = st.makeInserts(locals, m);
        }
        if (mach != null) {
            m.preAddSequential((Integer)m.explicit_states.get(n), i, mach);
        } else {
            m.aliases.put(m.explicit_states.get(n), i);
        }
    }

    public void crunch(StateMachine m) {
        if (this.stateExpr.name == null && this.stateExpr.boolexpr == null) {
            return;
        }
        Hashtable locals = new Hashtable();
        if (this.range == null) {
            this.crunchit(m, locals, this.stateExpr, this.name.toString());
        } else {
            this.range.initContext(locals, m.constants);
            while (this.range.hasMoreNames()) {
                String s = this.name + "." + this.range.nextName();
                this.crunchit(m, locals, this.stateExpr, s);
            }
            this.range.clearContext();
        }
    }

    private void crunchit(StateMachine m, Hashtable locals, StateExpr st, String s) {
        if (st.name != null) {
            this.crunchAlias(st, s, locals, m);
        } else if (st.boolexpr != null && (st = Expression.evaluate(st.boolexpr, locals, m.constants) != 0 ? st.thenpart : st.elsepart) != null) {
            this.crunchit(m, locals, st, s);
        }
    }

    public void transition(StateMachine m) {
        if (this.stateExpr.name != null) {
            return;
        }
        Hashtable locals = new Hashtable();
        if (this.range == null) {
            int from = (Integer)m.explicit_states.get("" + this.name);
            this.stateExpr.firstTransition(from, locals, m);
            if (this.accept) {
                if (!m.alphabet.containsKey("@")) {
                    m.alphabet.put("@", m.eventLabel.label());
                }
                Symbol e = new Symbol(124, "@");
                m.transitions.addElement(new Transition(from, e, from));
            }
        } else {
            this.range.initContext(locals, m.constants);
            while (this.range.hasMoreNames()) {
                int from = (Integer)m.explicit_states.get(this.name + "." + this.range.nextName());
                this.stateExpr.firstTransition(from, locals, m);
            }
            this.range.clearContext();
        }
    }

    public StateDefn myclone() {
        StateDefn sd = new StateDefn();
        sd.name = this.name;
        sd.accept = this.accept;
        if (this.range != null) {
            sd.range = this.range.myclone();
        }
        if (this.stateExpr != null) {
            sd.stateExpr = this.stateExpr.myclone();
        }
        return sd;
    }
}

