/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import ic.doc.ltsa.lts.ltl.Proposition;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class LabelFactory {
    SortedSet allprops;
    FormulaFactory fac;
    Vector alphaX;
    String name;
    HashMap tr;
    BitSet[] ps;
    BitSet[] nps;
    Vector propProcs;
    SortedSet allActions;
    private List fluents = new ArrayList();

    public LabelFactory(String n, FormulaFactory f, Vector alphaExtension) {
        this.allprops = f.getProps();
        this.fac = f;
        this.name = n;
        this.alphaX = alphaExtension;
        this.tr = new HashMap();
        this.initPropSets();
        this.compileProps();
    }

    HashMap getTransLabels() {
        return this.tr;
    }

    Vector getPrefix() {
        Vector<String> v = new Vector<String>();
        Formula f = (Formula)this.allprops.first();
        v.add("_" + f);
        return v;
    }

    String makeLabel(SortedSet props) {
        StringBuffer sb = new StringBuffer();
        Iterator ii = this.allprops.iterator();
        boolean isMore = false;
        BitSet labels = new BitSet();
        int m = 0;
        while (ii.hasNext()) {
            Formula f = (Formula)ii.next();
            if (props.contains(f)) {
                if (isMore) {
                    sb.append("&");
                    labels.and(this.ps[m]);
                } else {
                    labels.or(this.ps[m]);
                    isMore = true;
                }
                sb.append(f);
            } else if (props.contains(this.fac.makeNot(f))) {
                if (isMore) {
                    sb.append("&");
                    labels.and(this.nps[m]);
                } else {
                    labels.or(this.nps[m]);
                    isMore = true;
                }
                sb.append("!" + f);
            }
            ++m;
        }
        String s = sb.toString();
        this.tr.put(s, labels);
        return s;
    }

    public String[] makeAlphabet() {
        return this.makeAlphabet(null, null, null);
    }

    private String[] makeAlphabet(PredicateDefinition p, BitSet tt, BitSet ft) {
        int extra = 0;
        extra = p == null ? 1 : p.trueActions.size() + p.falseActions.size();
        int len = (1 << this.allprops.size()) + 1 + extra;
        String[] alpha = new String[len];
        int i = 0;
        while (i < len - extra) {
            StringBuffer sb = new StringBuffer();
            Iterator ii = this.allprops.iterator();
            boolean isMore = false;
            int m = 0;
            while (ii.hasNext()) {
                Formula f = (Formula)ii.next();
                if (isMore) {
                    sb.append(".");
                }
                isMore = true;
                sb.append("_" + f + "." + (i >> m) % 2);
                ++m;
            }
            alpha[i + 1] = sb.toString();
            ++i;
        }
        alpha[0] = "tau";
        if (p == null) {
            alpha[len - 1] = "@" + this.name;
        } else {
            int pos = len - extra;
            Iterator ii = p.falseActions.iterator();
            while (ii.hasNext()) {
                alpha[pos] = (String)ii.next();
                ft.set(pos);
                ++pos;
            }
            ii = p.trueActions.iterator();
            while (ii.hasNext()) {
                alpha[pos] = (String)ii.next();
                tt.set(pos);
                ++pos;
            }
        }
        return alpha;
    }

    void initPropSets() {
        int len = this.allprops.size();
        this.ps = new BitSet[len];
        this.nps = new BitSet[len];
        BitSet trueSet = new BitSet(1 << len);
        int m = 0;
        while (m < len) {
            this.ps[m] = new BitSet(1 << len);
            this.nps[m] = new BitSet(1 << len);
            ++m;
        }
        int i = 0;
        while (i < 1 << len) {
            trueSet.set(i);
            int m2 = 0;
            while (m2 < len) {
                if ((i >> m2) % 2 == 1) {
                    this.ps[m2].set(i);
                } else {
                    this.nps[m2].set(i);
                }
                ++m2;
            }
            ++i;
        }
        this.tr.put("true", trueSet);
    }

    public PredicateDefinition[] getFluents() {
        if (this.fluents.size() == 0) {
            return null;
        }
        PredicateDefinition[] pds = new PredicateDefinition[this.fluents.size()];
        int i = 0;
        while (i < pds.length) {
            pds[i] = (PredicateDefinition)this.fluents.get(i);
            ++i;
        }
        return pds;
    }

    protected void compileProps() {
        PredicateDefinition p;
        Proposition f;
        this.propProcs = new Vector();
        this.allActions = new TreeSet();
        Iterator ii = this.allprops.iterator();
        int m = 0;
        while (ii.hasNext()) {
            f = (Proposition)ii.next();
            p = PredicateDefinition.get(f.toString());
            if (p != null) {
                this.fluents.add(p);
                this.allActions.addAll(p.trueActions);
                this.allActions.addAll(p.falseActions);
                this.propProcs.add(this.makePropProcess(p, m));
            } else if (this.fac.actionPredicates != null && this.fac.actionPredicates.containsKey(f.toString())) {
                Vector vl = (Vector)this.fac.actionPredicates.get(f.toString());
                this.allActions.addAll(vl);
            } else {
                Diagnostics.fatal("Proposition " + f + " not found", f.sym);
            }
            ++m;
        }
        if (this.alphaX != null) {
            this.allActions.addAll(this.alphaX);
        }
        ii = this.allprops.iterator();
        m = 0;
        while (ii.hasNext()) {
            f = (Proposition)ii.next();
            p = PredicateDefinition.get(f.toString());
            if (p == null) {
                if (this.fac.actionPredicates != null && this.fac.actionPredicates.containsKey(f.toString())) {
                    Vector trueActions = (Vector)this.fac.actionPredicates.get(f.toString());
                    Vector falseActions = new Vector();
                    falseActions.addAll(this.allActions);
                    falseActions.removeAll(trueActions);
                    p = new PredicateDefinition(new Symbol(123, f.toString()), trueActions, falseActions);
                    CompactState cs = this.makePropProcess(p, m);
                    this.propProcs.add(cs);
                } else {
                    Diagnostics.fatal("Proposition " + f + " not found", f.sym);
                }
            }
            ++m;
        }
        this.propProcs.add(this.makeSyncProcess());
    }

    CompactState makePropProcess(PredicateDefinition p, int m) {
        CompactState cs = new CompactState();
        cs.name = p.name.toString();
        cs.maxStates = 2;
        cs.states = new EventState[cs.maxStates];
        BitSet trueTrans = new BitSet();
        BitSet falseTrans = new BitSet();
        cs.alphabet = this.makeAlphabet(p, trueTrans, falseTrans);
        int falseS = p.initial ? 1 : 0;
        int trueS = p.initial ? 0 : 1;
        int i = 0;
        while (i < trueTrans.size()) {
            if (trueTrans.get(i)) {
                cs.states[falseS] = EventState.add(cs.states[falseS], new EventState(i, trueS));
            }
            ++i;
        }
        i = 0;
        while (i < falseTrans.size()) {
            if (falseTrans.get(i)) {
                cs.states[trueS] = EventState.add(cs.states[trueS], new EventState(i, falseS));
            }
            ++i;
        }
        i = 0;
        while (i < falseTrans.size()) {
            if (falseTrans.get(i)) {
                cs.states[falseS] = EventState.add(cs.states[falseS], new EventState(i, falseS));
            }
            ++i;
        }
        i = 0;
        while (i < trueTrans.size()) {
            if (trueTrans.get(i)) {
                cs.states[trueS] = EventState.add(cs.states[trueS], new EventState(i, trueS));
            }
            ++i;
        }
        i = 0;
        while (i < this.nps[m].size()) {
            if (this.nps[m].get(i)) {
                cs.states[falseS] = EventState.add(cs.states[falseS], new EventState(i + 1, falseS));
            }
            ++i;
        }
        i = 0;
        while (i < this.ps[m].size()) {
            if (this.ps[m].get(i)) {
                cs.states[trueS] = EventState.add(cs.states[trueS], new EventState(i + 1, trueS));
            }
            ++i;
        }
        return cs;
    }

    CompactState makeSyncProcess() {
        CompactState cs = new CompactState();
        cs.name = "SYNC";
        cs.maxStates = 2;
        cs.states = new EventState[cs.maxStates];
        String[] propA = this.makeAlphabet();
        String[] appA = new String[this.allActions.size()];
        int ind = 0;
        Iterator ii = this.allActions.iterator();
        while (ii.hasNext()) {
            appA[ind++] = (String)ii.next();
        }
        cs.alphabet = new String[propA.length - 1 + appA.length];
        cs.alphabet[0] = "tau";
        int i = 1;
        while (i < propA.length - 1) {
            cs.alphabet[i] = propA[i];
            cs.states[1] = EventState.add(cs.states[1], new EventState(i, 0));
            ++i;
        }
        i = 0;
        while (i < appA.length) {
            cs.alphabet[i + propA.length - 1] = appA[i];
            cs.states[0] = EventState.add(cs.states[0], new EventState(i + propA.length - 1, 1));
            ++i;
        }
        return cs;
    }
}

