/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Edge;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.LabelFactory;
import ic.doc.ltsa.lts.ltl.Node;
import java.util.BitSet;
import java.util.SortedSet;

class Transition {
    SortedSet propositions;
    int pointsTo;
    BitSet accepting;
    boolean safe_acc;
    static LabelFactory lf;

    static void setLabelFactory(LabelFactory f) {
        lf = f;
    }

    Transition(SortedSet p, int i, BitSet acc, boolean sa) {
        this.propositions = p;
        this.pointsTo = i;
        this.accepting = new BitSet();
        this.accepting.or(acc);
        this.safe_acc = sa;
    }

    int goesTo() {
        return this.pointsTo;
    }

    BitSet computeAccepting(int nacc) {
        BitSet b = new BitSet(nacc);
        int i = 0;
        while (i < nacc) {
            if (!this.accepting.get(i)) {
                b.set(i);
            }
            ++i;
        }
        return b;
    }

    void print(LTSOutput out, int nacc) {
        if (this.propositions.isEmpty()) {
            out.out("LABEL True");
        } else {
            Node.printFormulaSet(out, "LABEL", this.propositions);
        }
        out.out(" T0 " + this.goesTo());
        if (nacc > 0) {
            out.outln(" Acc " + this.computeAccepting(nacc));
        } else if (this.safe_acc) {
            out.outln(" Acc {0}");
        } else {
            out.outln("");
        }
    }

    void Gmake(gov.nasa.arc.ase.util.graph.Node[] anode, gov.nasa.arc.ase.util.graph.Node node, int nacc) {
        String s = "-";
        String s1 = "-";
        if (!this.propositions.isEmpty()) {
            s = lf.makeLabel(this.propositions);
        }
        Edge edge = new Edge(node, anode[this.pointsTo], s, s1);
        if (nacc == 0) {
            edge.setBooleanAttribute("acc0", true);
        } else {
            int i = 0;
            while (i < nacc) {
                if (!this.accepting.get(i)) {
                    edge.setBooleanAttribute("acc" + i, true);
                }
                ++i;
            }
        }
    }
}

