/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import ltsaeclipse.views.ExampleTask;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ExampleTaskSorter
extends ViewerSorter {
    public static final int DESCRIPTION = 1;
    public static final int OWNER = 2;
    public static final int PERCENT_COMPLETE = 3;
    private int criteria;

    public ExampleTaskSorter(int criteria) {
        this.criteria = criteria;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        ExampleTask task1 = (ExampleTask)o1;
        ExampleTask task2 = (ExampleTask)o2;
        switch (this.criteria) {
            case 1: {
                return this.compareDescriptions(task1, task2);
            }
            case 2: {
                return this.compareOwners(task1, task2);
            }
            case 3: {
                return this.comparePercentComplete(task1, task2);
            }
        }
        return 0;
    }

    private int comparePercentComplete(ExampleTask task1, ExampleTask task2) {
        int result = task1.getPercentComplete() - task2.getPercentComplete();
        result = result < 0 ? -1 : (result > 0 ? 1 : 0);
        return result;
    }

    protected int compareDescriptions(ExampleTask task1, ExampleTask task2) {
        return this.collator.compare(task1.getDescription(), task2.getDescription());
    }

    protected int compareOwners(ExampleTask task1, ExampleTask task2) {
        return this.collator.compare(task1.getOwner(), task2.getOwner());
    }

    public int getCriteria() {
        return this.criteria;
    }
}

