/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Area;
import mscedit.Glyph;

class TransitionGraphic
extends Glyph {
    private String o_from;
    private String o_to;

    public TransitionGraphic(String p_from, String p_to, Point p_start, Point p_end) {
        this.o_from = p_from;
        this.o_to = p_to;
        this.o_area = this.makeArrow(p_start.x, p_start.y, p_end.x, p_end.y);
        this.scale();
    }

    public String getTo() {
        return this.o_to;
    }

    public String getFrom() {
        return this.o_from;
    }

    public void draw(Graphics g) {
        ((Graphics2D)g).draw(this.o_area);
    }

    private int sign(float x) {
        if (x > 0.0f) {
            return 1;
        }
        if (x < 0.0f) {
            return -1;
        }
        return 0;
    }

    private Area makeArrow(float x1, float y1, float x2, float y2) {
        float dy = y2 - y1;
        float dx = x2 - x1;
        Area x_poly = new Area();
        if (x1 == x2 && y1 == y2) {
            x_poly.add(new Area(new Polygon(new int[]{(int)x1 + 40, (int)x1 + 80, (int)x1 + 80, (int)x1, (int)x1, (int)x1 - 1, (int)x1 - 1, (int)x1 + 80 + 1, (int)x1 + 80 + 1, (int)x1 + 40}, new int[]{(int)y1, (int)y1, (int)y1 - 40, (int)y1 - 40, (int)y1 - 20, (int)y1 - 20, (int)y1 - 40 - 1, (int)y1 - 40 - 1, (int)y1 + 1, (int)y1 + 1}, 10)));
            x_poly.add(new Area(new Polygon(new int[]{(int)((double)x1 - 6.0 * Math.sin(0.5235987755982988)), (int)x1, (int)((double)x1 + 6.0 * Math.sin(0.5235987755982988))}, new int[]{(int)((double)(y1 - 20.0f) - 6.0 * Math.cos(0.5235987755982988)), (int)(y1 - 20.0f), (int)((double)(y1 - 20.0f) - 6.0 * Math.cos(0.5235987755982988))}, 3)));
        } else if (x1 == x2) {
            x_poly.add(new Area(new Polygon(new int[]{(int)x1, (int)x1, (int)x1 + 1, (int)x1 + 1}, new int[]{(int)(y1 + (float)(this.sign(dy) * 20)), (int)(y2 - (float)(this.sign(dy) * 20)), (int)(y2 - (float)(this.sign(dy) * 20)), (int)(y1 + (float)(this.sign(dy) * 20))}, 4)));
            x_poly.add(new Area(new Polygon(new int[]{(int)((double)x1 - 6.0 * Math.sin(0.5235987755982988)), (int)x1, (int)((double)x1 + 6.0 * Math.sin(0.5235987755982988))}, new int[]{(int)((double)y2 - (double)this.sign(dy) * (20.0 + 6.0 * Math.cos(0.5235987755982988))), (int)(y2 - (float)(this.sign(dy) * 20)), (int)((double)y2 - (double)this.sign(dy) * (20.0 + 6.0 * Math.cos(0.5235987755982988)))}, 3)));
        } else if (y1 == y2) {
            x_poly.add(new Area(new Polygon(new int[]{(int)(x1 + (float)(this.sign(dx) * 40)), (int)(x2 - (float)(this.sign(dx) * 40)), (int)(x2 - (float)(this.sign(dx) * 40)), (int)(x1 + (float)(this.sign(dx) * 40))}, new int[]{(int)y1, (int)y2, (int)y2 + 1, (int)y1 + 1}, 4)));
            x_poly.add(new Area(new Polygon(new int[]{(int)((double)x2 - (double)this.sign(dx) * (40.0 + 6.0 * Math.cos(0.5235987755982988))), (int)(x2 - (float)(this.sign(dx) * 40)), (int)((double)x2 - (double)this.sign(dx) * (40.0 + 6.0 * Math.cos(0.5235987755982988)))}, new int[]{(int)((double)y2 - 6.0 * Math.sin(0.5235987755982988)), (int)y2, (int)((double)y2 + 6.0 * Math.sin(0.5235987755982988))}, 3)));
        } else {
            float bx = x2 - (float)(40 * this.sign(dx));
            float by = (bx - x1) / dx * dy + y1;
            float cx = x1 + (float)(40 * this.sign(dx));
            float cy = y2 - (bx - x1) / dx * dy;
            if (Math.abs(y2 - by) > 20.0f) {
                by = y2 - (float)(20 * this.sign(dy));
                bx = (by - y1) / dy * dx + x1;
                cy = y1 + (float)(20 * this.sign(dy));
                cx = x2 - (by - y1) / dy * dx;
            }
            double theta = Math.atan(dy / dx);
            double s = 6.0 * Math.cos(theta + 0.5235987755982988);
            double t = 6.0 * Math.sin(theta + 0.5235987755982988);
            double u = 6.0 * Math.cos(theta - 0.5235987755982988);
            double v = 6.0 * Math.sin(theta - 0.5235987755982988);
            x_poly.add(new Area(new Polygon(new int[]{(int)cx, (int)bx, (int)bx, (int)cx}, new int[]{(int)cy, (int)by, (int)by + 1, (int)cy + 1}, 4)));
            x_poly.add(new Area(new Polygon(new int[]{(int)((double)bx - s * (double)this.sign(dx)), (int)bx, (int)((double)bx - u * (double)this.sign(dx))}, new int[]{(int)((double)by - t * (double)this.sign(dy)), (int)by, (int)((double)by - v * (double)this.sign(dy))}, 3)));
        }
        return x_poly;
    }
}

