/*
 * Decompiled with CFR 0.152.
 */
package synthesis;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import synthesis.Production;

public class AltProduction {
    public String first;
    public Set alternatives;

    public AltProduction(String f) {
        this.first = f;
        this.alternatives = new HashSet();
    }

    public void addAlternative(Production p) {
        this.alternatives.add(p);
    }

    public Set getAlternatives() {
        return this.alternatives;
    }

    public boolean removeDuplicateAlternatives() {
        Iterator A = this.alternatives.iterator();
        boolean retVal = false;
        HashSet<Production> newAlt = new HashSet<Production>();
        while (A.hasNext()) {
            Production P = (Production)A.next();
            Iterator B = newAlt.iterator();
            boolean found = false;
            while (B.hasNext() && !found) {
                Production Q = (Production)B.next();
                found = P.sameRightSide(Q);
            }
            if (!found) {
                newAlt.add(P);
                continue;
            }
            retVal = true;
        }
        this.alternatives = newAlt;
        return retVal;
    }

    public boolean equivalentTo(AltProduction p) {
        Iterator I = this.alternatives.iterator();
        Iterator J = p.alternatives.iterator();
        boolean retVal = true;
        while (I.hasNext() && retVal) {
            retVal = p.hasEquivalentAlternative((Production)I.next());
        }
        while (J.hasNext() && retVal) {
            retVal = this.hasEquivalentAlternative((Production)J.next());
        }
        return retVal;
    }

    private boolean hasEquivalentAlternative(Production P) {
        Iterator I = this.alternatives.iterator();
        boolean found = false;
        while (I.hasNext() && !found) {
            found = ((Production)I.next()).sameRightSide(P);
        }
        return found;
    }
}

