/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.eclipse.fsp;

import ic.doc.ltsa.eclipse.fsp.IFSPSyntax;
import ic.doc.ltsa.eclipse.utils.FSPColorProvider;
import ic.doc.ltsa.eclipse.utils.FSPWhiteSpaceDetector;
import ic.doc.ltsa.eclipse.utils.FSPWordDetector;
import java.util.ArrayList;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.ltsaeclipsePlugin;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class FSPCodeScanner
extends RuleBasedScanner
implements IFSPSyntax {
    private MultiPageEditor mpe;

    public FSPCodeScanner(MultiPageEditor mpe) {
        FSPColorProvider provider = ltsaeclipsePlugin.getDefault().getFSPColorProvider();
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(FSPColorProvider.KEYWORD), provider.getColor(FSPColorProvider.BACKGROUND), 1));
        Token type = new Token((Object)new TextAttribute(provider.getColor(FSPColorProvider.TYPE), provider.getColor(FSPColorProvider.BACKGROUND), 1));
        Token string = new Token((Object)new TextAttribute(provider.getColor(FSPColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(FSPColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(FSPColorProvider.DEFAULT)));
        this.setDefaultReturnToken((IToken)other);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new FSPWhiteSpaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new FSPWordDetector(mpe), (IToken)other);
        int i = 0;
        while (i < IFSPSyntax.reservedwords.length) {
            wordRule.addWord(IFSPSyntax.reservedwords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < IFSPSyntax.types.length) {
            wordRule.addWord(IFSPSyntax.types[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < IFSPSyntax.constants.length) {
            wordRule.addWord(IFSPSyntax.constants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

