/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;
import java.util.Enumeration;
import java.util.Vector;

public class CounterExample {
    protected CompositeState mach;
    protected Vector errorTrace = null;

    public CounterExample(CompositeState m) {
        this.mach = m;
    }

    public void print(LTSOutput output, boolean checkDeadlocks) {
        EventState trace = new EventState(0, 0);
        int result = EventState.search(trace, this.mach.composition.states, 0, -1, this.mach.composition.endseq, checkDeadlocks);
        this.errorTrace = null;
        switch (result) {
            case 1: {
                output.outln("No deadlocks/errors");
                break;
            }
            case 0: {
                output.outln("Trace to DEADLOCK:");
                this.errorTrace = EventState.getPath(trace.path, this.mach.composition.alphabet);
                this.printPath(output, this.errorTrace);
                break;
            }
            case -1: {
                this.errorTrace = EventState.getPath(trace.path, this.mach.composition.alphabet);
                String name = this.findComponent(this.errorTrace);
                output.outln("Trace to property violation in " + name + ":");
                this.printPath(output, this.errorTrace);
            }
        }
    }

    private void printPath(LTSOutput output, Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            output.outln("\t" + (String)e.nextElement());
        }
    }

    private String findComponent(Vector trace) {
        Enumeration e = this.mach.machines.elements();
        while (e.hasMoreElements()) {
            CompactState cs = (CompactState)e.nextElement();
            if (!cs.isErrorTrace(trace)) continue;
            return cs.name;
        }
        return "?";
    }

    public Vector getErrorTrace() {
        return this.errorTrace;
    }
}

