/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.DrawMachine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class LTSCanvas
extends JPanel
implements Scrollable {
    public static boolean fontFlag = false;
    public static boolean displayName = false;
    public static boolean newLabelFormat = true;
    Dimension initial = new Dimension(10, 10);
    Font nameFont;
    Font labelFont;
    static final int SEPARATION = 80;
    static final int ARCINC = 30;
    protected boolean singleMode = false;
    DrawMachine[] drawing;
    DrawMachine focus;
    protected MouseInputListener mouse;
    private Rectangle rr = new Rectangle();
    private int maxUnitIncrement = 1;

    public LTSCanvas(boolean mode) {
        this.setBigFont(fontFlag);
        this.setBackground(Color.white);
        this.singleMode = mode;
        if (!this.singleMode) {
            this.mouse = new MyMouse();
            this.addMouseListener(this.mouse);
            this.addMouseMotionListener(this.mouse);
        }
    }

    public void setMode(boolean mode) {
        if (mode == this.singleMode) {
            return;
        }
        this.focus = null;
        if (this.drawing != null) {
            int len = this.drawing.length;
            this.drawing = new DrawMachine[len];
        }
        this.singleMode = mode;
        if (!this.singleMode) {
            this.mouse = new MyMouse();
            this.addMouseListener(this.mouse);
            this.addMouseMotionListener(this.mouse);
        } else if (this.mouse != null) {
            this.removeMouseListener(this.mouse);
            this.removeMouseMotionListener(this.mouse);
            this.mouse = null;
        }
        this.setPreferredSize(this.initial);
        this.revalidate();
        this.repaint();
    }

    public void setBigFont(boolean flag) {
        if (flag) {
            this.labelFont = new Font("Serif", 1, 14);
            this.nameFont = new Font("SansSerif", 1, 18);
        } else {
            this.labelFont = new Font("Serif", 0, 12);
            this.nameFont = new Font("SansSerif", 1, 14);
        }
        if (this.drawing != null) {
            int i = 0;
            while (i < this.drawing.length) {
                if (this.drawing[i] != null) {
                    this.drawing[i].setFonts(this.nameFont, this.labelFont);
                }
                ++i;
            }
        }
        this.repaint();
    }

    public void setDrawName(boolean flag) {
        displayName = flag;
        if (this.drawing != null) {
            int i = 0;
            while (i < this.drawing.length) {
                if (this.drawing[i] != null) {
                    this.drawing[i].setDrawName(displayName);
                }
                ++i;
            }
        }
        this.repaint();
    }

    public void setNewLabelFormat(boolean flag) {
        newLabelFormat = flag;
        if (this.drawing != null) {
            int i = 0;
            while (i < this.drawing.length) {
                if (this.drawing[i] != null) {
                    this.drawing[i].setNewLabelFormat(newLabelFormat);
                }
                ++i;
            }
        }
        this.repaint();
    }

    public void setMachines(int n) {
        this.focus = null;
        this.drawing = n > 0 ? new DrawMachine[n] : null;
        this.setPreferredSize(this.initial);
        this.revalidate();
        this.repaint();
    }

    public void draw(int id, CompactState m, int last, int current, String name) {
        if (m == null || id >= this.drawing.length) {
            this.drawing = null;
            this.repaint();
            return;
        }
        if (this.drawing[id] == null) {
            this.drawing[id] = new DrawMachine(m, this, this.nameFont, this.labelFont, displayName, newLabelFormat, 80, 30);
        }
        if (this.singleMode) {
            this.focus = this.drawing[id];
        }
        this.drawing[id].select(last, current, name);
        Dimension d = this.drawing[id].getSize();
        Dimension e = this.getPreferredSize();
        this.setPreferredSize(new Dimension(Math.max(e.width, d.width), Math.max(e.height, d.height)));
        this.revalidate();
        this.repaint();
    }

    public void clear(int id) {
        this.drawing[id] = null;
        this.repaint();
    }

    public int clearSelected() {
        if (this.focus == null || this.singleMode || this.drawing == null) {
            return -1;
        }
        int ret = 0;
        while (this.drawing[ret] != this.focus) {
            ++ret;
        }
        this.focus = null;
        this.drawing[ret] = null;
        this.repaint();
        return ret;
    }

    public void stretchHorizontal(int d) {
        if (this.focus != null) {
            this.focus.setStretch(false, d, 0);
            this.focus.getRect(this.rr);
            Dimension p = this.getPreferredSize();
            this.setPreferredSize(new Dimension(Math.max(p.width, this.rr.x + this.rr.width), Math.max(p.height, this.rr.y + this.rr.height)));
            this.revalidate();
            this.repaint();
        }
    }

    public void stretchVertical(int d) {
        if (this.focus != null) {
            this.focus.setStretch(false, 0, d);
            this.focus.getRect(this.rr);
            Dimension p = this.getPreferredSize();
            this.setPreferredSize(new Dimension(Math.max(p.width, this.rr.x + this.rr.width), Math.max(p.height, this.rr.y + this.rr.height)));
            this.revalidate();
            this.repaint();
        }
    }

    public void select(int n, int[] last, int[] current, String name) {
        if (this.drawing == null) {
            return;
        }
        int i = 0;
        while (i < n) {
            if (this.drawing[i] != null) {
                int ls = last != null ? last[i] : 0;
                int cs = current != null ? current[i] : 0;
                this.drawing[i].select(ls, cs, name);
            }
            ++i;
        }
        this.repaint();
    }

    public DrawMachine getDrawing() {
        return this.focus;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        if (this.drawing != null && !this.singleMode) {
            int i = 0;
            while (i < this.drawing.length) {
                if (this.drawing[i] != null && (this.drawing[i] != this.focus || this.focus == null)) {
                    this.drawing[i].draw(g);
                }
                ++i;
            }
        }
        if (this.focus != null) {
            this.focus.draw(g);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.maxUnitIncrement;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - 80;
        }
        return visibleRect.height - 30;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    class MyMouse
    extends MouseInputAdapter {
        Point start = null;
        Rectangle r = new Rectangle();

        MyMouse() {
        }

        public void mousePressed(MouseEvent e) {
            if (LTSCanvas.this.drawing != null) {
                if (LTSCanvas.this.focus != null) {
                    LTSCanvas.this.focus.setSelected(false);
                    LTSCanvas.this.focus = null;
                    LTSCanvas.this.repaint();
                }
                int i = 0;
                while (i < LTSCanvas.this.drawing.length) {
                    if (LTSCanvas.this.drawing[i] != null) {
                        LTSCanvas.this.drawing[i].getRect(this.r);
                        if (this.r.contains(e.getPoint())) {
                            LTSCanvas.this.focus = LTSCanvas.this.drawing[i];
                            LTSCanvas.this.focus.setSelected(true);
                            this.start = e.getPoint();
                            LTSCanvas.this.repaint();
                            return;
                        }
                    }
                    ++i;
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (LTSCanvas.this.focus != null) {
                LTSCanvas.this.focus.getRect(this.r);
                Point current = e.getPoint();
                if (this.start != null) {
                    double xoff = current.getX() - this.start.getX();
                    int newX = (int)((double)this.r.x + xoff);
                    double yoff = current.getY() - this.start.getY();
                    int newY = (int)((double)this.r.y + yoff);
                    LTSCanvas.this.focus.setPos(newX > 0 ? newX : 0, newY > 0 ? newY : 0);
                    this.start = current;
                    LTSCanvas.this.repaint();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.start = null;
            if (LTSCanvas.this.focus != null) {
                LTSCanvas.this.focus.getRect(this.r);
                if (!this.r.contains(e.getPoint())) {
                    LTSCanvas.this.focus.setSelected(false);
                    LTSCanvas.this.focus = null;
                    LTSCanvas.this.repaint();
                } else {
                    Dimension p = LTSCanvas.this.getPreferredSize();
                    LTSCanvas.this.setPreferredSize(new Dimension(Math.max(p.width, this.r.x + this.r.width), Math.max(p.height, this.r.y + this.r.height)));
                    LTSCanvas.this.revalidate();
                }
            }
        }
    }
}

