/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.MyHashStackEntry;
import ic.doc.ltsa.lts.StackCheck;
import ic.doc.ltsa.lts.StateCodec;

public class MyHashStack
implements StackCheck {
    private MyHashStackEntry[] table;
    private int count = 0;
    private int depth = 0;
    private MyHashStackEntry head = null;

    public MyHashStack(int size) {
        this.table = new MyHashStackEntry[size];
    }

    public void pushPut(byte[] key) {
        MyHashStackEntry entry = new MyHashStackEntry(key);
        int hash = StateCodec.hash(key) % this.table.length;
        entry.next = this.table[hash];
        this.table[hash] = entry;
        ++this.count;
        entry.link = this.head;
        this.head = entry;
        ++this.depth;
    }

    public void pop() {
        if (this.head == null) {
            return;
        }
        this.head.marked = false;
        this.head = this.head.link;
        --this.depth;
    }

    public byte[] peek() {
        return this.head.key;
    }

    public void mark(int id) {
        this.head.marked = true;
        this.head.stateNumber = id;
    }

    public boolean marked() {
        return this.head.marked;
    }

    public boolean empty() {
        return this.head == null;
    }

    public boolean containsKey(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashStackEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean onStack(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashStackEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return entry.marked;
            }
            entry = entry.next;
        }
        return false;
    }

    public int get(byte[] key) {
        int hash = StateCodec.hash(key) % this.table.length;
        MyHashStackEntry entry = this.table[hash];
        while (entry != null) {
            if (StateCodec.equals(entry.key, key)) {
                return entry.stateNumber;
            }
            entry = entry.next;
        }
        return -99999;
    }

    public int size() {
        return this.count;
    }

    public int getDepth() {
        return this.depth;
    }
}

