/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import java.util.Vector;

class PrefixTree {
    String name;
    int value;
    boolean isInt = false;
    PrefixTree subname = null;
    PrefixTree list = null;
    boolean lastprefix = false;

    PrefixTree(String n) {
        this.name = n;
        this.checkInt();
    }

    static PrefixTree addName(PrefixTree pt, String s) {
        if (pt == null) {
            pt = new PrefixTree(PrefixTree.prefix(s, 0));
        }
        pt.add(s, 0);
        return pt;
    }

    private void add(String s, int level) {
        String ps = PrefixTree.prefix(s, level);
        if (ps == null) {
            return;
        }
        if (ps.equals(this.name) && !this.lastprefix) {
            String pps = PrefixTree.prefix(s, level + 1);
            if (pps == null) {
                this.lastprefix = true;
                return;
            }
            if (this.subname == null) {
                this.subname = new PrefixTree(pps);
            }
            this.subname.add(s, level + 1);
        } else {
            if (this.list == null) {
                this.list = new PrefixTree(ps);
            }
            this.list.add(s, level);
        }
    }

    public static boolean equals(PrefixTree one, PrefixTree two) {
        if (one == two) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (!one.name.equals(two.name)) {
            return false;
        }
        return PrefixTree.equals(one.subname, two.subname) && PrefixTree.equals(one.list, two.list);
    }

    PrefixTree[] getSubLists() {
        Vector<PrefixTree> subs = new Vector<PrefixTree>();
        PrefixTree pt = this;
        PrefixTree ptt = this.list;
        subs.addElement(pt);
        while (ptt != null) {
            if (!PrefixTree.equals(pt.subname, ptt.subname) || pt.isInt != ptt.isInt) {
                subs.addElement(ptt);
                pt = ptt;
            }
            ptt = ptt.list;
        }
        subs.addElement(null);
        Object[] sl = new PrefixTree[subs.size()];
        subs.copyInto(sl);
        return sl;
    }

    void checkInt() {
        try {
            this.value = Integer.parseInt(this.name);
            this.isInt = true;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    static String prefix(String s, int level) {
        int start = 0;
        int i = 0;
        while (i < level) {
            if ((start = s.indexOf(46, start)) < 0) {
                return null;
            }
            ++start;
            ++i;
        }
        int finish = s.indexOf(46, start);
        if (finish < 0) {
            return s.substring(start);
        }
        return s.substring(start, finish);
    }

    public void getStrings(Vector v, int level, String prefix) {
        PrefixTree pt = this;
        while (pt != null) {
            String pre = prefix == null ? pt.item() : String.valueOf(prefix) + PrefixTree.dotted(pt.item());
            if (pt.subname == null) {
                v.addElement(pre);
            } else if (level > 0) {
                pt.subname.getStrings(v, level - 1, pre);
            } else {
                v.addElement(String.valueOf(pre) + PrefixTree.dotted(pt.subname.toString()));
            }
            pt = pt.list;
        }
    }

    public int maxDepth() {
        PrefixTree pt = this;
        int max = 0;
        while (pt != null) {
            max = pt.subname == null ? Math.max(max, 1) : Math.max(1 + pt.subname.maxDepth(), max);
            pt = pt.list;
        }
        return max;
    }

    public String toString() {
        PrefixTree[] subs = this.getSubLists();
        String s = subs.length > 2 ? "{" : "";
        int i = 0;
        while (i < subs.length - 1) {
            s = i < subs.length - 2 ? String.valueOf(s) + PrefixTree.listString(subs[i], subs[i + 1]) + ", " : String.valueOf(s) + PrefixTree.listString(subs[i], subs[i + 1]);
            ++i;
        }
        if (subs.length > 2) {
            return String.valueOf(s) + "}";
        }
        return s;
    }

    static String listString(PrefixTree start, PrefixTree end) {
        String s;
        if (start.list == end) {
            s = start.item();
        } else if (PrefixTree.intRange(start, end)) {
            s = PrefixTree.rangeString(start, end);
        } else {
            s = "{" + start.item();
            PrefixTree pt = start.list;
            while (pt != end) {
                s = String.valueOf(s) + ", " + pt.item();
                pt = pt.list;
            }
            s = String.valueOf(s) + "}";
        }
        if (start.subname != null) {
            return String.valueOf(s) + PrefixTree.dotted(start.subname.toString());
        }
        return s;
    }

    private static String dotted(String suffix) {
        if (suffix.charAt(0) == '[') {
            return suffix;
        }
        return "." + suffix;
    }

    String item() {
        if (this.isInt) {
            return "[" + this.name + "]";
        }
        return this.name;
    }

    static boolean intRange(PrefixTree start, PrefixTree end) {
        PrefixTree pt = start;
        while (pt != end) {
            if (!pt.isInt) {
                return false;
            }
            pt = pt.list;
        }
        return true;
    }

    static String rangeString(PrefixTree start, PrefixTree end) {
        PrefixTree pt = start;
        int n = 0;
        while (pt != end) {
            pt = pt.list;
            ++n;
        }
        int[] a = new int[n];
        pt = start;
        int i = 0;
        while (i < a.length) {
            a[i] = pt.value;
            pt = pt.list;
            ++i;
        }
        PrefixTree.sort(a);
        if (PrefixTree.isOneRange(a)) {
            return "[" + a[0] + ".." + a[a.length - 1] + "]";
        }
        int j = 0;
        String s = "{";
        while (j < a.length) {
            int i2 = j;
            while (i2 < a.length - 1 && a[i2 + 1] - a[i2] == 1) {
                ++i2;
            }
            s = i2 == j ? String.valueOf(s) + "[" + a[j] + "]" : String.valueOf(s) + "[" + a[j] + ".." + a[i2] + "]";
            j = i2 + 1;
            if (j >= a.length) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + "}";
        return s;
    }

    private static boolean isOneRange(int[] a) {
        int i = 0;
        while (i < a.length - 1) {
            if (a[i + 1] - a[i] != 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void sort(int[] a) {
        int i = 0;
        while (i < a.length - 1) {
            int min = i;
            int j = i + 1;
            while (j < a.length) {
                if (a[j] < a[min]) {
                    min = j;
                }
                ++j;
            }
            int temp = a[i];
            a[i] = a[min];
            a[min] = temp;
            ++i;
        }
    }
}

