/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Degeneralize;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.SCCReduction;
import gov.nasa.arc.ase.util.graph.SFSReduction;
import gov.nasa.arc.ase.util.graph.Simplify;
import gov.nasa.arc.ase.util.graph.SuperSetReduction;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.Minimiser;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.Converter;
import ic.doc.ltsa.lts.ltl.FluentTrace;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.FormulaSyntax;
import ic.doc.ltsa.lts.ltl.GeneralizedBuchiAutomata;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AssertDefinition {
    Symbol name;
    FormulaFactory fac;
    FormulaSyntax ltl_formula;
    CompositeState cached;
    LabelSet alphaExtension;
    Hashtable init_params;
    Vector params;
    static Hashtable definitions;
    static Hashtable constraints;

    private AssertDefinition(Symbol n, FormulaSyntax f, LabelSet ls, Hashtable ip, Vector p) {
        this.name = n;
        this.ltl_formula = f;
        this.cached = null;
        this.alphaExtension = ls;
        this.init_params = ip;
        this.params = p;
    }

    public static void put(Symbol n, FormulaSyntax f, LabelSet ls, Hashtable ip, Vector p, boolean isConstraint) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (constraints == null) {
            constraints = new Hashtable();
        }
        if (!isConstraint) {
            if (definitions.put(n.toString(), new AssertDefinition(n, f, ls, ip, p)) != null) {
                Diagnostics.fatal("duplicate LTL property definition: " + n, n);
            }
        } else if (constraints.put(n.toString(), new AssertDefinition(n, f, ls, ip, p)) != null) {
            Diagnostics.fatal("duplicate LTL constraint definition: " + n, n);
        }
    }

    public static void init() {
        definitions = null;
        constraints = null;
    }

    public static String[] names() {
        if (definitions == null) {
            return null;
        }
        int n = definitions.size();
        if (n == 0) {
            return null;
        }
        String[] na = new String[n];
        Enumeration e = definitions.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            na[i++] = (String)e.nextElement();
        }
        return na;
    }

    public static void compileAll(LTSOutput output) {
        AssertDefinition.compileAll(definitions, output);
        AssertDefinition.compileAll(constraints, output);
    }

    private static void compileAll(Hashtable definitions, LTSOutput output) {
        if (definitions == null) {
            return;
        }
        Enumeration e = definitions.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            AssertDefinition p = (AssertDefinition)definitions.get(name);
            p.fac = new FormulaFactory();
            p.fac.setFormula(p.ltl_formula.expand(p.fac, new Hashtable(), p.init_params));
        }
    }

    public static CompositeState compile(LTSOutput output, String asserted) {
        return AssertDefinition.compile(definitions, output, asserted);
    }

    public static void compileConstraints(LTSOutput output, Hashtable compiled) {
        if (constraints == null) {
            return;
        }
        Enumeration e = constraints.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            CompactState cm = AssertDefinition.compileConstraint(output, name);
            compiled.put(cm.name, cm);
        }
    }

    public static CompactState compileConstraint(LTSOutput output, Symbol name, String refname, Vector pvalues) {
        if (constraints == null) {
            return null;
        }
        AssertDefinition p = (AssertDefinition)constraints.get(name.toString());
        if (p == null) {
            return null;
        }
        p.cached = null;
        p.fac = new FormulaFactory();
        if (pvalues != null) {
            if (pvalues.size() != p.params.size()) {
                Diagnostics.fatal("Actual parameters do not match formals: " + name, name);
            }
            Hashtable actual_params = new Hashtable();
            int i = 0;
            while (i < pvalues.size()) {
                actual_params.put(p.params.elementAt(i), pvalues.elementAt(i));
                ++i;
            }
            p.fac.setFormula(p.ltl_formula.expand(p.fac, new Hashtable(), actual_params));
        } else {
            p.fac.setFormula(p.ltl_formula.expand(p.fac, new Hashtable(), p.init_params));
        }
        CompositeState cs = AssertDefinition.compile(constraints, output, name.toString());
        if (cs == null) {
            return null;
        }
        if (!cs.isProperty) {
            Diagnostics.fatal("LTL constraint must be safety: " + p.name, p.name);
        }
        cs.composition.unMakeProperty();
        cs.composition.name = refname;
        return cs.composition;
    }

    public static CompactState compileConstraint(LTSOutput output, String constraint) {
        CompositeState cs = AssertDefinition.compile(constraints, output, constraint);
        if (cs == null) {
            return null;
        }
        if (!cs.isProperty) {
            AssertDefinition p = (AssertDefinition)constraints.get(constraint);
            Diagnostics.fatal("LTL constraint must be safety: " + p.name, p.name);
        }
        cs.composition.unMakeProperty();
        return cs.composition;
    }

    private static CompositeState compile(Hashtable definitions, LTSOutput output, String asserted) {
        Vector<String> alpha;
        if (definitions == null || asserted == null) {
            return null;
        }
        AssertDefinition p = (AssertDefinition)definitions.get(asserted);
        if (p == null) {
            return null;
        }
        if (p.cached != null) {
            return p.cached;
        }
        output.outln("Formula !" + p.name.toString() + " = " + p.fac.getFormula());
        Vector<String> vector = alpha = p.alphaExtension != null ? p.alphaExtension.getActions(null) : null;
        if (alpha == null) {
            alpha = new Vector<String>();
        }
        alpha.add("*");
        GeneralizedBuchiAutomata gba = new GeneralizedBuchiAutomata(p.name.toString(), p.fac, alpha);
        gba.translate();
        Graph g = gba.Gmake();
        output.outln("GBA " + g.getNodeCount() + " states " + g.getEdgeCount() + " transitions");
        g = SuperSetReduction.reduce((Graph)g);
        Graph g1 = Degeneralize.degeneralize((Graph)g);
        g1 = SCCReduction.reduce((Graph)g1);
        g1 = Simplify.simplify((Graph)g1);
        g1 = SFSReduction.reduce((Graph)g1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Converter c = new Converter(p.name.toString(), g1, gba.getLabelFactory());
        output.outln("Buchi automata:");
        c.printFSP(new PrintStream(baos));
        output.out(baos.toString());
        Vector procs = gba.getLabelFactory().propProcs;
        procs.add(c);
        CompositeState cs = new CompositeState(c.name, procs);
        cs.hidden = gba.getLabelFactory().getPrefix();
        cs.setFluentTracer(new FluentTrace(gba.getLabelFactory().getFluents()));
        cs.compose(output, true);
        cs.composition.removeNonDetTau();
        output.outln("After Tau elimination = " + cs.composition.maxStates + " state");
        Minimiser e = new Minimiser(cs.composition, output);
        cs.composition = e.minimise();
        if (cs.composition.isSafetyOnly()) {
            cs.composition.makeSafety();
            cs.determinise(output);
            cs.isProperty = true;
        }
        cs.composition.removeDetCycles("*");
        p.cached = cs;
        return cs;
    }
}

