/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.And;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.GeneralizedBuchiAutomata;
import ic.doc.ltsa.lts.ltl.Next;
import ic.doc.ltsa.lts.ltl.Or;
import ic.doc.ltsa.lts.ltl.Release;
import ic.doc.ltsa.lts.ltl.State;
import ic.doc.ltsa.lts.ltl.Transition;
import ic.doc.ltsa.lts.ltl.True;
import ic.doc.ltsa.lts.ltl.Until;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class Node
implements Comparable {
    int id = aut.newId();
    int equivId = -1;
    SortedSet incoming;
    SortedSet oldf;
    SortedSet newf;
    SortedSet next;
    BitSet accepting;
    BitSet rightOfU;
    static FormulaFactory fac;
    static GeneralizedBuchiAutomata aut;
    private Node otherSource = null;
    private static boolean collapsed;

    static {
        collapsed = false;
    }

    static void setAut(GeneralizedBuchiAutomata a) {
        aut = a;
    }

    static void setFactory(FormulaFactory f) {
        fac = f;
    }

    public Node() {
        this(null, null, null, null, null, null);
    }

    public Node(SortedSet i, SortedSet o, SortedSet n, SortedSet x, BitSet a, BitSet r) {
        this.incoming = i != null ? new TreeSet(i) : new TreeSet();
        this.oldf = o != null ? new TreeSet(o) : new TreeSet();
        this.newf = n != null ? new TreeSet(n) : new TreeSet();
        this.next = x != null ? new TreeSet(x) : new TreeSet();
        this.accepting = new BitSet();
        if (a != null) {
            this.accepting.or(a);
        }
        this.rightOfU = new BitSet();
        if (r != null) {
            this.rightOfU.or(r);
        }
    }

    public Node(Formula f) {
        this();
        collapsed = false;
        if (!(f instanceof True)) {
            this.decomposeAndforNext(f);
        }
    }

    public int compareTo(Object obj) {
        return this.id - ((Node)obj).id;
    }

    public void decomposeAndforNext(Formula f) {
        if (f instanceof And) {
            this.decomposeAndforNext(((And)f).getLeft());
            this.decomposeAndforNext(((And)f).getRight());
        } else if (!this.isRedundant(this.next, null, f)) {
            this.next.add(f);
        }
    }

    private boolean isRedundant(SortedSet one, SortedSet two, Formula f) {
        return fac.specialCaseV(f, one) || fac.syntaxImplied(f, one, two) && (!(f instanceof Until) || fac.syntaxImplied(f.getSub2(), one, two));
    }

    private Node split(Formula f) {
        Node node = new Node(this.incoming, this.oldf, this.newf, this.next, this.accepting, this.rightOfU);
        Formula nf = f.getSub2();
        if (!this.oldf.contains(nf)) {
            node.newf.add(nf);
        }
        if (f instanceof Release && !this.oldf.contains(nf = f.getSub1())) {
            node.newf.add(nf);
        }
        if (!this.oldf.contains(nf = f.getSub1())) {
            this.newf.add(nf);
        }
        Formula formula = nf = f instanceof Until || f instanceof Release ? f : null;
        if (nf != null) {
            this.decomposeAndforNext(nf);
        }
        if (f instanceof Until) {
            this.accepting.set(f.getUI());
            node.accepting.set(f.getUI());
        }
        if (f.isRightOfUntil()) {
            this.rightOfU.or(f.getRofWU());
            node.rightOfU.or(f.getRofWU());
        }
        if (f.isLiteral()) {
            this.oldf.add(f);
            node.oldf.add(f);
        }
        return node;
    }

    public List expand(List aut) {
        if (this.newf.isEmpty()) {
            Node node;
            if (this.id != 0) {
                this.accepting.andNot(this.rightOfU);
            }
            if ((node = this.alreadyThere(aut)) != null) {
                node.modify(this);
                return aut;
            }
            Node n = new Node();
            n.incoming.add(this);
            n.newf.addAll(this.next);
            aut.add(this);
            return n.expand(aut);
        }
        Formula nf = (Formula)this.newf.first();
        this.newf.remove(nf);
        if (this.contradiction(nf)) {
            return aut;
        }
        TreeSet oldUnew = new TreeSet();
        oldUnew.addAll(this.oldf);
        oldUnew.addAll(this.newf);
        if (this.isRedundant(oldUnew, this.next, nf)) {
            return this.expand(aut);
        }
        if (!nf.isLiteral()) {
            if (nf instanceof Or || nf instanceof Until || nf instanceof Release) {
                Node n1 = this.split(nf);
                return n1.expand(this.expand(aut));
            }
            if (nf instanceof And) {
                Formula f = nf.getSub1();
                if (!this.oldf.contains(f)) {
                    this.newf.add(f);
                }
                if (!this.oldf.contains(f = nf.getSub2())) {
                    this.newf.add(f);
                }
                if (nf.isRightOfUntil()) {
                    this.rightOfU.or(nf.getRofWU());
                }
                return this.expand(aut);
            }
            if (nf instanceof Next) {
                this.decomposeAndforNext(nf.getSub1());
                if (nf.isRightOfUntil()) {
                    this.rightOfU.or(nf.getRofWU());
                }
                return this.expand(aut);
            }
        }
        if (!(nf instanceof True)) {
            this.oldf.add(nf);
        }
        if (nf.isRightOfUntil()) {
            this.rightOfU.or(nf.getRofWU());
        }
        return this.expand(aut);
    }

    private boolean contradiction(Formula f) {
        return fac.syntaxImplied(fac.makeNot(f), this.oldf, this.next);
    }

    private Node alreadyThere(List aut) {
        Iterator i = aut.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            if (!this.next.equals(n.next) || !this.compareAccepting(n)) continue;
            return n;
        }
        return null;
    }

    private boolean compareAccepting(Node n) {
        if (this.id == 0 && !collapsed) {
            return true;
        }
        return this.accepting.equals(n.accepting);
    }

    static void printFormulaSet(LTSOutput out, String name, SortedSet fs) {
        out.out(String.valueOf(name) + ":- ");
        Iterator i = fs.iterator();
        while (i.hasNext()) {
            Formula f = (Formula)i.next();
            out.out(String.valueOf(f.toString()) + ", ");
        }
    }

    static void printIdSet(LTSOutput out, String name, SortedSet fs) {
        out.out(String.valueOf(name) + ":- ");
        Iterator i = fs.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            out.out(String.valueOf(n.id) + ", ");
        }
        out.outln(".");
    }

    void printNode(LTSOutput out) {
        out.outln("\nNODE " + this.id + " equivId " + this.equivId);
        Node.printIdSet(out, "INCOMING", this.incoming);
        Node.printFormulaSet(out, "NEW", this.newf);
        out.outln(".");
        Node.printFormulaSet(out, "OLD", this.oldf);
        out.outln(".");
        Node.printFormulaSet(out, "NEXT", this.next);
        out.outln(".");
        out.outln("ACCEPTING:- " + this.accepting);
        out.outln("RIGHTOFU:- " + this.rightOfU);
        if (this.otherSource != null) {
            out.outln("OTHERSOURCE " + this.otherSource.id + " ************** ");
            Node n = this.otherSource;
            while (n != null) {
                n.printNode(out);
                n = n.otherSource;
                if (n == this) break;
            }
        }
    }

    private void modify(Node n) {
        boolean found = false;
        Node n1 = this;
        Node n2 = this;
        if (this.id == 0 && !collapsed) {
            this.accepting = n.accepting;
            collapsed = true;
        }
        while (n2 != null) {
            if (n2.oldf.equals(n.oldf)) {
                n2.incoming.addAll(n.incoming);
                found = true;
            }
            n1 = n2;
            n2 = n2.otherSource;
        }
        if (!found) {
            n1.otherSource = n;
        }
    }

    private boolean isSafetyAcc() {
        if (this.next.isEmpty()) {
            return true;
        }
        Iterator i = this.next.iterator();
        while (i.hasNext()) {
            Formula f = (Formula)i.next();
            if (f instanceof Release) continue;
            return false;
        }
        return true;
    }

    public void makeTransitions(State[] astate) {
        if (astate[this.id] == null) {
            astate[this.id] = new State(this.equivId);
        } else {
            astate[this.id].setId(this.equivId);
        }
        boolean safAcc = this.isSafetyAcc();
        Node node = this;
        while (node != null) {
            Iterator ii = node.incoming.iterator();
            while (ii.hasNext()) {
                Node node1 = (Node)ii.next();
                int i = node1.id;
                if (astate[i] == null) {
                    astate[i] = new State();
                }
                astate[i].add(new Transition(node.oldf, this.equivId, this.accepting, safAcc));
            }
            node = node.otherSource;
        }
    }
}

