/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import gov.nasa.arc.ase.util.graph.Node;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.ltl.Transition;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class State
implements Comparable {
    private List transitions;
    private int stateId;

    State(List t, int id) {
        this.transitions = t;
        this.stateId = id;
    }

    State() {
        this(new LinkedList(), -1);
    }

    State(int id) {
        this(new LinkedList(), id);
    }

    void setId(int id) {
        this.stateId = id;
    }

    int getId() {
        return this.stateId;
    }

    public int compareTo(Object obj) {
        return this != obj ? 1 : 0;
    }

    public void add(Transition t) {
        this.transitions.add(t);
    }

    void print(LTSOutput out, int nacc) {
        out.outln("STATE " + this.stateId);
        Iterator i = this.transitions.iterator();
        while (i.hasNext()) {
            ((Transition)i.next()).print(out, nacc);
        }
    }

    void Gmake(Node[] anode, Node node, int nacc) {
        ListIterator listiterator = this.transitions.listIterator(0);
        while (listiterator.hasNext()) {
            Transition transition = (Transition)listiterator.next();
            transition.Gmake(anode, node, nacc);
        }
    }
}

