/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import java.util.Arrays;
import java.util.List;
import ltsaeclipse.views.ExampleLabelProvider;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.ExampleTaskList;
import ltsaeclipse.views.ExampleTaskSorter;
import ltsaeclipse.views.ITaskListViewer;
import ltsaeclipse.views.LTSADrawView;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LTSADrawTable {
    Composite parent;
    private Table table;
    private TableViewer tableViewer;
    private Button closeButton;
    private LTSADrawView drawView;
    private ISelectionChangedListener selectionChangeListener;
    private ExampleTaskList taskList = new ExampleTaskList();
    private final String COMPLETED_COLUMN = "completed";
    private final String DESCRIPTION_COLUMN = "description";
    private final String OWNER_COLUMN = "owner";
    private final String PERCENT_COLUMN = "percent";
    private String[] columnNames = new String[]{"completed", "description", "owner", "percent"};

    public LTSADrawTable(Composite parentComp, LTSADrawView aDrawView) {
        this.addChildControls(parentComp);
        this.parent = parentComp;
        this.drawView = aDrawView;
    }

    private void run(Shell shell) {
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSADrawTable.this.table.getParent().getParent().dispose();
            }
        });
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void setChangeListener(ISelectionChangedListener listener) {
        this.selectionChangeListener = listener;
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    private void addChildControls(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ExampleContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExampleLabelProvider());
        this.taskList = new ExampleTaskList();
        this.tableViewer.setInput((Object)this.taskList);
        if (this.selectionChangeListener != null) {
            this.tableViewer.addSelectionChangedListener(this.selectionChangeListener);
        } else {
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ExampleTask task = (ExampleTask)((IStructuredSelection)LTSADrawTable.this.tableViewer.getSelection()).getFirstElement();
                    if (task != null) {
                        LTSADrawTable.this.parent.redraw();
                        if (LTSADrawTable.this.drawView != null) {
                            LTSADrawTable.this.drawView.updateView(task.getDescription());
                        }
                    }
                }
            });
        }
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText("!");
        column.setWidth(20);
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Machine");
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSADrawTable.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText("States");
        column.setWidth(50);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSADrawTable.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(2));
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[0] = textEditor;
        textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[1] = textEditor;
        this.tableViewer.setCellEditors(editors);
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public String[] getChoices(String property) {
        if ("owner".equals(property)) {
            return this.taskList.getOwners();
        }
        return new String[0];
    }

    private void createButtons(Composite parent) {
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public ExampleTaskList getTaskList() {
        return this.taskList;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    class ExampleContentProvider
    implements IStructuredContentProvider,
    ITaskListViewer {
        ExampleContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ExampleTaskList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ExampleTaskList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            LTSADrawTable.this.taskList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return LTSADrawTable.this.taskList.getTasks().toArray();
        }

        public void addTask(ExampleTask task) {
            LTSADrawTable.this.tableViewer.add((Object)task);
        }

        public void removeTask(ExampleTask task) {
            LTSADrawTable.this.tableViewer.remove((Object)task);
        }

        public void clearTasks() {
        }

        public void updateTask(ExampleTask task) {
            LTSADrawTable.this.tableViewer.update((Object)task, null);
        }
    }
}

