/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import java.util.Arrays;
import java.util.List;
import ltsaeclipse.views.ExampleLabelProvider;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.ExampleTaskList;
import ltsaeclipse.views.ExampleTaskSorter;
import ltsaeclipse.views.ITaskListViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableViewerExample {
    private Table table;
    private TableViewer tableViewer;
    private Button closeButton;
    private ExampleTaskList taskList = new ExampleTaskList();
    private final String COMPLETED_COLUMN = "completed";
    private final String DESCRIPTION_COLUMN = "description";
    private final String OWNER_COLUMN = "owner";
    private final String PERCENT_COLUMN = "percent";
    private String[] columnNames = new String[]{"completed", "description", "owner", "percent"};

    public TableViewerExample(Composite parent) {
        this.addChildControls(parent);
    }

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setText("Task List - TableViewer Example");
        GridLayout layout = new GridLayout();
        shell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)shell, 0);
        TableViewerExample tableViewerExample = new TableViewerExample(composite);
        tableViewerExample.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableViewerExample.this.dispose();
            }
        });
        shell.open();
        tableViewerExample.run(shell);
    }

    private void run(Shell shell) {
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerExample.this.table.getParent().getParent().dispose();
            }
        });
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    private void addChildControls(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 4;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ExampleContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExampleLabelProvider());
        this.taskList = new ExampleTaskList();
        this.tableViewer.setInput((Object)this.taskList);
        this.createButtons(composite);
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText("!");
        column.setWidth(20);
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Description");
        column.setWidth(400);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerExample.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText("Owner");
        column.setWidth(100);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerExample.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(2));
            }
        });
        column = new TableColumn(this.table, 0x1000000, 3);
        column.setText("% Complete");
        column.setWidth(80);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerExample.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(3));
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        editors[0] = new CheckboxCellEditor((Composite)this.table);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[1] = textEditor;
        editors[2] = new ComboBoxCellEditor((Composite)this.table, this.taskList.getOwners(), 0);
        textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789".indexOf(e.text) >= 0;
            }
        });
        editors[3] = textEditor;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(1));
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public String[] getChoices(String property) {
        if ("owner".equals(property)) {
            return this.taskList.getOwners();
        }
        return new String[0];
    }

    private void createButtons(Composite parent) {
        Button add = new Button(parent, 0x1000008);
        add.setText("Add");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        add.setLayoutData((Object)gridData);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewerExample.this.taskList.addTask("", "");
            }
        });
        Button delete = new Button(parent, 0x1000008);
        delete.setText("Delete");
        gridData = new GridData(32);
        gridData.widthHint = 80;
        delete.setLayoutData((Object)gridData);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExampleTask task = (ExampleTask)((IStructuredSelection)TableViewerExample.this.tableViewer.getSelection()).getFirstElement();
                if (task != null) {
                    TableViewerExample.this.taskList.removeTask(task);
                }
            }
        });
        this.closeButton = new Button(parent, 0x1000008);
        this.closeButton.setText("Close");
        gridData = new GridData(128);
        gridData.widthHint = 80;
        this.closeButton.setLayoutData((Object)gridData);
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public ExampleTaskList getTaskList() {
        return this.taskList;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    class ExampleContentProvider
    implements IStructuredContentProvider,
    ITaskListViewer {
        ExampleContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ExampleTaskList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ExampleTaskList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            TableViewerExample.this.taskList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return TableViewerExample.this.taskList.getTasks().toArray();
        }

        public void addTask(ExampleTask task) {
            TableViewerExample.this.tableViewer.add((Object)task);
        }

        public void removeTask(ExampleTask task) {
            TableViewerExample.this.tableViewer.remove((Object)task);
        }

        public void updateTask(ExampleTask task) {
            TableViewerExample.this.tableViewer.update((Object)task, null);
        }
    }
}

