/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.ParseErrorException;
import gov.nasa.arc.ase.ltl.ParserInternalError;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.TreeSet;

public class Formula
implements Comparable {
    private char content;
    private boolean literal;
    private Formula left;
    private Formula right;
    private int id = nId++;
    private int untils_index;
    private BitSet rightOfWhichUntils;
    private String name;
    private boolean has_been_visited;
    private static int nId = 0;
    private static final int P_ALL = 0;
    private static final int P_OR = 1;
    private static final int P_AND = 2;
    private static final int P_UNTIL = 3;
    private static final int P_WUNTIL = 3;
    private static final int P_RELEASE = 4;
    private static final int P_WRELEASE = 4;
    private static final int P_IMPLIES = 5;
    private static final int P_NOT = 6;
    private static final int P_NEXT = 6;
    private static final int P_ALWAYS = 6;
    private static final int P_EVENTUALLY = 6;
    private static Hashtable ht = new Hashtable();
    private static Hashtable matches = new Hashtable();

    private Formula(char c, boolean bl, Formula formula, Formula formula2, String string) {
        this.content = c;
        this.literal = bl;
        this.left = formula;
        this.right = formula2;
        this.name = string;
        this.rightOfWhichUntils = null;
        this.untils_index = -1;
        this.has_been_visited = false;
    }

    public static void reset_static() {
        Formula.clearMatches();
        Formula.clearHT();
    }

    public int compareTo(Object object) {
        Formula formula = (Formula)object;
        return this.id - formula.id;
    }

    public boolean is_literal() {
        return this.literal;
    }

    public boolean is_right_of_until(int n) {
        return this.rightOfWhichUntils != null;
    }

    public int get_untils_index() {
        return this.untils_index;
    }

    public BitSet get_rightOfWhichUntils() {
        return this.rightOfWhichUntils;
    }

    public char getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public Formula getSub1() {
        if (this.content == 'V') {
            return this.right;
        }
        return this.left;
    }

    public Formula getSub2() {
        if (this.content == 'V') {
            return this.left;
        }
        return this.right;
    }

    public int countUntils(int n) {
        this.has_been_visited = true;
        if (this.getContent() == 'U') {
            ++n;
        }
        if (this.left != null && !this.left.has_been_visited) {
            n = this.left.countUntils(n);
        }
        if (this.right != null && !this.right.has_been_visited) {
            n = this.right.countUntils(n);
        }
        return n;
    }

    public void reset_visited() {
        this.has_been_visited = false;
        if (this.left != null) {
            this.left.reset_visited();
        }
        if (this.right != null) {
            this.right.reset_visited();
        }
    }

    public int initialize() {
        int n = this.countUntils(0);
        this.reset_visited();
        int n2 = this.processRightUntils(0, n);
        this.reset_visited();
        return n;
    }

    public int processRightUntils(int n, int n2) {
        this.has_been_visited = true;
        if (this.getContent() == 'U') {
            this.untils_index = n;
            if (this.right.rightOfWhichUntils == null) {
                this.right.rightOfWhichUntils = new BitSet(n2);
            }
            this.right.rightOfWhichUntils.set(n);
            ++n;
        }
        if (this.left != null && !this.left.has_been_visited) {
            n = this.left.processRightUntils(n, n2);
        }
        if (this.right != null && !this.right.has_been_visited) {
            n = this.right.processRightUntils(n, n2);
        }
        return n;
    }

    public Formula getNext() {
        switch (this.content) {
            case 'U': 
            case 'W': {
                return this;
            }
            case 'V': {
                return this;
            }
            case 'O': {
                return null;
            }
        }
        return null;
    }

    public void addLeft(Formula formula) {
        this.left = formula;
    }

    public void addRight(Formula formula) {
        this.right = formula;
    }

    public Formula negate() {
        return Formula.Not(this);
    }

    public boolean is_special_case_of_V(TreeSet treeSet) {
        Formula formula = Formula.Release(Formula.False(), this);
        return treeSet.contains(formula);
    }

    public boolean is_synt_implied(TreeSet treeSet, TreeSet treeSet2) {
        if (this.getContent() == 't') {
            return true;
        }
        if (treeSet.contains(this)) {
            return true;
        }
        if (!this.is_literal()) {
            Formula formula = this.getSub1();
            Formula formula2 = this.getSub2();
            Formula formula3 = this.getNext();
            boolean bl = formula2 != null ? formula2.is_synt_implied(treeSet, treeSet2) : true;
            boolean bl2 = formula != null ? formula.is_synt_implied(treeSet, treeSet2) : true;
            boolean bl3 = formula3 != null ? (treeSet2 != null ? treeSet2.contains(formula3) : false) : true;
            switch (this.getContent()) {
                case 'O': 
                case 'U': 
                case 'W': {
                    return bl || bl2 && bl3;
                }
                case 'V': {
                    return bl2 && bl || bl2 && bl3;
                }
                case 'X': {
                    if (formula != null) {
                        if (treeSet2 != null) {
                            return treeSet2.contains(formula);
                        }
                        return false;
                    }
                    return true;
                }
                case 'A': {
                    return bl && bl2;
                }
            }
            System.out.println("Default case of switch at Form.synt_implied");
            return false;
        }
        return false;
    }

    public String toString(boolean bl) {
        if (!bl) {
            return this.toString();
        }
        switch (this.content) {
            case 'A': {
                return "( " + this.left.toString(true) + " /\\ " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'O': {
                return "( " + this.left.toString(true) + " \\/ " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'U': {
                return "( " + this.left.toString(true) + " U " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'V': {
                return "( " + this.left.toString(true) + " V " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'W': {
                return "( " + this.left.toString(true) + " W " + this.right.toString(true) + " )[" + this.id + "]";
            }
            case 'X': {
                return "( X " + this.left.toString(true) + " )[" + this.id + "]";
            }
            case 'N': {
                return "( ! " + this.left.toString(true) + " )[" + this.id + "]";
            }
            case 't': {
                return "( true )[" + this.id + "]";
            }
            case 'f': {
                return "( false )[" + this.id + "]";
            }
            case 'p': {
                return "( \"" + this.name + "\" )[" + this.id + "]";
            }
        }
        return "( " + this.content + " )[" + this.id + "]";
    }

    public String toString() {
        switch (this.content) {
            case 'A': {
                return "( " + this.left.toString() + " /\\ " + this.right.toString() + " )";
            }
            case 'O': {
                return "( " + this.left.toString() + " \\/ " + this.right.toString() + " )";
            }
            case 'U': {
                return "( " + this.left.toString() + " U " + this.right.toString() + " )";
            }
            case 'V': {
                return "( " + this.left.toString() + " V " + this.right.toString() + " )";
            }
            case 'W': {
                return "( " + this.left.toString() + " W " + this.right.toString() + " )";
            }
            case 'X': {
                return "( X " + this.left.toString() + " )";
            }
            case 'N': {
                return "( ! " + this.left.toString() + " )";
            }
            case 't': {
                return "( true )";
            }
            case 'f': {
                return "( false )";
            }
            case 'p': {
                return "( \"" + this.name + "\" )";
            }
        }
        return new Character(this.content).toString();
    }

    public static Formula parse(String string) throws ParseErrorException {
        Input input = new Input(string);
        return Formula.parse(input, 0);
    }

    /*
     * Unable to fully structure code
     */
    private static Formula parse(Input var0, int var1_1) throws ParseErrorException {
        try {
            while (var0.get() == ' ') {
                var0.skip();
            }
            var3_2 = var0.get();
            switch (var3_2) {
                case ')': 
                case '/': 
                case 'M': 
                case 'U': 
                case 'V': 
                case 'W': 
                case '\\': {
                    throw new ParseErrorException("invalid character: " + var3_2);
                }
                case '!': {
                    var0.skip();
                    var2_3 = Formula.Not(Formula.parse(var0, 6));
                    break;
                }
                case 'X': {
                    var0.skip();
                    var2_3 = Formula.Next(Formula.parse(var0, 6));
                    break;
                }
                case '[': {
                    var0.skip();
                    if (var0.get() != ']') {
                        throw new ParseErrorException("expected ]");
                    }
                    var0.skip();
                    var2_3 = Formula.Always(Formula.parse(var0, 6));
                    break;
                }
                case '<': {
                    var0.skip();
                    if (var0.get() != '>') {
                        throw new ParseErrorException("expected >");
                    }
                    var0.skip();
                    var2_3 = Formula.Eventually(Formula.parse(var0, 6));
                    break;
                }
                case '(': {
                    var0.skip();
                    var2_3 = Formula.parse(var0, 0);
                    if (var0.get() != ')') {
                        throw new ParseErrorException("invalid character: " + var3_2);
                    }
                    var0.skip();
                    break;
                }
                case '\"': {
                    var4_5 = new StringBuffer();
                    var0.skip();
                    while ((var3_2 = var0.get()) != '\"') {
                        var4_5.append(var3_2);
                        var0.skip();
                    }
                    var0.skip();
                    var2_3 = Formula.Proposition(var4_5.toString());
                    break;
                }
                default: {
                    if (Character.isJavaIdentifierStart(var3_2)) {
                        var5_6 = new StringBuffer();
                        var5_6.append(var3_2);
                        var0.skip();
                        try {
                            while (Character.isJavaIdentifierPart(var3_2 = var0.get()) && !Formula.is_reserved_char(var3_2)) {
                                var5_6.append(var3_2);
                                var0.skip();
                            }
                        }
                        catch (EndOfInputException var6_9) {
                            // empty catch block
                        }
                        var6_10 = var5_6.toString();
                        if (var6_10.equals("true")) {
                            var2_3 = Formula.True();
                            break;
                        }
                        if (var6_10.equals("false")) {
                            var2_3 = Formula.False();
                            break;
                        }
                        var2_3 = Formula.Proposition(var5_6.toString());
                        break;
                    }
                    throw new ParseErrorException("invalid character: " + var3_2);
                }
            }
            try {
                while (var0.get() == ' ') {
                    var0.skip();
                }
                var3_2 = var0.get();
            }
            catch (EndOfInputException var5_7) {
                return var2_3;
            }
            while (true) lbl-1000:
            // 2 sources

            {
                switch (var3_2) {
                    case '/': {
                        if (var1_1 > 2) {
                            return var2_3;
                        }
                        var0.skip();
                        if (var0.get() != '\\') {
                            throw new ParseErrorException("expected \\");
                        }
                        var0.skip();
                        var2_3 = Formula.And(var2_3, Formula.parse(var0, 2));
                        break;
                    }
                    case '\\': {
                        if (var1_1 > 1) {
                            return var2_3;
                        }
                        var0.skip();
                        if (var0.get() != '/') {
                            throw new ParseErrorException("expected /");
                        }
                        var0.skip();
                        var2_3 = Formula.Or(var2_3, Formula.parse(var0, 1));
                        break;
                    }
                    case 'U': {
                        if (var1_1 > 3) {
                            return var2_3;
                        }
                        var0.skip();
                        var2_3 = Formula.Until(var2_3, Formula.parse(var0, 3));
                        break;
                    }
                    case 'W': {
                        if (var1_1 > 3) {
                            return var2_3;
                        }
                        var0.skip();
                        var2_3 = Formula.WUntil(var2_3, Formula.parse(var0, 3));
                        break;
                    }
                    case 'V': {
                        if (var1_1 > 4) {
                            return var2_3;
                        }
                        var0.skip();
                        var2_3 = Formula.Release(var2_3, Formula.parse(var0, 4));
                        break;
                    }
                    case 'M': {
                        if (var1_1 > 4) {
                            return var2_3;
                        }
                        var0.skip();
                        var2_3 = Formula.WRelease(var2_3, Formula.parse(var0, 4));
                        break;
                    }
                    case '-': {
                        if (var1_1 > 5) {
                            return var2_3;
                        }
                        var0.skip();
                        if (var0.get() != '>') {
                            throw new ParseErrorException("expected >");
                        }
                        var0.skip();
                        var2_3 = Formula.Implies(var2_3, Formula.parse(var0, 5));
                        break;
                    }
                    case ')': {
                        return var2_3;
                    }
                    default: {
                        throw new ParseErrorException("invalid character: " + var3_2);
                    }
                }
                try {
                    while (var0.get() == ' ') {
                        var0.skip();
                    }
                    var3_2 = var0.get();
                    continue;
                }
                catch (EndOfInputException var5_8) {
                    return var2_3;
                }
                break;
            }
        }
        catch (EndOfInputException var2_4) {
            throw new ParseErrorException("unexpected end of input");
        }
        {
            ** while (true)
        }
    }

    private static Formula And(Formula formula, Formula formula2) {
        if (formula.id < formula2.id) {
            return Formula.unique(new Formula('A', false, formula, formula2, null));
        }
        return Formula.unique(new Formula('A', false, formula2, formula, null));
    }

    private static Formula Or(Formula formula, Formula formula2) {
        if (formula.id < formula2.id) {
            return Formula.unique(new Formula('O', false, formula, formula2, null));
        }
        return Formula.unique(new Formula('O', false, formula2, formula, null));
    }

    private static Formula Until(Formula formula, Formula formula2) {
        return Formula.unique(new Formula('U', false, formula, formula2, null));
    }

    private static Formula WUntil(Formula formula, Formula formula2) {
        return Formula.unique(new Formula('W', false, formula, formula2, null));
    }

    private static Formula Release(Formula formula, Formula formula2) {
        return Formula.unique(new Formula('V', false, formula, formula2, null));
    }

    private static Formula Proposition(String string) {
        return Formula.unique(new Formula('p', true, null, null, string));
    }

    private static Formula Not(Formula formula) {
        if (formula.literal) {
            switch (formula.content) {
                case 't': {
                    return Formula.False();
                }
                case 'f': {
                    return Formula.True();
                }
                case 'N': {
                    return formula.left;
                }
            }
            return Formula.unique(new Formula('N', true, formula, null, null));
        }
        switch (formula.content) {
            case 'A': {
                return Formula.Or(Formula.Not(formula.left), Formula.Not(formula.right));
            }
            case 'O': {
                return Formula.And(Formula.Not(formula.left), Formula.Not(formula.right));
            }
            case 'U': {
                return Formula.Release(Formula.Not(formula.left), Formula.Not(formula.right));
            }
            case 'V': {
                return Formula.Until(Formula.Not(formula.left), Formula.Not(formula.right));
            }
            case 'W': {
                return Formula.WRelease(Formula.Not(formula.left), Formula.Not(formula.right));
            }
            case 'N': {
                return formula.left;
            }
            case 'X': {
                return Formula.Next(Formula.Not(formula.left));
            }
        }
        throw new ParserInternalError();
    }

    private static Formula Next(Formula formula) {
        return Formula.unique(new Formula('X', false, formula, null, null));
    }

    private static Formula Always(Formula formula) {
        return Formula.unique(new Formula('V', false, Formula.False(), formula, null));
    }

    private static Formula Eventually(Formula formula) {
        return Formula.unique(new Formula('U', false, Formula.True(), formula, null));
    }

    private static Formula WRelease(Formula formula, Formula formula2) {
        return Formula.unique(new Formula('U', false, formula2, Formula.And(formula, formula2), null));
    }

    private static Formula Implies(Formula formula, Formula formula2) {
        return Formula.Or(Formula.Not(formula), formula2);
    }

    private static Formula True() {
        return Formula.unique(new Formula('t', true, null, null, null));
    }

    private static Formula False() {
        return Formula.unique(new Formula('f', true, null, null, null));
    }

    private static void clearHT() {
        ht = new Hashtable();
    }

    private static Formula unique(Formula formula) {
        String string = formula.toString();
        if (ht.containsKey(string)) {
            return (Formula)ht.get(string);
        }
        ht.put(string, formula);
        return formula;
    }

    public static boolean is_reserved_char(char c) {
        switch (c) {
            case ' ': 
            case '(': 
            case ')': 
            case '-': 
            case '<': 
            case '>': 
            case 'M': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case '[': 
            case ']': {
                return true;
            }
        }
        return false;
    }

    public Formula rewrite(Formula formula, Formula formula2) {
        switch (this.content) {
            case 'A': 
            case 'O': 
            case 'U': 
            case 'V': 
            case 'W': {
                this.left = this.left.rewrite(formula, formula2);
                this.right = this.right.rewrite(formula, formula2);
                break;
            }
            case 'N': 
            case 'X': {
                this.left = this.left.rewrite(formula, formula2);
                break;
            }
        }
        if (this.match(formula)) {
            Formula formula3 = formula2.rewrite();
            Formula.clearMatches();
            return formula3;
        }
        Formula.clearMatches();
        return this;
    }

    private Formula rewrite() {
        if (this.content == 'p') {
            return this.getMatch(this.name);
        }
        switch (this.content) {
            case 'A': {
                return Formula.And(this.left.rewrite(), this.right.rewrite());
            }
            case 'O': {
                return Formula.Or(this.left.rewrite(), this.right.rewrite());
            }
            case 'U': {
                return Formula.Until(this.left.rewrite(), this.right.rewrite());
            }
            case 'V': {
                return Formula.Release(this.left.rewrite(), this.right.rewrite());
            }
            case 'W': {
                return Formula.WUntil(this.left.rewrite(), this.right.rewrite());
            }
            case 'X': {
                return Formula.Next(this.left.rewrite());
            }
            case 'N': {
                return Formula.Not(this.left.rewrite());
            }
            case 't': {
                return Formula.True();
            }
            case 'f': {
                return Formula.False();
            }
        }
        throw new RuntimeException("code should not be reached");
    }

    private static void clearMatches() {
        matches = new Hashtable();
    }

    private void addMatch(String string, Formula formula) {
        matches.put(string, formula);
    }

    private Formula getMatch(String string) {
        return (Formula)matches.get(string);
    }

    private boolean match(Formula formula) {
        if (formula.content == 'p') {
            Formula formula2 = this.getMatch(formula.name);
            if (formula2 == null) {
                this.addMatch(formula.name, this);
                return true;
            }
            return formula2 == this;
        }
        if (formula.content != this.content) {
            return false;
        }
        Hashtable hashtable = (Hashtable)matches.clone();
        switch (this.content) {
            case 'A': 
            case 'O': {
                if (this.left.match(formula.left) && this.right.match(formula.right)) {
                    return true;
                }
                matches = hashtable;
                if (this.right.match(formula.left) && this.left.match(formula.right)) {
                    return true;
                }
                matches = hashtable;
                return false;
            }
            case 'U': 
            case 'V': 
            case 'W': {
                if (this.left.match(formula.left) && this.right.match(formula.right)) {
                    return true;
                }
                matches = hashtable;
                return false;
            }
            case 'N': 
            case 'X': {
                if (this.left.match(formula.left)) {
                    return true;
                }
                matches = hashtable;
                return false;
            }
            case 'f': 
            case 't': {
                return true;
            }
        }
        throw new RuntimeException("code should not be reached");
    }

    public int size() {
        switch (this.content) {
            case 'A': 
            case 'O': 
            case 'U': 
            case 'V': 
            case 'W': {
                return this.left.size() + this.right.size() + 1;
            }
            case 'N': 
            case 'X': {
                return this.left.size() + 1;
            }
        }
        return 0;
    }

    private static class Input {
        private StringBuffer sb;

        public Input(String string) {
            this.sb = new StringBuffer(string);
        }

        public char get() throws EndOfInputException {
            try {
                return this.sb.charAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new EndOfInputException();
            }
        }

        public void skip() throws EndOfInputException {
            try {
                this.sb.deleteCharAt(0);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new EndOfInputException();
            }
        }
    }

    public static class EndOfInputException
    extends Exception {
    }
}

