/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import gov.nasa.arc.ase.util.BSet;

public class ArrayBSet
implements BSet {
    private static final int SHIFT = 5;
    private static final int REMIDER = 32;
    private int[] array;
    private int size;

    public ArrayBSet(boolean[] blArray) {
        this.size = blArray.length;
        this.array = new int[this.size + 31 >> 5];
        int n = 0;
        while (n < this.size) {
            if (blArray[n]) {
                this.set(n);
            }
            ++n;
        }
    }

    private void set(int n) {
        int n2 = n >> 5;
        this.array[n2] = this.array[n2] | 1 << n % 32;
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(n + " < 0");
        }
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(n + " >= " + this.size);
        }
        return (this.array[n >> 5] & 1 << n % 32) != 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ArrayBSet)) {
            return false;
        }
        ArrayBSet arrayBSet = (ArrayBSet)object;
        if (this.size != arrayBSet.size) {
            return false;
        }
        int n = 0;
        int n2 = this.array.length;
        while (n < n2) {
            if (this.array[n] != arrayBSet.array[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (this.get(n)) {
                stringBuffer.append('R');
            } else {
                stringBuffer.append('-');
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

