/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util;

import gov.nasa.arc.ase.util.LexerException;

public class Lexer {
    public static final char STRING = 'S';
    public static final char INTEGER = 'I';
    public static final char END = 'E';
    public static final char ID = 'i';
    public static final char LOGICAND = 'a';
    public static final char LOGICOR = 'o';
    public static final char EQUAL = 'e';
    public static final char LESSEQUAL = 'l';
    public static final char GREATEREQUAL = 'g';
    private char[] data;
    private int length;
    private int offset;
    private StringBuffer string;

    public Lexer(String string) {
        this.length = string.length();
        this.data = new char[this.length];
        int n = 0;
        while (n < this.length) {
            this.data[n] = string.charAt(n);
            ++n;
        }
        this.offset = 0;
    }

    public char lex() throws LexerException {
        try {
            block19: while (true) {
                switch (this.data[this.offset]) {
                    case '\'': {
                        ++this.offset;
                        return this.parseQuoted('\'');
                    }
                    case '\"': {
                        ++this.offset;
                        return this.parseQuoted('\"');
                    }
                    case ',': {
                        ++this.offset;
                        return ',';
                    }
                    case ';': {
                        ++this.offset;
                        return ';';
                    }
                    case ':': {
                        ++this.offset;
                        return ':';
                    }
                    case '.': {
                        ++this.offset;
                        return '.';
                    }
                    case '(': {
                        ++this.offset;
                        return '(';
                    }
                    case ')': {
                        ++this.offset;
                        return ')';
                    }
                    case ' ': {
                        ++this.offset;
                        continue block19;
                    }
                    case '\t': {
                        ++this.offset;
                        continue block19;
                    }
                    case '=': {
                        ++this.offset;
                        if (this.data[this.offset] == '=') {
                            ++this.offset;
                            return 'e';
                        }
                        throw new LexerException("Unexpected character '" + this.data[this.offset] + "'");
                    }
                    case '<': {
                        ++this.offset;
                        if (this.data[this.offset] == '=') {
                            ++this.offset;
                            return 'l';
                        }
                        return '<';
                    }
                    case '>': {
                        ++this.offset;
                        if (this.data[this.offset] == '=') {
                            ++this.offset;
                            return 'g';
                        }
                        return '>';
                    }
                    case '&': {
                        ++this.offset;
                        if (this.data[this.offset] == '&') {
                            ++this.offset;
                            return 'a';
                        }
                        return '&';
                    }
                    case '|': {
                        ++this.offset;
                        if (this.data[this.offset] == '|') {
                            ++this.offset;
                            return 'o';
                        }
                        return '|';
                    }
                }
                break;
            }
            if (Character.isDigit(this.data[this.offset])) {
                return this.parseInt();
            }
            if (Character.isJavaIdentifierStart(this.data[this.offset])) {
                return this.parseId();
            }
            throw new LexerException("invalid character '" + this.data[this.offset] + "'");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 'E';
        }
    }

    public String getStringValue() {
        return this.string.toString();
    }

    public int getIntValue() {
        return Integer.parseInt(this.string.toString());
    }

    private char parseQuoted(char c) {
        this.string = new StringBuffer();
        try {
            while (this.data[this.offset] != c) {
                this.string.append(this.data[this.offset++]);
            }
            ++this.offset;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return 'S';
    }

    private char parseInt() {
        this.string = new StringBuffer();
        try {
            while (Character.isDigit(this.data[this.offset])) {
                this.string.append(this.data[this.offset++]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return 'I';
    }

    private char parseId() {
        this.string = new StringBuffer();
        try {
            while (Character.isJavaIdentifierPart(this.data[this.offset])) {
                this.string.append(this.data[this.offset++]);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return 'i';
    }
}

