/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.util.graph;

import gov.nasa.arc.ase.util.graph.Edge;
import gov.nasa.arc.ase.util.graph.EmptyVisitor;
import gov.nasa.arc.ase.util.graph.Graph;
import gov.nasa.arc.ase.util.graph.Node;
import java.io.IOException;

public class SuperSetReduction {
    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("usage:");
            System.out.println("\tjava gov.nasa.arc.ase.util.graph.SuperSetReduction [<filename>]");
            return;
        }
        Graph graph = null;
        try {
            graph = stringArray.length == 0 ? Graph.load() : Graph.load(stringArray[0]);
        }
        catch (IOException iOException) {
            System.out.println("Can't load the graph.");
            return;
        }
        graph = SuperSetReduction.reduce(graph);
        graph.save();
    }

    public static Graph reduce(Graph graph) {
        final int n = graph.getIntAttribute("nsets");
        String string = graph.getStringAttribute("type");
        String string2 = graph.getStringAttribute("ac");
        if (!string.equals("gba")) {
            throw new RuntimeException("invalid graph type: " + string);
        }
        if (string2.equals("nodes")) {
            int n2;
            int n3 = graph.getNodeCount();
            final boolean[][] blArray = new boolean[n][n3];
            graph.forAllNodes(new EmptyVisitor(){

                public void visitNode(Node node) {
                    int n2 = 0;
                    while (n2 < n) {
                        String string = "acc" + n2;
                        if (node.getBooleanAttribute(string)) {
                            blArray[n2][node.getId()] = true;
                            node.setBooleanAttribute(string, false);
                        }
                        ++n2;
                    }
                }
            });
            boolean[] blArray2 = new boolean[n];
            int n4 = 0;
            while (n4 < n) {
                n2 = 0;
                while (n2 < n && !blArray2[n4]) {
                    if (n4 != n2 && !blArray2[n2] && SuperSetReduction.included(blArray[n2], blArray[n4])) {
                        blArray2[n4] = true;
                    }
                    ++n2;
                }
                ++n4;
            }
            n2 = 0;
            int n5 = 0;
            while (n5 < n) {
                if (!blArray2[n5]) {
                    ++n2;
                }
                ++n5;
            }
            boolean[][] blArray3 = new boolean[n2][n3];
            n2 = 0;
            int n6 = 0;
            while (n6 < n) {
                if (!blArray2[n6]) {
                    blArray3[n2++] = blArray[n6];
                }
                ++n6;
            }
            graph.setIntAttribute("nsets", n2);
            int n7 = 0;
            while (n7 < n3) {
                Node node = graph.getNode(n7);
                int n8 = 0;
                while (n8 < n2) {
                    if (blArray3[n8][n7]) {
                        node.setBooleanAttribute("acc" + n8, true);
                    }
                    ++n8;
                }
                ++n7;
            }
            return graph;
        }
        if (string2.equals("edges")) {
            int n9;
            int n10 = graph.getEdgeCount();
            final boolean[][] blArray = new boolean[n][n10];
            final Edge[] edgeArray = new Edge[n10];
            graph.forAllEdges(new EmptyVisitor(new Integer(0)){

                public void visitEdge(Edge edge) {
                    int n3 = (Integer)this.arg;
                    this.arg = new Integer(n3 + 1);
                    edgeArray[n3] = edge;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = "acc" + n2;
                        if (edge.getBooleanAttribute(string)) {
                            blArray[n2][n3] = true;
                            edge.setBooleanAttribute(string, false);
                        }
                        ++n2;
                    }
                }
            });
            boolean[] blArray4 = new boolean[n];
            int n11 = 0;
            while (n11 < n) {
                n9 = 0;
                while (n9 < n && !blArray4[n11]) {
                    if (n11 != n9 && !blArray4[n9] && SuperSetReduction.included(blArray[n9], blArray[n11])) {
                        blArray4[n11] = true;
                    }
                    ++n9;
                }
                ++n11;
            }
            n9 = 0;
            int n12 = 0;
            while (n12 < n) {
                if (!blArray4[n12]) {
                    ++n9;
                }
                ++n12;
            }
            boolean[][] blArray5 = new boolean[n9][n10];
            n9 = 0;
            int n13 = 0;
            while (n13 < n) {
                if (!blArray4[n13]) {
                    blArray5[n9++] = blArray[n13];
                }
                ++n13;
            }
            graph.setIntAttribute("nsets", n9);
            int n14 = 0;
            while (n14 < n10) {
                Edge edge = edgeArray[n14];
                int n15 = 0;
                while (n15 < n9) {
                    if (blArray5[n15][n14]) {
                        edge.setBooleanAttribute("acc" + n15, true);
                    }
                    ++n15;
                }
                ++n14;
            }
            return graph;
        }
        throw new RuntimeException("invalid accepting type: " + string2);
    }

    private static boolean included(boolean[] blArray, boolean[] blArray2) {
        int n = blArray.length;
        int n2 = blArray2.length;
        int n3 = 0;
        while (n3 < n) {
            if (blArray[n3] && !blArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

