package ic.doc.ltsa;

import ic.doc.extension.Exportable;

import java.awt.Rectangle;
import java.awt.Graphics2D;
import java.awt.Color;
import javax.swing.JFileChooser;
import java.io.OutputStream;
import java.io.Writer;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.IOException;
import java.io.File;
import javax.swing.JPanel;

import org.apache.batik.transcoder.image.*;
import org.apache.batik.transcoder.*;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.dom.GenericDOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DOMImplementation;

public class GraphicsExporter {

    private JFileChooser o_chooser;

    public GraphicsExporter() {

	o_chooser = new JFileChooser();
	o_chooser.setApproveButtonText( "Save" );
	o_chooser.setDialogTitle( "Export graphics" );
    }

    public void setDefaultFilename( String p_name ) {

	o_chooser.setSelectedFile( new File( p_name ) );
    }

    public void export( Exportable p_canvas ) {

	File x_file = getFile();

	if ( x_file != null ) {
		
	    try {
		
		String x_name = x_file.getName();
		String format = x_name.substring( x_name.lastIndexOf(".") + 1 , x_name.length() );
		format = format.toLowerCase();

		if ( format.equals( "jpeg" ) ) { format = "jpg"; }

		// Get a DOMImplementation
		DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();

		Document document = domImpl.createDocument(null, "svg", null);

		SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
		p_canvas.fileDraw(svgGenerator);

		ImageTranscoder t = null;

		if ( format.equals( "jpg" ) ) { t = new JPEGTranscoder(); }
		else if ( format.equals( "png" ) ){ t = new PNGTranscoder(); }
		else if ( format.equals( "tiff" ) ) { t = new TIFFTranscoder(); }

		if ( t != null ) {

		    // set the transcoding hints
		    // can only do this for jpeg       
		    if ( format.equals( "jpg" ) ) {
			t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, new Float(1.0));
		    }
	 
		    boolean useCSS = false; // we don't want to use CSS style attribute
		    ByteArrayOutputStream x_baos =  new ByteArrayOutputStream( 5000 );
		    Writer out = new OutputStreamWriter( x_baos , "UTF-8" );
		    svgGenerator.stream(out, useCSS);

		    String x_svg_xml = x_baos.toString();

		    TranscoderInput input = new TranscoderInput( new StringReader( x_svg_xml ) );
		    
		    // create the transcoder output
		    OutputStream ostream = new FileOutputStream( x_file.getPath() );
		    TranscoderOutput output = new TranscoderOutput(ostream);
		    
		    // save the image
		    t.transcode(input, output);
		    
		    // flush and close the stream then exit
		    ostream.flush();
		    ostream.close();
	
		} else {
		    
		    // write out the SVG
	       
		    boolean useCSS = true; // we want to use CSS style attribute
		    Writer out = new OutputStreamWriter( new FileOutputStream( x_file ) , "UTF-8" );
		    svgGenerator.stream(out, useCSS);
		}

	    } catch ( Exception e ) { System.err.println( e ); } 
	}
    }  


    private File getFile() {

	int x_returnVal = o_chooser.showOpenDialog(null);
	if( x_returnVal == JFileChooser.APPROVE_OPTION ) {
	    return o_chooser.getSelectedFile();
	} else {
	    return null;
	}
    }
}
