/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa;

import ic.doc.ltsa.dclap.Gr2PICT;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.DrawMachine;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.EventManager;
import ic.doc.ltsa.lts.LTSCanvas;
import ic.doc.ltsa.lts.LTSEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LTSDrawWindow
extends JSplitPane
implements EventClient {
    LTSCanvas output;
    EventManager eman;
    CompositeState cs;
    int[] lastEvent;
    int[] prevEvent;
    String lastName;
    int Nmach = 0;
    int hasC = 0;
    CompactState[] sm;
    boolean[] machineHasAction;
    boolean[] machineToDrawSet;
    public static boolean fontFlag = false;
    public static boolean singleMode = false;
    JList list;
    JScrollPane left;
    JScrollPane right;
    Font f1 = new Font("Monospaced", 0, 12);
    Font f2 = new Font("Monospaced", 1, 16);
    Font f3 = new Font("SansSerif", 0, 12);
    Font f4 = new Font("SansSerif", 1, 16);
    ImageIcon drawIcon = new ImageIcon(this.getClass().getResource("icon/draw.gif"));

    public LTSDrawWindow(CompositeState cs, EventManager eman) {
        this.eman = eman;
        this.output = new LTSCanvas(singleMode);
        JPanel outPane = new JPanel();
        outPane.setLayout(new BorderLayout());
        outPane.add("Center", this.output);
        this.right = new JScrollPane(outPane, 20, 30);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new PrintAction());
        this.list.setCellRenderer(new MyCellRenderer());
        this.left = new JScrollPane(this.list, 20, 30);
        JPanel fortools = new JPanel(new BorderLayout());
        fortools.add("Center", this.right);
        JToolBar tools = new JToolBar();
        tools.setOrientation(1);
        fortools.add("West", tools);
        tools.add(this.createTool("icon/stretchHorizontal.gif", "Stretch Horizontal", new HStretchAction(10)));
        tools.add(this.createTool("icon/compressHorizontal.gif", "Compress Horizontal", new HStretchAction(-10)));
        tools.add(this.createTool("icon/stretchVertical.gif", "Stretch Vertical", new VStretchAction(10)));
        tools.add(this.createTool("icon/compressVertical.gif", "Compress Vertical", new VStretchAction(-10)));
        if (eman != null) {
            eman.addClient(this);
        }
        this.new_machines(cs);
        this.setLeftComponent(this.left);
        this.setRightComponent(fortools);
        this.setDividerLocation(200);
        this.setBigFont(fontFlag);
        this.validate();
        this.output.addKeyListener(new KeyPress());
        this.output.addMouseListener(new MyMouse());
    }

    private int validMachine(int machine, int[] event) {
        if (event != null && machine < this.Nmach - this.hasC) {
            return event[machine];
        }
        return 0;
    }

    public void ltsAction(LTSEvent e) {
        switch (e.kind) {
            case 0: {
                this.prevEvent = this.lastEvent;
                this.lastEvent = (int[])e.info;
                this.lastName = e.name;
                this.output.select(this.Nmach - this.hasC, this.prevEvent, this.lastEvent, e.name);
                this.buttonHighlight(e.name);
                break;
            }
            case 1: {
                this.prevEvent = null;
                this.lastEvent = null;
                this.cs = (CompositeState)e.info;
                this.new_machines(this.cs);
                break;
            }
        }
    }

    private void buttonHighlight(String label) {
        if (label == null && this.machineHasAction != null) {
            int i = 0;
            while (i < this.machineHasAction.length) {
                this.machineHasAction[i] = false;
                ++i;
            }
        } else if (this.machineHasAction != null) {
            int i = 0;
            while (i < this.sm.length - this.hasC) {
                this.machineHasAction[i] = !label.equals("tau") && this.sm[i].hasLabel(label);
                ++i;
            }
        }
        this.list.repaint();
    }

    private void new_machines(CompositeState cs) {
        int i;
        int n = this.hasC = cs != null && cs.composition != null ? 1 : 0;
        if (cs != null && cs.machines != null && cs.machines.size() > 0) {
            this.sm = new CompactState[cs.machines.size() + this.hasC];
            Enumeration e = cs.machines.elements();
            i = 0;
            while (e.hasMoreElements()) {
                this.sm[i] = (CompactState)e.nextElement();
                ++i;
            }
            this.Nmach = this.sm.length;
            if (this.hasC == 1) {
                this.sm[this.Nmach - 1] = cs.composition;
            }
            this.machineHasAction = new boolean[this.Nmach];
            this.machineToDrawSet = new boolean[this.Nmach];
        } else {
            this.Nmach = 0;
            this.machineHasAction = null;
            this.machineToDrawSet = null;
        }
        DefaultListModel<String> lm = new DefaultListModel<String>();
        i = 0;
        while (i < this.Nmach) {
            if (this.hasC == 1 && i == this.Nmach - 1) {
                lm.addElement("||" + this.sm[i].name);
            } else {
                lm.addElement(this.sm[i].name);
            }
            ++i;
        }
        this.list.setModel(lm);
        this.output.setMachines(this.Nmach);
    }

    protected JButton createTool(String icon, String tip, ActionListener act) {
        JButton b = new JButton((Icon)new ImageIcon(this.getClass().getResource(icon))){

            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setToolTipText(tip);
        b.addActionListener(act);
        return b;
    }

    public void setBigFont(boolean b) {
        fontFlag = b;
        this.output.setBigFont(b);
    }

    public void setDrawName(boolean b) {
        this.output.setDrawName(b);
    }

    public void setNewLabelFormat(boolean b) {
        this.output.setNewLabelFormat(b);
    }

    public void setMode(boolean b) {
        singleMode = b;
        this.output.setMode(b);
        this.list.clearSelection();
        if (this.Nmach > 0) {
            this.machineToDrawSet = new boolean[this.Nmach];
        }
        this.list.repaint();
    }

    public void removeClient() {
        if (this.eman != null) {
            this.eman.removeClient(this);
        }
    }

    public void saveFile() {
        String fname;
        int colon;
        DrawMachine dm = this.output.getDrawing();
        if (dm == null) {
            JOptionPane.showMessageDialog(this, "No LTS picture selected to save");
            return;
        }
        FileDialog fd = new FileDialog((Frame)this.getTopLevelAncestor(), "Save file in:", 1);
        if (this.Nmach > 0 && (colon = (fname = dm.getMachine().name).indexOf(58, 0)) > 0) {
            fname = fname.substring(0, colon);
        }
        fd.show();
        String file = fd.getFile();
        if (file != null) {
            try {
                int i = file.indexOf(46, 0);
                file = String.valueOf(file.substring(0, i)) + "." + "pct";
                FileOutputStream fout = new FileOutputStream(String.valueOf(fd.getDirectory()) + file);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
                Rectangle r = new Rectangle(0, 0, dm.getSize().width, dm.getSize().height);
                Gr2PICT pict = new Gr2PICT((OutputStream)baos, this.output.getGraphics(), r);
                dm.fileDraw(pict);
                pict.finalize();
                fout.write(baos.toByteArray());
                fout.flush();
                fout.close();
            }
            catch (IOException e) {
                System.out.println("Error saving file: " + e);
            }
        }
    }

    class HStretchAction
    implements ActionListener {
        int increment;

        HStretchAction(int i) {
            this.increment = i;
        }

        public void actionPerformed(ActionEvent e) {
            if (LTSDrawWindow.this.output != null) {
                LTSDrawWindow.this.output.stretchHorizontal(this.increment);
            }
        }
    }

    class VStretchAction
    implements ActionListener {
        int increment;

        VStretchAction(int i) {
            this.increment = i;
        }

        public void actionPerformed(ActionEvent e) {
            if (LTSDrawWindow.this.output != null) {
                LTSDrawWindow.this.output.stretchVertical(this.increment);
            }
        }
    }

    class PrintAction
    implements ListSelectionListener {
        PrintAction() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() && !singleMode) {
                return;
            }
            int machine = LTSDrawWindow.this.list.getSelectedIndex();
            if (machine < 0 || machine >= LTSDrawWindow.this.Nmach) {
                return;
            }
            if (singleMode) {
                LTSDrawWindow.this.output.draw(machine, LTSDrawWindow.this.sm[machine], LTSDrawWindow.this.validMachine(machine, LTSDrawWindow.this.prevEvent), LTSDrawWindow.this.validMachine(machine, LTSDrawWindow.this.lastEvent), LTSDrawWindow.this.lastName);
            } else {
                if (!LTSDrawWindow.this.machineToDrawSet[machine]) {
                    LTSDrawWindow.this.output.draw(machine, LTSDrawWindow.this.sm[machine], LTSDrawWindow.this.validMachine(machine, LTSDrawWindow.this.prevEvent), LTSDrawWindow.this.validMachine(machine, LTSDrawWindow.this.lastEvent), LTSDrawWindow.this.lastName);
                    LTSDrawWindow.this.machineToDrawSet[machine] = true;
                } else {
                    LTSDrawWindow.this.output.clear(machine);
                    LTSDrawWindow.this.machineToDrawSet[machine] = false;
                }
                LTSDrawWindow.this.list.clearSelection();
            }
        }
    }

    class KeyPress
    extends KeyAdapter {
        KeyPress() {
        }

        public void keyPressed(KeyEvent k) {
            int m;
            if (LTSDrawWindow.this.output == null) {
                return;
            }
            int code = k.getKeyCode();
            if (code == 37) {
                LTSDrawWindow.this.output.stretchHorizontal(-5);
            } else if (code == 39) {
                LTSDrawWindow.this.output.stretchHorizontal(5);
            } else if (code == 38) {
                LTSDrawWindow.this.output.stretchVertical(-5);
            } else if (code == 40) {
                LTSDrawWindow.this.output.stretchVertical(5);
            } else if (code == 8 && (m = LTSDrawWindow.this.output.clearSelected()) >= 0) {
                LTSDrawWindow.this.machineToDrawSet[m] = false;
                LTSDrawWindow.this.list.repaint();
            }
        }
    }

    class MyMouse
    extends MouseAdapter {
        MyMouse() {
        }

        public void mouseEntered(MouseEvent e) {
            LTSDrawWindow.this.output.requestFocus();
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
            this.setHorizontalTextPosition(2);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(fontFlag ? LTSDrawWindow.this.f4 : LTSDrawWindow.this.f3);
            this.setText(value.toString());
            this.setBackground(isSelected ? Color.blue : Color.white);
            this.setForeground(isSelected ? Color.white : Color.black);
            if (LTSDrawWindow.this.machineHasAction != null && LTSDrawWindow.this.machineHasAction[index]) {
                this.setBackground(Color.red);
                this.setForeground(Color.white);
            }
            this.setForeground(isSelected ? Color.white : Color.black);
            this.setIcon(LTSDrawWindow.this.machineToDrawSet[index] && !singleMode ? LTSDrawWindow.this.drawIcon : null);
            return this;
        }
    }
}

