/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.custom;

import ic.doc.ltsa.custom.AnimationMessage;
import ic.doc.ltsa.custom.Relation;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ControlActionRegistry {
    Hashtable actionNumber = new Hashtable();
    Hashtable controlNumber = new Hashtable();
    Relation actionsToControls;
    Relation controlsToActions;
    int[][] controlMap;
    int[][] actionMap;
    String[] actionAlphabet;
    String[] controlAlphabet;
    boolean[] controlState;
    AnimationMessage msg;

    public ControlActionRegistry(Relation actionsToControls, AnimationMessage msg) {
        this.actionsToControls = actionsToControls;
        this.msg = msg;
    }

    void getAnimatorControls() {
        int index = 0;
        Vector<String> c = new Vector<String>();
        Enumeration e = this.controlsToActions.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.controlNumber.put(s, new Integer(index));
            c.addElement(s);
            ++index;
        }
        this.controlAlphabet = new String[index];
        c.copyInto(this.controlAlphabet);
    }

    public Vector getControls() {
        Vector<String> c = new Vector<String>();
        Enumeration e = this.actionsToControls.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            c.addElement(s);
        }
        return c;
    }

    public int controlled(String name) {
        Integer I = (Integer)this.actionNumber.get(name);
        if (I == null) {
            return -1;
        }
        return I;
    }

    void initMap(String[] alpha) {
        this.actionAlphabet = alpha;
        int i = 1;
        while (i < alpha.length) {
            this.actionNumber.put(alpha[i], new Integer(i));
            ++i;
        }
        Enumeration<Object> e = this.actionsToControls.keys();
        Vector<String> rr = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (this.actionNumber.get(s) != null) continue;
            rr.addElement(s);
        }
        e = rr.elements();
        while (e.hasMoreElements()) {
            this.actionsToControls.remove(e.nextElement());
        }
        this.controlsToActions = this.actionsToControls.inverse();
        this.getAnimatorControls();
        this.controlMap = new int[this.controlAlphabet.length][];
        this.controlState = new boolean[this.controlAlphabet.length];
        int i2 = 0;
        while (i2 < this.controlState.length) {
            this.controlState[i2] = true;
            ++i2;
        }
        this.initControlMap();
        this.initActionMap();
    }

    protected void initControlMap() {
        Enumeration e = this.controlsToActions.keys();
        while (e.hasMoreElements()) {
            int[] temp;
            String control = (String)e.nextElement();
            int ic = (Integer)this.controlNumber.get(control);
            Object actions = this.controlsToActions.get(control);
            if (actions instanceof String) {
                int ia = (Integer)this.actionNumber.get((String)actions);
                temp = new int[]{ia};
                this.controlMap[ic] = temp;
                continue;
            }
            Vector v = (Vector)actions;
            temp = new int[v.size()];
            Enumeration en = v.elements();
            int ii = 0;
            while (en.hasMoreElements()) {
                int ia;
                String s = (String)en.nextElement();
                temp[ii] = ia = ((Integer)this.actionNumber.get(s)).intValue();
                ++ii;
            }
            this.controlMap[ic] = temp;
        }
    }

    protected void initActionMap() {
        this.actionMap = new int[this.actionAlphabet.length][];
        Enumeration e = this.actionsToControls.keys();
        while (e.hasMoreElements()) {
            int[] temp;
            String action = (String)e.nextElement();
            int ia = (Integer)this.actionNumber.get(action);
            Object controls = this.actionsToControls.get(action);
            if (controls instanceof String) {
                int ic = (Integer)this.controlNumber.get((String)controls);
                temp = new int[]{ic};
                this.actionMap[ia] = temp;
                continue;
            }
            Vector v = (Vector)controls;
            temp = new int[v.size()];
            Enumeration en = v.elements();
            int ii = 0;
            while (en.hasMoreElements()) {
                int ic;
                String s = (String)en.nextElement();
                temp[ii] = ic = ((Integer)this.controlNumber.get(s)).intValue();
                ++ii;
            }
            this.actionMap[ia] = temp;
        }
    }

    void print() {
        int i = 0;
        while (i < this.controlMap.length) {
            System.out.println(this.controlAlphabet[i]);
            int j = 0;
            while (j < this.controlMap[i].length) {
                System.out.print(" " + this.actionAlphabet[this.controlMap[i][j]]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    void mapControl(String name, boolean[] enabled, boolean set) {
        String s = set ? "-enable-" : "-disabl-";
        this.msg.debugMsg("-control" + s + name);
        Integer II = (Integer)this.controlNumber.get(name);
        if (II == null) {
            return;
        }
        int ic = II;
        this.controlState[ic] = set;
        if (this.controlMap[ic] == null) {
            return;
        }
        int i = 0;
        while (i < this.controlMap[ic].length) {
            int ia = this.controlMap[ic][i];
            if (this.actionMap[ia].length == 1) {
                enabled[ia] = set;
            } else {
                boolean mask = set;
                int j = 0;
                while (j < this.actionMap[ia].length) {
                    mask = mask && this.controlState[this.actionMap[ia][j]];
                    ++j;
                }
                enabled[ia] = mask;
            }
            ++i;
        }
    }
}

