/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.CompositeBody;
import ic.doc.ltsa.lts.CompositeState;
import ic.doc.ltsa.lts.LTSOutput;
import ic.doc.ltsa.lts.LabelSet;
import ic.doc.ltsa.lts.StateMachine;
import ic.doc.ltsa.lts.Symbol;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CompositionExpression {
    Symbol name;
    CompositeBody body;
    Hashtable constants;
    Hashtable init_constants = new Hashtable();
    Vector parameters = new Vector();
    Hashtable processes;
    Hashtable compiledProcesses;
    Hashtable composites;
    LTSOutput output;
    boolean priorityIsLow = true;
    LabelSet priorityActions;
    LabelSet alphaHidden;
    boolean exposeNotHide = false;
    boolean makeDeterministic = false;
    boolean makeMinimal = false;
    boolean makeProperty = false;
    boolean makeCompose = false;

    CompositionExpression() {
    }

    CompositeState compose(Vector actuals) {
        Vector machines = new Vector();
        Hashtable locals = new Hashtable();
        this.constants = (Hashtable)this.init_constants.clone();
        if (actuals != null) {
            this.doParams(actuals);
        }
        this.body.compose(this, machines, locals);
        Vector flatmachines = new Vector();
        Enumeration e = machines.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o instanceof CompactState) {
                flatmachines.addElement(o);
                continue;
            }
            CompositeState cs = (CompositeState)o;
            Enumeration ee = cs.machines.elements();
            while (ee.hasMoreElements()) {
                flatmachines.addElement(ee.nextElement());
            }
        }
        String refname = actuals == null ? this.name.toString() : String.valueOf(this.name.toString()) + StateMachine.paramString(actuals);
        CompositeState c = new CompositeState(refname, flatmachines);
        c.priorityIsLow = this.priorityIsLow;
        c.priorityLabels = this.computeAlphabet(this.priorityActions);
        c.hidden = this.computeAlphabet(this.alphaHidden);
        c.exposeNotHide = this.exposeNotHide;
        c.makeDeterministic = this.makeDeterministic;
        c.makeMinimal = this.makeMinimal;
        c.makeCompose = this.makeCompose;
        if (this.makeProperty) {
            c.makeDeterministic = true;
            c.isProperty = true;
        }
        return c;
    }

    private void doParams(Vector actuals) {
        Enumeration a = actuals.elements();
        Enumeration f = this.parameters.elements();
        while (a.hasMoreElements() && f.hasMoreElements()) {
            this.constants.put(f.nextElement(), a.nextElement());
        }
    }

    private Vector computeAlphabet(LabelSet a) {
        if (a == null) {
            return null;
        }
        return a.getActions(this.constants);
    }
}

