/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Value;
import java.util.Hashtable;
import java.util.Stack;

public class Expression {
    static Hashtable constants;

    private static String labelVar(Stack s, Hashtable locals, Hashtable globals) {
        if (s == null) {
            return null;
        }
        if (s.empty()) {
            return null;
        }
        Symbol token = (Symbol)s.peek();
        if (token.kind == 124) {
            Value vr;
            if (locals != null && (vr = (Value)locals.get(token.toString())) != null && vr.isLabel()) {
                s.pop();
                return vr.toString();
            }
        } else if (token.kind == 123) {
            Value vr = null;
            if (globals != null) {
                vr = (Value)globals.get(token.toString());
            }
            if (vr == null) {
                vr = (Value)constants.get(token.toString());
            }
            if (vr != null && vr.isLabel()) {
                s.pop();
                return vr.toString();
            }
        } else {
            if (token.kind == 98) {
                ActionLabels el = (ActionLabels)token.getAny();
                if (el.hasMultipleValues()) {
                    Diagnostics.fatal("label constants cannot be sets", token);
                }
                el.initContext(locals, globals);
                s.pop();
                return el.nextName();
            }
            if (token.kind == 68) {
                return Expression.indexSet(s, locals, globals);
            }
        }
        return null;
    }

    protected static int countSet(Symbol token, Hashtable locals, Hashtable globals) {
        if (token.kind != 98) {
            Diagnostics.fatal("label set expected", token);
        }
        ActionLabels el = (ActionLabels)token.getAny();
        el.initContext(locals, globals);
        int count = 0;
        while (el.hasMoreNames()) {
            ++count;
            el.nextName();
        }
        el.clearContext();
        return count;
    }

    protected static String indexSet(Stack s, Hashtable locals, Hashtable globals) {
        s.pop();
        int index = Expression.eval(s, locals, globals);
        Symbol token = (Symbol)s.pop();
        if (token.kind != 98) {
            Diagnostics.fatal("label set expected", token);
        }
        ActionLabels el = (ActionLabels)token.getAny();
        el.initContext(locals, globals);
        int count = 0;
        String label = null;
        while (el.hasMoreNames()) {
            label = el.nextName();
            if (count == index) break;
            ++count;
        }
        el.clearContext();
        if (count != index) {
            Diagnostics.fatal("label set index expression out of range", token);
        }
        return label;
    }

    public static int evaluate(Stack s, Hashtable locals, Hashtable globals) {
        Stack mine = (Stack)s.clone();
        return Expression.eval(mine, locals, globals);
    }

    public static Value getValue(Stack s, Hashtable locals, Hashtable globals) {
        Stack mine = (Stack)s.clone();
        return Expression.getVal(mine, locals, globals);
    }

    private static Value getVal(Stack s, Hashtable locals, Hashtable globals) {
        String str = Expression.labelVar(s, locals, globals);
        if (str != null) {
            return new Value(str);
        }
        return new Value(Expression.eval(s, locals, globals));
    }

    private static int eval(Stack s, Hashtable locals, Hashtable globals) {
        Symbol token = (Symbol)s.pop();
        switch (token.kind) {
            case 125: {
                return token.intValue();
            }
            case 124: {
                Value variable;
                if (locals == null) {
                    Diagnostics.fatal("no variables defined", token);
                }
                if ((variable = (Value)locals.get(token.toString())) == null) {
                    Diagnostics.fatal("variable not defined- " + token, token);
                }
                if (variable.isLabel()) {
                    Diagnostics.fatal("not integer variable- " + token, token);
                }
                return variable.intValue();
            }
            case 123: {
                Value constant = null;
                if (globals != null) {
                    constant = (Value)globals.get(token.toString());
                }
                if (constant == null) {
                    constant = (Value)constants.get(token.toString());
                }
                if (constant == null) {
                    Diagnostics.fatal("constant or parameter not defined- " + token, token);
                }
                if (constant.isLabel()) {
                    Diagnostics.fatal("not integer constant or parameter- " + token, token);
                }
                return constant.intValue();
            }
            case 73: {
                return Expression.countSet((Symbol)s.pop(), locals, globals);
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                Value right = Expression.getVal(s, locals, globals);
                Value left = Expression.getVal(s, locals, globals);
                if (right.isInt() && left.isInt()) {
                    return Expression.exec_op(token.kind, left.intValue(), right.intValue());
                }
                if (token.kind == 52 || token.kind == 44) {
                    if (token.kind == 52) {
                        return left.toString().equals(right.toString()) ? 1 : 0;
                    }
                    return left.toString().equals(right.toString()) ? 0 : 1;
                }
                Diagnostics.fatal("invalid expression", token);
            }
            case 29: {
                return Expression.eval(s, locals, globals);
            }
            case 28: {
                return -Expression.eval(s, locals, globals);
            }
            case 45: {
                return Expression.eval(s, locals, globals) > 0 ? 0 : 1;
            }
        }
        Diagnostics.fatal("invalid expression", token);
        return 0;
    }

    private static int exec_op(int op, int left, int right) {
        switch (op) {
            case 30: {
                return left + right;
            }
            case 31: {
                return left - right;
            }
            case 32: {
                return left * right;
            }
            case 33: {
                return left / right;
            }
            case 34: {
                return left % right;
            }
            case 35: {
                return left ^ right;
            }
            case 43: {
                return left & right;
            }
            case 41: {
                return left | right;
            }
            case 48: {
                return left << right;
            }
            case 51: {
                return left >> right;
            }
            case 47: {
                return left < right ? 1 : 0;
            }
            case 46: {
                return left <= right ? 1 : 0;
            }
            case 50: {
                return left > right ? 1 : 0;
            }
            case 49: {
                return left >= right ? 1 : 0;
            }
            case 52: {
                return left == right ? 1 : 0;
            }
            case 44: {
                return left != right ? 1 : 0;
            }
            case 42: {
                return left != 0 && right != 0 ? 1 : 0;
            }
            case 40: {
                return left != 0 || right != 0 ? 1 : 0;
            }
        }
        return 0;
    }
}

