/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts;

import ic.doc.ltsa.lts.Alphabet;
import ic.doc.ltsa.lts.CompactState;
import ic.doc.ltsa.lts.EventState;
import ic.doc.ltsa.lts.LTSOutput;

public class PrintTransitions {
    CompactState sm;

    public PrintTransitions(CompactState sm) {
        this.sm = sm;
    }

    public void print(LTSOutput output) {
        this.print(output, 400);
    }

    public void print(LTSOutput output, int MAXPRINT) {
        int linecount = 0;
        output.outln("Process:");
        output.outln("\t" + this.sm.name);
        output.outln("States:");
        output.outln("\t" + this.sm.maxStates);
        output.outln("Transitions:");
        output.outln("\t" + this.sm.name + " = Q0,");
        int i = 0;
        while (i < this.sm.maxStates) {
            output.out("\tQ" + i + "\t= ");
            EventState current = EventState.transpose(this.sm.states[i]);
            if (current == null) {
                if (i == this.sm.endseq) {
                    output.out("END");
                } else {
                    output.out("STOP");
                }
                if (i < this.sm.maxStates - 1) {
                    output.outln(",");
                } else {
                    output.outln(".");
                }
            } else {
                output.out("(");
                while (current != null) {
                    if (++linecount > MAXPRINT) {
                        output.outln("EXCEEDED MAXPRINT SETTING");
                        return;
                    }
                    String[] events = EventState.eventsToNext(current, this.sm.alphabet);
                    Alphabet a = new Alphabet(events);
                    output.out(String.valueOf(a.toString()) + " -> ");
                    if (current.next < 0) {
                        output.out("ERROR");
                    } else {
                        output.out("Q" + current.next);
                    }
                    current = current.list;
                    if (current == null) {
                        if (i < this.sm.maxStates - 1) {
                            output.outln("),");
                            continue;
                        }
                        output.outln(").");
                        continue;
                    }
                    output.out("\n\t\t  |");
                }
            }
            ++i;
        }
    }
}

