/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.Value;
import ic.doc.ltsa.lts.ltl.AssertDefinition;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class FormulaSyntax {
    FormulaSyntax left;
    FormulaSyntax right;
    Symbol operator;
    Symbol proposition;
    ActionLabels range;
    ActionLabels action;
    Vector parameters;

    private FormulaSyntax(FormulaSyntax lt, Symbol op, FormulaSyntax rt, Symbol prop, ActionLabels r, ActionLabels a, Vector v) {
        this.left = lt;
        this.right = rt;
        this.operator = op;
        this.proposition = prop;
        this.range = r;
        this.action = a;
        this.parameters = v;
    }

    public static FormulaSyntax make(FormulaSyntax lt, Symbol op, FormulaSyntax rt) {
        return new FormulaSyntax(lt, op, rt, null, null, null, null);
    }

    public static FormulaSyntax make(Symbol prop) {
        return new FormulaSyntax(null, null, null, prop, null, null, null);
    }

    public static FormulaSyntax make(Symbol prop, ActionLabels r) {
        return new FormulaSyntax(null, null, null, prop, r, null, null);
    }

    public static FormulaSyntax make(Symbol prop, Vector v) {
        return new FormulaSyntax(null, null, null, prop, null, null, v);
    }

    public static FormulaSyntax makeE(Symbol op, Stack v) {
        return new FormulaSyntax(null, op, null, null, null, null, v);
    }

    public static FormulaSyntax make(ActionLabels a) {
        return new FormulaSyntax(null, null, null, null, null, a, null);
    }

    public static FormulaSyntax make(Symbol op, ActionLabels r, FormulaSyntax rt) {
        return new FormulaSyntax(null, op, rt, null, r, null, null);
    }

    public Formula expand(FormulaFactory fac, Hashtable locals, Hashtable globals) {
        if (this.proposition != null) {
            if (this.range == null) {
                if (PredicateDefinition.definitions != null && PredicateDefinition.definitions.containsKey(this.proposition.toString())) {
                    return fac.make(this.proposition);
                }
                AssertDefinition p = (AssertDefinition)AssertDefinition.definitions.get(this.proposition.toString());
                if (p == null) {
                    Diagnostics.fatal("LTL fluent or assertion not defined: " + this.proposition, this.proposition);
                }
                if (this.parameters == null) {
                    return p.ltl_formula.expand(fac, locals, p.init_params);
                }
                if (this.parameters.size() != p.params.size()) {
                    Diagnostics.fatal("Actual parameters do not match formals: " + this.proposition, this.proposition);
                }
                Hashtable actual_params = new Hashtable();
                Vector values = this.paramValues(this.parameters, locals, globals);
                int i = 0;
                while (i < this.parameters.size()) {
                    actual_params.put(p.params.elementAt(i), values.elementAt(i));
                    ++i;
                }
                return p.ltl_formula.expand(fac, locals, actual_params);
            }
            return fac.make(this.proposition, this.range, locals, globals);
        }
        if (this.action != null) {
            return fac.make(this.action, locals, globals);
        }
        if (this.operator.kind == 25) {
            return fac.make((Stack)this.parameters, locals, globals);
        }
        if (this.operator != null && this.range == null) {
            if (this.left == null) {
                return fac.make(null, this.operator, this.right.expand(fac, locals, globals));
            }
            return fac.make(this.left.expand(fac, locals, globals), this.operator, this.right.expand(fac, locals, globals));
        }
        if (this.range != null && this.right != null) {
            this.range.initContext(locals, globals);
            Formula f = null;
            while (this.range.hasMoreNames()) {
                this.range.nextName();
                f = f == null ? this.right.expand(fac, locals, globals) : (this.operator.kind == 42 ? fac.makeAnd(f, this.right.expand(fac, locals, globals)) : fac.makeOr(f, this.right.expand(fac, locals, globals)));
            }
            this.range.clearContext();
            return f;
        }
        return null;
    }

    private Vector paramValues(Vector paramExprs, Hashtable locals, Hashtable globals) {
        if (paramExprs == null) {
            return null;
        }
        Enumeration e = paramExprs.elements();
        Vector<Value> v = new Vector<Value>();
        while (e.hasMoreElements()) {
            Stack stk = (Stack)e.nextElement();
            v.addElement(Expression.getValue(stk, locals, globals));
        }
        return v;
    }
}

