/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Lex;
import ic.doc.ltsa.lts.Symbol;
import ic.doc.ltsa.lts.ltl.Formula;
import ic.doc.ltsa.lts.ltl.FormulaFactory;
import ic.doc.ltsa.lts.ltl.PredicateDefinition;

public class LTLparser {
    private Lex lex;
    private FormulaFactory fac;
    private Symbol current;

    public LTLparser(Lex l) {
        this.lex = l;
        this.fac = new FormulaFactory();
    }

    public FormulaFactory parse() {
        this.current = this.modify(this.lex.current());
        if (this.current == null) {
            this.next_symbol();
        }
        this.fac.setFormula(this.ltl_unary());
        return this.fac;
    }

    private Symbol next_symbol() {
        this.current = this.modify(this.lex.next_symbol());
        return this.current;
    }

    private void push_symbol() {
        this.lex.push_symbol();
    }

    private void current_is(int kind, String errorMsg) {
        if (this.current.kind != kind) {
            Diagnostics.fatal(errorMsg, this.current);
        }
    }

    private Symbol modify(Symbol s) {
        if (s.kind != 123) {
            return s;
        }
        if (s.toString().equals("X")) {
            Symbol nx = new Symbol(s);
            nx.kind = 23;
            return nx;
        }
        if (s.toString().equals("U")) {
            Symbol ut = new Symbol(s);
            ut.kind = 20;
            return ut;
        }
        return s;
    }

    private Formula ltl_unary() {
        Symbol op = this.current;
        switch (this.current.kind) {
            case 23: 
            case 45: 
            case 74: 
            case 75: {
                this.next_symbol();
                return this.fac.make(null, op, this.ltl_unary());
            }
            case 123: {
                this.next_symbol();
                if (!PredicateDefinition.contains(op)) {
                    Diagnostics.fatal("proposition not defined " + op, op);
                }
                return this.fac.make(op);
            }
            case 53: {
                this.next_symbol();
                Formula right = this.ltl_or();
                this.current_is(54, ") expected to end LTL expression");
                this.next_symbol();
                return right;
            }
        }
        Diagnostics.fatal("syntax error in LTL expression", this.current);
        return null;
    }

    private Formula ltl_and() {
        Formula left = this.ltl_unary();
        while (this.current.kind == 42) {
            Symbol op = this.current;
            this.next_symbol();
            Formula right = this.ltl_unary();
            left = this.fac.make(left, op, right);
        }
        return left;
    }

    private Formula ltl_or() {
        Formula left = this.ltl_binary();
        while (this.current.kind == 40) {
            Symbol op = this.current;
            this.next_symbol();
            Formula right = this.ltl_binary();
            left = this.fac.make(left, op, right);
        }
        return left;
    }

    private Formula ltl_binary() {
        Formula left = this.ltl_and();
        if (this.current.kind == 20 || this.current.kind == 69 || this.current.kind == 76) {
            Symbol op = this.current;
            this.next_symbol();
            Formula right = this.ltl_and();
            left = this.fac.make(left, op, right);
        }
        return left;
    }
}

