/*
 * Decompiled with CFR 0.152.
 */
package ic.doc.ltsa.lts.ltl;

import ic.doc.ltsa.lts.ActionLabels;
import ic.doc.ltsa.lts.Diagnostics;
import ic.doc.ltsa.lts.Expression;
import ic.doc.ltsa.lts.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;

public class PredicateDefinition {
    Symbol name;
    ActionLabels trueSet;
    ActionLabels falseSet;
    Vector trueActions;
    Vector falseActions;
    Stack expr;
    boolean initial;
    ActionLabels range;
    static Hashtable definitions;

    private PredicateDefinition(Symbol n, ActionLabels rng, ActionLabels ts, ActionLabels fs, Stack es) {
        this.name = n;
        this.range = rng;
        this.trueSet = ts;
        this.falseSet = fs;
        this.expr = es;
        this.initial = false;
    }

    PredicateDefinition(Symbol n, Vector TA, Vector FA) {
        this.name = n;
        this.trueActions = TA;
        this.falseActions = FA;
    }

    PredicateDefinition(String n, Vector TA, Vector FA, boolean init) {
        this.name = new Symbol(123, n);
        this.trueActions = TA;
        this.falseActions = FA;
        this.initial = init;
    }

    public static void put(Symbol n, ActionLabels rng, ActionLabels ts, ActionLabels fs, Stack es) {
        if (definitions == null) {
            definitions = new Hashtable();
        }
        if (definitions.put(n.toString(), new PredicateDefinition(n, rng, ts, fs, es)) != null) {
            Diagnostics.fatal("duplicate LTL predicate definition: " + n, n);
        }
    }

    public static boolean contains(Symbol n) {
        if (definitions == null) {
            return false;
        }
        return definitions.containsKey(n.toString());
    }

    public static void init() {
        definitions = null;
    }

    public static void compileAll() {
        if (definitions == null) {
            return;
        }
        ArrayList v = new ArrayList();
        v.addAll(definitions.values());
        Iterator e = v.iterator();
        while (e.hasNext()) {
            PredicateDefinition p = (PredicateDefinition)e.next();
            PredicateDefinition.compile(p);
        }
    }

    public static PredicateDefinition get(String n) {
        if (definitions == null) {
            return null;
        }
        PredicateDefinition p = (PredicateDefinition)definitions.get(n);
        if (p == null) {
            return null;
        }
        if (p.range != null) {
            return null;
        }
        return p;
    }

    public static Collection getAll() {
        if (definitions == null) {
            return null;
        }
        return definitions.values();
    }

    public static void compile(PredicateDefinition p) {
        if (p == null) {
            return;
        }
        if (p.range == null) {
            p.trueActions = p.trueSet.getActions(null, null);
            p.falseActions = p.falseSet.getActions(null, null);
            PredicateDefinition.assertDisjoint(p.trueActions, p.falseActions, p);
            if (p.expr != null) {
                int ev = Expression.evaluate(p.expr, null, null);
                p.initial = ev > 0;
            }
        } else {
            Hashtable locals = new Hashtable();
            p.range.initContext(locals, null);
            while (p.range.hasMoreNames()) {
                String s = p.range.nextName();
                Vector PA = p.trueSet.getActions(locals, null);
                Vector NA = p.falseSet.getActions(locals, null);
                boolean init = false;
                PredicateDefinition.assertDisjoint(PA, NA, p);
                if (p.expr != null) {
                    int ev = Expression.evaluate(p.expr, locals, null);
                    init = ev > 0;
                }
                String newName = p.name + "." + s;
                definitions.put(newName, new PredicateDefinition(newName, PA, NA, init));
            }
            p.range.clearContext();
        }
    }

    private static void assertDisjoint(Vector PA, Vector NA, PredicateDefinition p) {
        TreeSet s = new TreeSet(PA);
        s.retainAll(NA);
        if (!s.isEmpty()) {
            Diagnostics.fatal("Predicate " + p.name + " True & False sets must be disjoint", p.name);
        }
    }

    public int query(String s) {
        if (this.trueActions.contains(s)) {
            return 1;
        }
        if (this.falseActions.contains(s)) {
            return -1;
        }
        return 0;
    }

    public int initial() {
        return this.initial ? 1 : -1;
    }

    public String toString() {
        return this.name.toString();
    }

    public String getName() {
        return this.name.toString();
    }

    public Set getInitiatingActions() {
        return new HashSet(this.trueActions);
    }

    public Set getTerminatingActions() {
        return new HashSet(this.falseActions);
    }
}

