/*
 * Decompiled with CFR 0.152.
 */
package ltsaeclipse.views;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ltsaeclipse.editors.MultiPageEditor;
import ltsaeclipse.views.ExampleLabelProvider;
import ltsaeclipse.views.ExampleTask;
import ltsaeclipse.views.ExampleTaskList;
import ltsaeclipse.views.ExampleTaskSorter;
import ltsaeclipse.views.ITaskListViewer;
import ltsaeclipse.views.LTSADrawView;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class LTSACompositionTable {
    Composite parent;
    private String SourceLabel = "";
    private String sourcefile = "";
    private MultiPageEditor MPE;
    private Table table;
    private TableViewer tableViewer;
    private Button closeButton;
    private LTSADrawView drawView;
    private ISelectionChangedListener selectionChangeListener;
    private ExampleTaskList taskList = new ExampleTaskList();
    private final String COMPLETED_COLUMN = "Action";
    private final String DESCRIPTION_COLUMN = "Resource";
    private final String OWNER_COLUMN = "owner";
    private final String PERCENT_COLUMN = "percent";
    private String[] columnNames = new String[]{"Action", "Resource", "owner", "percent"};

    public LTSACompositionTable(Composite parentComp, LTSADrawView aDrawView, String sourcelabel) {
        this.addChildControls(parentComp);
        this.parent = parentComp;
        this.drawView = aDrawView;
        this.SourceLabel = sourcelabel;
    }

    private void run(Shell shell) {
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSACompositionTable.this.table.getParent().getParent().dispose();
            }
        });
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public MultiPageEditor GetMPE() {
        return this.MPE;
    }

    public void SetMPE(MultiPageEditor ampe) {
        this.MPE = ampe;
    }

    public void setChangeListener(ISelectionChangedListener listener) {
        this.selectionChangeListener = listener;
    }

    public void dispose() {
        this.tableViewer.getLabelProvider().dispose();
    }

    private void addChildControls(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new ExampleContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExampleLabelProvider());
        this.taskList = new ExampleTaskList();
        this.tableViewer.setInput((Object)this.taskList);
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText("!");
        column.setWidth(20);
        column = new TableColumn(this.table, 16384, 1);
        column.setText("Process Name");
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSACompositionTable.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText("BPEL4WS Source");
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSACompositionTable.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(2));
            }
        });
        column = new TableColumn(this.table, 16384, 3);
        column.setText("BPEL4WS WSDL");
        column.setWidth(200);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LTSACompositionTable.this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(2));
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        editors[0] = new CheckboxCellEditor((Composite)this.table);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.table);
        ((Text)textEditor.getControl()).setTextLimit(60);
        textEditor.setStyle(8);
        editors[1] = textEditor;
        editors[2] = new ComboBoxCellEditor((Composite)this.table, this.taskList.getOwners(), 0);
        TextCellEditor textEditor2 = new TextCellEditor((Composite)this.table);
        ((Text)textEditor2.getControl()).setTextLimit(60);
        textEditor2.setStyle(8);
        editors[3] = textEditor2;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setSorter((ViewerSorter)new ExampleTaskSorter(1));
    }

    public void close() {
        Shell shell = this.table.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.dispose();
        }
    }

    public String[] getChoices(String property) {
        if ("owner".equals(property)) {
            return this.taskList.getOwners();
        }
        return new String[0];
    }

    private void createButtons(Composite parent) {
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public ExampleTaskList getTaskList() {
        return this.taskList;
    }

    public Control getControl() {
        return this.table.getParent();
    }

    public Button getCloseButton() {
        return this.closeButton;
    }

    public void setActionList(LinkedList ActionList) {
        Iterator i = ActionList.iterator();
        while (i.hasNext()) {
            this.taskList.addTask((String)i.next(), "");
        }
    }

    public void clearActionList() {
        this.taskList.clearTasks();
    }

    public void updateRelabelList() {
        CellEditor[] editors = this.tableViewer.getCellEditors();
        ComboBoxCellEditor cbce = (ComboBoxCellEditor)editors[2];
        cbce.setItems(this.taskList.getOwners());
    }

    public void setSourceFile(String newsourcefile) {
        this.sourcefile = newsourcefile;
    }

    public String getSourceFile() {
        return this.sourcefile;
    }

    class ExampleContentProvider
    implements IStructuredContentProvider,
    ITaskListViewer {
        ExampleContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((ExampleTaskList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((ExampleTaskList)oldInput).removeChangeListener(this);
            }
        }

        public void dispose() {
            LTSACompositionTable.this.taskList.removeChangeListener(this);
        }

        public Object[] getElements(Object parent) {
            return LTSACompositionTable.this.taskList.getTasks().toArray();
        }

        public void addTask(ExampleTask task) {
            LTSACompositionTable.this.tableViewer.add((Object)task);
        }

        public void removeTask(ExampleTask task) {
            LTSACompositionTable.this.tableViewer.remove((Object)task);
        }

        public void clearTasks() {
        }

        public void updateTask(ExampleTask task) {
            LTSACompositionTable.this.tableViewer.update((Object)task, null);
        }
    }
}

