/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import javax.swing.event.MouseInputAdapter;
import mscedit.BMSCEditorCanvas;
import mscedit.DividerGraphic;
import mscedit.Glyph;

class CanvasMouseListener
extends MouseInputAdapter {
    private BMSCEditorCanvas o_canvas;
    private int o_clicks = 0;
    private Glyph o_moving;

    public CanvasMouseListener(BMSCEditorCanvas p_canvas) {
        this.o_canvas = p_canvas;
        this.o_moving = null;
    }

    public void mouseClicked(MouseEvent p_me) {
        if (p_me.getButton() == 1) {
            if (this.o_canvas.inAddDividerMode()) {
                this.o_canvas.addDivider((int)((double)p_me.getY() / Glyph.getScale()));
            } else if (this.o_canvas.inAddLinkMode()) {
                String x_inst_name = this.o_canvas.getInstanceAt(p_me.getX(), p_me.getY());
                if (x_inst_name == null) {
                    return;
                }
                if (this.o_clicks == 0) {
                    this.o_canvas.setOldSelection(x_inst_name);
                    Graphics2D x_gr = (Graphics2D)this.o_canvas.getGraphics();
                    double x_s = Glyph.getScale();
                    x_gr.setColor(Color.red);
                    x_gr.fill(new Ellipse2D.Float((int)((((double)p_me.getX() / x_s - 10.0) / 100.0 * 100.0 + 10.0) * x_s), (int)((((double)p_me.getY() / x_s - 50.0) / 25.0 * 25.0 + 50.0) * x_s), 5.0f, 5.0f));
                } else if (this.o_canvas.addPositive()) {
                    this.o_canvas.addLink(this.o_canvas.getOldSelection(), x_inst_name, (int)((double)p_me.getY() / Glyph.getScale()));
                } else {
                    this.o_canvas.addNegativeLink(this.o_canvas.getOldSelection(), x_inst_name, (int)((double)p_me.getY() / Glyph.getScale()));
                }
                this.o_clicks = 1 - this.o_clicks;
            } else {
                this.o_canvas.setSelection(this.o_canvas.getMessageAt(p_me.getX(), p_me.getY()));
            }
        }
        if (p_me.getButton() == 3) {
            this.o_canvas.showPopup(p_me);
        }
    }

    public void mouseDragged(MouseEvent p_me) {
        if (this.o_moving == null) {
            this.o_moving = this.o_canvas.getMessageAt(p_me.getX(), p_me.getY());
        } else {
            this.o_moving.moveTo((int)((double)p_me.getY() / Glyph.getScale()));
            this.o_canvas.repaint();
        }
    }

    public void mouseReleased(MouseEvent p_me) {
        if (this.o_moving != null) {
            this.o_moving.moveTo(p_me.getY());
            if (this.o_moving instanceof DividerGraphic) {
                this.o_canvas.moveDivider(Integer.parseInt(this.o_moving.getId()), ((int)((double)p_me.getY() / Glyph.getScale()) - 50) / 25);
            } else {
                this.o_canvas.moveMessage(this.o_moving.getId(), ((int)((double)p_me.getY() / Glyph.getScale()) - 50) / 25);
            }
            this.o_moving = null;
            this.o_canvas.rebuild();
        }
    }
}

