/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import java.awt.Frame;
import java.awt.Panel;
import java.io.File;
import java.util.LinkedList;
import ltsaeclipse.LTSAFunctions;
import ltsaeclipse.editors.MultiPageEditor;
import mscedit.Specification;
import mscedit.XMLGui;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import synthesis.ImpliedScenarioSynthesiser;

public class MSCEditorControl {
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private SashForm thisparentView;
    private XMLGui o_gui;
    Composite parent;
    public MultiPageEditor mpe;
    private ImpliedScenarioSynthesiser o_msccompiler;
    private LTSAFunctions myLTSA;
    private File p_file;

    public Control getControl() {
        return this.parent;
    }

    public MSCEditorControl(Composite parentComp) {
        this.parent = parentComp;
        if (parentComp != null) {
            this.addChildControls(parentComp);
        }
    }

    private void addChildControls(Composite composite) {
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        SashForm MappingSashForm = new SashForm(composite, 512);
        Composite compframe = new Composite((Composite)MappingSashForm, 0x1000000);
        Frame frame = SWT_AWT.new_Frame((Composite)compframe);
        new Panel();
        this.o_gui = new XMLGui();
        frame.add(this.o_gui);
        int operations = 19;
        DropTarget target = new DropTarget((Control)composite.getParent(), operations);
        TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        types = new Transfer[]{fileTransfer, textTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                new LinkedList();
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].endsWith(".xml")) {
                            MSCEditorControl.this.OpenSpecFile(new File(files[i]));
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public void OpenSpecFile(File new_file) {
        if (this.o_gui != null) {
            this.o_gui.openFile(new_file);
        }
        this.p_file = new_file;
    }

    public void SetSpecFile(File new_file) {
        this.p_file = new_file;
    }

    public void doSave(File save_file) {
        if (this.o_gui != null && this.p_file != null) {
            LTSAFunctions.saveToFile(this.o_gui.getSpecification().asXML(), save_file);
        }
    }

    public void SaveSpecFile() {
        this.doSave(this.p_file);
    }

    public Viewer getViewer() {
        return null;
    }

    private void hookContextMenu() {
    }

    private void contributeToActionBars() {
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                MSCEditorControl.this.mpe.doUpdateLTSEditor(MSCEditorControl.this.doSynthesise());
            }
        };
        this.action1.setText("&Synthesise");
        this.action1.setToolTipText("Synthesise MSC to FSP");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void hookDoubleClickAction() {
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)"MappingLTSView", (String)message);
    }

    public String doSynthesise() {
        Specification x_spec;
        String lts = "";
        if (this.o_msccompiler == null) {
            this.o_msccompiler = new ImpliedScenarioSynthesiser(new LTSAEclipseIO());
        }
        if ((x_spec = this.o_gui.getSpecification()) == null) {
            System.err.println("Specification return by gui is null");
        } else {
            String x_FSP_spec = this.o_msccompiler.run(x_spec);
            if (x_FSP_spec == null || x_FSP_spec.trim().equals("")) {
                System.out.println("empty string returned from msc compiler");
            } else {
                lts = x_FSP_spec;
            }
        }
        return lts;
    }

    public String doSynthesiseFromFile(File p_file) {
        Specification x_spec;
        String lts = "";
        if (this.o_msccompiler == null) {
            this.o_msccompiler = new ImpliedScenarioSynthesiser(new LTSAEclipseIO());
        }
        if ((x_spec = new Specification(LTSAFunctions.loadFromFile(p_file))) == null) {
            System.err.println("Specification return by gui is null");
        } else {
            String x_FSP_spec = this.o_msccompiler.run(x_spec);
            if (x_FSP_spec == null || x_FSP_spec.trim().equals("")) {
                System.out.println("empty string returned from msc compiler");
            } else {
                lts = x_FSP_spec;
            }
        }
        return lts;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    class LTSAEclipseIO
    implements LTSInput,
    LTSOutput {
        TextEditor texted = new TextEditor();
        String fSrc = "A = (test -> END). B = (test2 -> END). ||C = (A || B).";
        public int fPos;
        public String result;

        public void setFPos(int value) {
            this.fPos = value;
        }

        public char backChar() {
            --this.fPos;
            if (this.fPos < 0) {
                this.fPos = 0;
                return '\u0000';
            }
            return this.fSrc.charAt(this.fPos);
        }

        public char nextChar() {
            ++this.fPos;
            if (this.fPos < this.fSrc.length()) {
                return this.fSrc.charAt(this.fPos);
            }
            --this.fPos;
            return '\u0000';
        }

        public void out(String str) {
            this.result = String.valueOf(this.result) + str;
        }

        public void clearOutput() {
        }

        public void outln(String str) {
            this.result = String.valueOf(this.result) + str + "\n";
        }

        public void showOutput() {
        }

        public int getMarker() {
            return this.fPos;
        }
    }
}

