/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import ic.doc.ltsa.lts.LTSInput;
import ic.doc.ltsa.lts.LTSOutput;
import java.awt.Frame;
import java.awt.Panel;
import java.io.File;
import java.util.LinkedList;
import ltsaeclipse.FSPIStorage;
import ltsaeclipse.FSPIStorageEditorInput;
import ltsaeclipse.LTSAFunctions;
import ltsaeclipse.views.LTSACompositionTable;
import mscedit.Specification;
import mscedit.XMLGui;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.Document;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.ViewPart;
import synthesis.ImpliedScenarioSynthesiser;

public class MSCEditorView
extends ViewPart {
    private Action action1;
    private Action doubleClickAction;
    private Document doc;
    public LTSACompositionTable viewer;
    private XMLGui o_gui;
    SashForm MappingSashForm;
    private ImpliedScenarioSynthesiser o_msccompiler;
    private LTSAFunctions myLTSA;

    public void setFocus() {
        this.MappingSashForm.setFocus();
    }

    public Control getControl() {
        return this.MappingSashForm;
    }

    public void createPartControl(Composite parent) {
        new FillLayout();
        this.MappingSashForm = new SashForm(parent, 512);
        Composite composite = new Composite((Composite)this.MappingSashForm, 0x1000000);
        composite.setBounds(20, 20, 300, 200);
        Frame frame = SWT_AWT.new_Frame((Composite)composite);
        new Panel();
        this.o_gui = new XMLGui();
        frame.add(this.o_gui);
        int operations = 19;
        DropTarget target = new DropTarget((Control)composite.getParent(), operations);
        TextTransfer textTransfer = TextTransfer.getInstance();
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        types = new Transfer[]{fileTransfer, textTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                new LinkedList();
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    int i = 0;
                    while (i < files.length) {
                        if (files[i].endsWith(".xml")) {
                            MSCEditorView.this.o_gui.openFile(new File(files[i]));
                        }
                        ++i;
                    }
                }
            }
        });
        this.makeActions();
        this.contributeToActionBars();
    }

    private IEditorInput createEditorInputFromString(String contents) {
        FSPIStorage storage = new FSPIStorage(contents);
        FSPIStorageEditorInput input = new FSPIStorageEditorInput(storage);
        return input;
    }

    private void doSynthesise() {
        this.o_msccompiler = new ImpliedScenarioSynthesiser(new LTSAEclipseIO());
        Specification x_spec = this.o_gui.getSpecification();
        if (x_spec == null) {
            System.err.println("Specification return by gui is null");
        } else {
            String x_FSP_spec = this.o_msccompiler.run(x_spec);
            if (x_FSP_spec == null || x_FSP_spec.trim().equals("")) {
                System.out.println("empty string returned from msc compiler");
            } else {
                try {
                    this.getSite().getPage().openEditor(this.createEditorInputFromString(x_FSP_spec), "ltsaeclipse.editors.MultiPageEditor");
                }
                catch (Exception exception) {}
            }
        }
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                MSCEditorView.this.doSynthesise();
            }
        };
        this.action1.setText("&Synthesise");
        this.action1.setToolTipText("Synthesise MSC to FSP");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
    }

    class LTSAEclipseIO
    implements LTSInput,
    LTSOutput {
        TextEditor texted = new TextEditor();
        String fSrc = "A = (test -> END). B = (test2 -> END). ||C = (A || B).";
        public int fPos;
        public String result;

        public void setFPos(int value) {
            this.fPos = value;
        }

        public char backChar() {
            --this.fPos;
            if (this.fPos < 0) {
                this.fPos = 0;
                return '\u0000';
            }
            return this.fSrc.charAt(this.fPos);
        }

        public char nextChar() {
            ++this.fPos;
            if (this.fPos < this.fSrc.length()) {
                return this.fSrc.charAt(this.fPos);
            }
            --this.fPos;
            return '\u0000';
        }

        public void out(String str) {
            this.result = String.valueOf(this.result) + str;
        }

        public void clearOutput() {
        }

        public void outln(String str) {
            this.result = String.valueOf(this.result) + str + "\n";
        }

        public void showOutput() {
        }

        public int getMarker() {
            return this.fPos;
        }
    }
}

