/*
 * Decompiled with CFR 0.152.
 */
package mscedit;

import ic.doc.extension.LTSA;
import ic.doc.extension.LTSAButton;
import ic.doc.extension.LTSAPlugin;
import ic.doc.ltsa.lts.EventClient;
import ic.doc.ltsa.lts.LTSEvent;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mscedit.BMSC;
import mscedit.Link;
import mscedit.Specification;
import mscedit.XMLGui;
import org.jdom.output.XMLOutputter;
import synthesis.ImpliedScenarioSynthesiser;

public class MSCPlugin
extends LTSAPlugin
implements EventClient {
    private static MSCPlugin o_this;
    private XMLGui o_gui;
    private List o_toolbar_buttons;
    private Map o_menu_items;
    private JMenuBar o_menubar;
    private ImpliedScenarioSynthesiser o_msccompiler;
    private BMSC o_trace;
    private int o_trace_count = 0;

    public MSCPlugin() {
    }

    public MSCPlugin(LTSA p_ltsa) {
        super(p_ltsa);
    }

    public static MSCPlugin getInstance() {
        return o_this;
    }

    public void initialise() {
        o_this = this;
        this.o_gui = new XMLGui();
        this.o_msccompiler = new ImpliedScenarioSynthesiser(this.getLTSA());
        this.o_toolbar_buttons = new ArrayList();
        this.createButtons();
        this.o_menubar = new JMenuBar();
        this.o_menu_items = this.buildMenuItems();
        this.o_gui.populateMSCMenus(this.o_menubar, this.getLTSA());
    }

    public String getName() {
        return "MSC Editor";
    }

    public boolean addAsTab() {
        return true;
    }

    public Component getComponent() {
        return this.o_gui;
    }

    public boolean addToolbarButtons() {
        return true;
    }

    public List getToolbarButtons() {
        return this.o_toolbar_buttons;
    }

    public boolean addMenusToMenuBar() {
        return false;
    }

    public boolean useOwnMenuBar() {
        return false;
    }

    public JMenuBar getMenuBar() {
        return this.o_menubar;
    }

    public boolean providesNewFile() {
        return true;
    }

    public void newFile() {
        this.o_gui.newSpec();
    }

    public boolean providesOpenFile() {
        return true;
    }

    public void openFile(File p_file) {
        this.o_gui.openFile(p_file);
    }

    public boolean providesSaveFile() {
        return true;
    }

    public void saveFile(FileOutputStream p_fos) {
        this.o_gui.saveFile(p_fos);
    }

    public String getFileExtension() {
        return "xml";
    }

    public boolean addMenuItems() {
        return true;
    }

    public Map getMenuItems() {
        return this.o_menu_items;
    }

    private void createButtons() {
        ImageIcon x_icon = new ImageIcon(this.getClass().getResource("/mscedit/icon/msc.gif"));
        LTSAButton x_button = new LTSAButton(x_icon, "Compile MSC", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MSCPlugin.this.compilemsc();
            }
        });
        this.o_toolbar_buttons.add(x_button);
        x_icon = new ImageIcon(this.getClass().getResource("/mscedit/icon/mscsafe.gif"));
        x_button = new LTSAButton(x_icon, "Safety check MSC", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MSCPlugin.this.safetyCheckMSC();
            }
        });
        this.o_toolbar_buttons.add(x_button);
    }

    private void compilemsc() {
        this.compilemsc(true);
    }

    private void compilemsc(boolean p_showoutput) {
        LTSA x_ltsa = this.getLTSA();
        x_ltsa.getUndoManager().discardAllEdits();
        x_ltsa.invalidateState();
        x_ltsa.clearOutput();
        Specification x_spec = this.o_gui.getSpecification();
        if (x_spec == null) {
            System.err.println("Specification return by gui is null");
        } else {
            String x_FSP_spec = this.o_msccompiler.run(x_spec);
            if (x_FSP_spec == null || x_FSP_spec.trim().equals("")) {
                System.out.println("empty string returned from msc compiler");
            }
            if (x_FSP_spec != null) {
                x_ltsa.clearInternalBuffer();
                x_ltsa.appendInternalBuffer(x_FSP_spec);
                if (p_showoutput) {
                    x_ltsa.showOutput();
                }
                x_ltsa.parse();
                x_ltsa.setTargetChoice("ImpliedScenarioCheck");
                x_ltsa.updateDoState();
            }
        }
    }

    private void safetyCheckMSC() {
        this.compilemsc(false);
        LTSA x_ltsa = this.getLTSA();
        x_ltsa.setTargetChoice("ImpliedScenarioCheck");
        x_ltsa.compileNoClear();
        if (!x_ltsa.isCurrentStateNull()) {
            if (!x_ltsa.isCurrentStateComposed()) {
                x_ltsa.composeCurrentState();
                x_ltsa.analyseCurrentState();
                Vector x_trace = x_ltsa.getCurrentStateErrorTrace();
                if (x_trace != null) {
                    BMSC x_imp_scen = this.createImpliedScenarioBMSC(x_trace);
                    this.o_gui.addBMSC(x_imp_scen);
                    x_ltsa.swapto("MSC Editor");
                    int x_pos_neg = this.classifyScenario();
                    if (x_pos_neg < 0) {
                        this.o_gui.setNegCount(this.o_gui.getNegCount() + 1);
                        x_imp_scen.setName("NegScen" + this.o_gui.getNegCount());
                        x_imp_scen.negateLastMessage();
                        this.o_gui.renameTab("ImpScen", "NegScen" + this.o_gui.getNegCount());
                        this.o_gui.redrawCurrentCanvas();
                    } else if (x_pos_neg > 0) {
                        String x_new_name = JOptionPane.showInputDialog(null, "Give the scenario a name:", "Name scenario", 3);
                        x_imp_scen.setName(x_new_name);
                        this.o_gui.renameTab("ImpScen", x_new_name);
                        this.o_gui.addBMSCtoHMSC(x_imp_scen);
                    } else {
                        this.o_gui.deleteBMSC(x_imp_scen.getName());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "No Implied Scenarios");
                    x_ltsa.outln("NO IMPLIED SCENARIOS");
                }
            }
            x_ltsa.postCurrentState();
        }
    }

    private BMSC createImpliedScenarioBMSC(List p_imp_scen_msgs) {
        List x_all_links = this.o_gui.getSpecification().getAllLinks();
        BMSC x_imp_scen = new BMSC("ImpScen");
        Iterator i = this.o_gui.getInstanceAlphabet().iterator();
        while (i.hasNext()) {
            x_imp_scen.addInstance((String)i.next());
        }
        int x_ti = 1;
        Iterator i2 = p_imp_scen_msgs.iterator();
        block1: while (i2.hasNext()) {
            String x_name = (String)i2.next();
            x_name = x_name.replace('.', ',');
            Iterator j = x_all_links.iterator();
            while (j.hasNext()) {
                Link x_link = (Link)j.next();
                if (!x_name.equals(x_link.getName())) continue;
                x_imp_scen.addLink(x_link.getFrom(), x_link.getTo(), x_name, x_ti);
                ++x_ti;
                continue block1;
            }
        }
        return x_imp_scen;
    }

    private int classifyScenario() {
        Object[] options = new Object[]{"Positive", "Negative", "Ignore"};
        int n = JOptionPane.showOptionDialog(null, "Classify this scenario as positive or negative - or ignore it?", "Implied Scenario", 1, 3, null, options, options[0]);
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return -1;
        }
        return 0;
    }

    private Map buildMenuItems() {
        HashMap<JMenuItem, String> x_map = new HashMap<JMenuItem, String>();
        JCheckBoxMenuItem x_item = new JCheckBoxMenuItem("MSC Editor: Large display");
        x_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent p_e) {
                MSCPlugin.this.o_gui.setBigFont(((JCheckBoxMenuItem)p_e.getSource()).isSelected());
            }
        });
        x_map.put(x_item, "Options");
        x_item = new JCheckBoxMenuItem("MSC Editor: Show toolbar");
        x_item.setSelected(true);
        x_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent p_e) {
                MSCPlugin.this.o_gui.showToolBar(((JCheckBoxMenuItem)p_e.getSource()).isSelected());
            }
        });
        x_map.put(x_item, "Options");
        JMenuItem x_testitem = new JMenuItem("test");
        x_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent p_e) {
                MSCPlugin.this.getLTSA().analyseCurrentStateNoDeadlockCheck();
            }
        });
        x_map.put(x_testitem, "Options");
        return x_map;
    }

    public String getFSPforComponent(String p_name, Map p_mapping) {
        return this.o_msccompiler.getFSPforComponent(p_name, this.o_gui.getSpecification(), this.getLTSA(), p_mapping);
    }

    public String getSpecAsXML() {
        return new XMLOutputter().outputString(this.o_gui.getSpecification().asXML());
    }

    public Set getMessageLabels(String p_component) {
        return this.o_msccompiler.getMessageLabels(p_component, this.o_gui.getSpecification(), this.getLTSA());
    }

    public void ltsAction(LTSEvent p_event) {
        block6: {
            try {
                if (p_event.name != null) {
                    if (this.o_trace == null) {
                        this.newTrace();
                    }
                    List x_all_links = this.o_gui.getSpecification().getAllLinks();
                    String x_name = p_event.name;
                    String x_dots2commas = x_name.replace('.', ',');
                    Iterator j = x_all_links.iterator();
                    while (j.hasNext()) {
                        Link x_link = (Link)j.next();
                        if (!x_dots2commas.equals(x_link.getName())) continue;
                        this.o_trace.addLink(x_link.getFrom(), x_link.getTo(), x_link.getName(), this.o_trace_count);
                        this.o_trace_count = x_link.isSelfTransition() ? (this.o_trace_count += 3) : ++this.o_trace_count;
                        this.o_gui.rebuildTab("Trace");
                        break block6;
                    }
                    break block6;
                }
                if (p_event.kind == 0) {
                    this.newTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void newTrace() {
        this.o_trace = new BMSC("Trace");
        this.o_trace_count = 1;
        Iterator i = this.o_gui.getInstanceAlphabet().iterator();
        while (i.hasNext()) {
            this.o_trace.addInstance((String)i.next());
        }
        this.o_gui.deleteBMSC("Trace");
        this.o_gui.addBMSC(this.o_trace);
    }
}

