/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.arc.ase.ltl;

import gov.nasa.arc.ase.ltl.Transition;
import gov.nasa.arc.ase.util.graph.Node;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;

class State
implements Comparable {
    private int representativeId = -1;
    private LinkedList transitions = new LinkedList();
    private BitSet accepting;
    private boolean safety_acceptance;

    public State(BitSet bitSet) {
        this.accepting = bitSet;
        this.safety_acceptance = false;
    }

    public State(BitSet bitSet, int n) {
        this.accepting = bitSet;
        this.safety_acceptance = false;
        this.representativeId = n;
    }

    public State() {
        this.accepting = null;
        this.safety_acceptance = false;
    }

    public State(int n) {
        this.accepting = null;
        this.safety_acceptance = false;
        this.representativeId = n;
    }

    public void set_representativeId(int n) {
        this.representativeId = n;
    }

    public int get_representativeId() {
        return this.representativeId;
    }

    public void update_safety_acc(boolean bl) {
        this.safety_acceptance = bl;
    }

    public boolean is_safe() {
        return this.safety_acceptance;
    }

    public boolean accepts(int n) {
        return !this.accepting.get(n);
    }

    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        return 1;
    }

    public void update_acc(BitSet bitSet) {
        this.accepting = bitSet;
    }

    public void update_acc(BitSet bitSet, int n) {
        this.accepting = bitSet;
        this.representativeId = n;
    }

    public void add(Transition transition) {
        this.transitions.add(transition);
    }

    public void step(Hashtable hashtable, TreeSet treeSet, State[] stateArray) {
        ListIterator listIterator = this.transitions.listIterator(0);
        while (listIterator.hasNext()) {
            Transition transition = (Transition)listIterator.next();
            if (!transition.enabled(hashtable)) continue;
            treeSet.add(stateArray[transition.goesTo()]);
        }
    }

    public void FSPoutput() {
        ListIterator listIterator = this.transitions.listIterator(0);
        boolean bl = true;
        while (listIterator.hasNext()) {
            Transition transition = (Transition)listIterator.next();
            if (bl) {
                System.out.print("(");
                bl = false;
            } else {
                System.out.print("|");
            }
            transition.FSPoutput();
        }
    }

    public void SMoutput(Node[] nodeArray, Node node) {
        ListIterator listIterator = this.transitions.listIterator(0);
        boolean bl = true;
        while (listIterator.hasNext()) {
            Transition transition = (Transition)listIterator.next();
            transition.SMoutput(nodeArray, node);
        }
    }
}

